/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;

public class TimeUtil {
    static final long[] jtimes;
    static final int[] leapSecondIds;
    static final long[] tt_times;
    static final int highest;
    static SimpleDateFormat sdf;
    public static final long TT_JANUARY_1_1970 = -946727957816000000L;
    static final long JANUARY_1_1972;
    static final int lastLeapSecondId;
    static Calendar cal;

    public static double getOffset(long l) throws Throwable {
        double d;
        if (l < JANUARY_1_1972) {
            throw new Throwable("Times before January 1, 1972 are not supported at present");
        }
        if (l < jtimes[0]) {
            d = l;
        } else {
            d = -1.0;
            for (int i = 0; i < jtimes.length - 1; ++i) {
                if (l >= jtimes[i + 1]) continue;
                d = l + (long)((i + 1) * 1000);
                break;
            }
            if (d < 0.0) {
                d = l + (long)highest;
            }
        }
        return d;
    }

    public static double milliSecondSince1970(Date date) throws Throwable {
        return TimeUtil.milliSecondSince1970(date.getTime());
    }

    public static double milliSecondSince1970(long l) throws Throwable {
        if (l < JANUARY_1_1972) {
            throw new Throwable("Times before January 1, 1972 are not supported at present");
        }
        for (int i = jtimes.length - 1; i >= 0; --i) {
            if (l <= jtimes[i]) continue;
            return l + (long)((i + 1) * 1000);
        }
        return l;
    }

    public static long tt2000(long l) throws Throwable {
        return -946727957816000000L + 1000000L * (long)TimeUtil.milliSecondSince1970(l);
    }

    public static long tt2000(Date date) throws Throwable {
        return -946727957816000000L + 1000000L * (long)TimeUtil.milliSecondSince1970(date);
    }

    public static long milliSecondSince1970(int[] nArray) throws Throwable {
        return TimeUtil.milliSecondSince1970(nArray, false);
    }

    static long milliSecondSince1970(int[] nArray, boolean bl) throws Throwable {
        int n;
        int[] nArray2 = new int[6];
        for (n = 0; n < 3; ++n) {
            nArray2[n] = nArray[n];
        }
        nArray2[1] = nArray2[1] - 1;
        for (n = 3; n < 6; ++n) {
            nArray2[n] = 0;
        }
        n = nArray.length;
        if (n >= 4) {
            nArray2[3] = nArray[3];
            if (n >= 5) {
                nArray2[4] = nArray[4];
                if (n >= 6) {
                    nArray2[5] = nArray[5];
                }
            }
        }
        int n2 = 0;
        if (nArray2[5] == 60) {
            if (!bl) {
                throw new Throwable("second value 60 is valid for tt2000 only.");
            }
            int n3 = -1;
            if (nArray2[4] == 59 && nArray2[3] == 23) {
                if (nArray[2] == 30 && nArray[1] == 6) {
                    n3 = nArray[0] * 10000 + 701;
                } else if (nArray[2] == 31 && nArray[1] == 12) {
                    n3 = (1 + nArray[0]) * 10000 + 101;
                }
            }
            if (n3 == -1) {
                throw new Throwable("Invalid leap second time");
            }
            for (int i = leapSecondIds.length - 1; i >= 0; --i) {
                if (n3 != leapSecondIds[i]) continue;
                n2 = 1000000000;
                break;
            }
            if (n2 == 0) {
                throw new Throwable("Invalid leap second time");
            }
            nArray2[5] = 59;
        }
        cal.clear();
        cal.set(nArray2[0], nArray2[1], nArray2[2], nArray2[3], nArray2[4], nArray2[5]);
        cal.set(14, n > 6 ? nArray[6] : 0);
        return cal.getTimeInMillis();
    }

    public static long tt2000(int[] nArray) throws Throwable {
        long l = TimeUtil.milliSecondSince1970(nArray, true);
        int n = 0;
        if (nArray.length >= 6 && nArray[5] == 60) {
            n = 1000000000;
        }
        return (long)n + TimeUtil.tt2000(l);
    }

    static {
        int n;
        sdf = new SimpleDateFormat("y'-'M'-'dd'T'HH:mm:ss.SSS");
        JANUARY_1_1972 = Date.UTC(72, 0, 1, 0, 0, 0);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        boolean[][] blArray = new boolean[100][2];
        blArray[2][0] = true;
        blArray[2][1] = true;
        blArray[3][1] = true;
        blArray[4][1] = true;
        blArray[5][1] = true;
        blArray[6][1] = true;
        blArray[7][1] = true;
        blArray[8][1] = true;
        blArray[9][1] = true;
        blArray[11][0] = true;
        blArray[12][0] = true;
        blArray[13][0] = true;
        blArray[15][0] = true;
        blArray[17][1] = true;
        blArray[19][1] = true;
        blArray[20][1] = true;
        blArray[22][0] = true;
        blArray[23][0] = true;
        blArray[24][0] = true;
        blArray[25][1] = true;
        blArray[27][0] = true;
        blArray[28][1] = true;
        blArray[35][1] = true;
        blArray[38][1] = true;
        blArray[42][0] = true;
        blArray[45][0] = true;
        Vector<Long> vector = new Vector<Long>();
        Vector<Integer> vector2 = new Vector<Integer>();
        for (n = 0; n < blArray.length; ++n) {
            if (blArray[n][0]) {
                vector.add(new Long(Date.UTC(70 + n, 5, 30, 23, 59, 59)));
                vector2.add(new Integer((1970 + n) * 10000 + 701));
            }
            if (!blArray[n][1]) continue;
            vector.add(new Long(Date.UTC(70 + n, 11, 31, 23, 59, 59)));
            vector2.add(new Integer((1971 + n) * 10000 + 101));
        }
        jtimes = new long[vector.size()];
        tt_times = new long[vector.size()];
        leapSecondIds = new int[vector.size()];
        for (n = 0; n < jtimes.length; ++n) {
            TimeUtil.jtimes[n] = (Long)vector.get(n);
            TimeUtil.leapSecondIds[n] = (Integer)vector2.get(n);
            try {
                TimeUtil.tt_times[n] = TimeUtil.tt2000(jtimes[n]);
                continue;
            }
            catch (Throwable throwable) {
                System.out.println("Internal error.");
            }
        }
        highest = 1000 * jtimes.length;
        lastLeapSecondId = leapSecondIds[leapSecondIds.length - 1];
        cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    }

    public static class Validator {
        public static long correctedIfNecessary(long l, int n) throws Throwable {
            if (n == lastLeapSecondId) {
                return l;
            }
            if (n < lastLeapSecondId) {
                int n2;
                int n3 = -1;
                for (n2 = leapSecondIds.length - 1; n2 >= 0; --n2) {
                    if (n != leapSecondIds[n2]) continue;
                    n3 = n2;
                    break;
                }
                if (n3 < 0) {
                    throw new Throwable("Invalid leapId");
                }
                if (l < tt_times[n3 + 1]) {
                    return l;
                }
                for (n2 = n3 + 1; n2 < jtimes.length - 1 && l >= tt_times[n2 + 1]; ++n2) {
                }
                return l + (long)(n2 - n3) * 1000000000L;
            }
            if (l < tt_times[jtimes.length - 1]) {
                return l;
            }
            throw new Throwable("Out of date Leap second table");
        }
    }
}

