/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class DataTypes {
    public static final int ENCODING_COUNT = 17;
    static final ByteOrder[] endian_ness;
    public static final int EPOCH16 = 32;
    public static final int CDF_TIME_TT2000 = 33;
    public static final int FLOAT = 0;
    public static final int DOUBLE = 1;
    public static final int SIGNED_INTEGER = 2;
    public static final int UNSIGNED_INTEGER = 3;
    public static final int STRING = 4;
    public static final int LONG = 5;
    public static final int LAST_TYPE = 53;
    static final Method[] method;
    static final int[] typeCategory;
    static final int[] size;
    static final long[] longInt;

    public DataTypes() {
        Class<?> clazz = this.getClass();
        try {
            Method method;
            DataTypes.method[51] = method = clazz.getMethod("getString", ByteBuffer.class, Integer.class);
            DataTypes.method[52] = method;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getString(ByteBuffer byteBuffer, Integer n) {
        int n2;
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byte[] byArray = new byte[n.intValue()];
        for (n2 = 0; n2 < byArray.length; ++n2) {
            byArray[n2] = byteBuffer2.get();
            if (byArray[n2] == 0) break;
        }
        return new String(byArray, 0, n2);
    }

    public static ByteOrder getByteOrder(int n) throws Throwable {
        if (endian_ness[n] != null) {
            return endian_ness[n];
        }
        throw new Throwable("Unsupported encoding " + n);
    }

    public static boolean isStringType(int n) {
        return typeCategory[n] == 4;
    }

    public static boolean isLongType(int n) {
        return typeCategory[n] == 5;
    }

    public static Object defaultPad(int n) {
        if (DataTypes.isLongType(n)) {
            return new Long(-9223372036854775807L);
        }
        if (DataTypes.isStringType(n)) {
            return new Byte(" ".getBytes()[0]);
        }
        return new Double(0.0);
    }

    static {
        int n;
        endian_ness = new ByteOrder[17];
        for (n = 0; n < 17; ++n) {
            DataTypes.endian_ness[n] = null;
        }
        DataTypes.endian_ness[1] = ByteOrder.BIG_ENDIAN;
        DataTypes.endian_ness[2] = ByteOrder.BIG_ENDIAN;
        DataTypes.endian_ness[4] = ByteOrder.LITTLE_ENDIAN;
        DataTypes.endian_ness[5] = ByteOrder.BIG_ENDIAN;
        DataTypes.endian_ness[6] = ByteOrder.LITTLE_ENDIAN;
        DataTypes.endian_ness[7] = ByteOrder.BIG_ENDIAN;
        DataTypes.endian_ness[9] = ByteOrder.BIG_ENDIAN;
        DataTypes.endian_ness[12] = ByteOrder.BIG_ENDIAN;
        DataTypes.endian_ness[13] = ByteOrder.LITTLE_ENDIAN;
        DataTypes.endian_ness[16] = ByteOrder.LITTLE_ENDIAN;
        method = new Method[53];
        typeCategory = new int[53];
        size = new int[53];
        longInt = new long[53];
        for (n = 0; n < 53; ++n) {
            DataTypes.method[n] = null;
            DataTypes.size[n] = 1;
            DataTypes.typeCategory[n] = -1;
        }
        Class<ByteBuffer> clazz = ByteBuffer.class;
        try {
            Method method;
            DataTypes.method[1] = method = clazz.getMethod("get", new Class[0]);
            DataTypes.typeCategory[1] = 2;
            DataTypes.method[11] = method;
            DataTypes.typeCategory[11] = 3;
            DataTypes.method[41] = method;
            DataTypes.typeCategory[41] = 2;
            DataTypes.method[2] = method = clazz.getMethod("getShort", new Class[0]);
            DataTypes.typeCategory[2] = 2;
            DataTypes.size[2] = 2;
            DataTypes.method[12] = method;
            DataTypes.typeCategory[12] = 3;
            DataTypes.size[12] = 2;
            DataTypes.method[4] = method = clazz.getMethod("getInt", new Class[0]);
            DataTypes.typeCategory[4] = 2;
            DataTypes.size[4] = 4;
            DataTypes.method[14] = method;
            DataTypes.typeCategory[14] = 3;
            DataTypes.size[14] = 4;
            DataTypes.method[8] = method = clazz.getMethod("getLong", new Class[0]);
            DataTypes.typeCategory[8] = 5;
            DataTypes.size[8] = 8;
            DataTypes.method[33] = method;
            DataTypes.typeCategory[33] = 5;
            DataTypes.size[33] = 8;
            DataTypes.method[21] = method = clazz.getMethod("getFloat", new Class[0]);
            DataTypes.typeCategory[21] = 0;
            DataTypes.size[21] = 4;
            DataTypes.method[44] = method;
            DataTypes.typeCategory[44] = 0;
            DataTypes.size[44] = 4;
            DataTypes.method[22] = method = clazz.getMethod("getDouble", new Class[0]);
            DataTypes.typeCategory[22] = 1;
            DataTypes.size[22] = 8;
            DataTypes.method[45] = method;
            DataTypes.typeCategory[45] = 1;
            DataTypes.size[45] = 8;
            DataTypes.method[31] = method;
            DataTypes.typeCategory[31] = 1;
            DataTypes.size[31] = 8;
            DataTypes.method[32] = method;
            DataTypes.typeCategory[32] = 1;
            DataTypes.size[32] = 8;
            DataTypes.typeCategory[41] = 2;
            DataTypes.typeCategory[51] = 4;
            DataTypes.typeCategory[52] = 4;
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < 53; ++i) {
            if (size[i] > 4) continue;
            DataTypes.longInt[i] = 1L << 8 * size[i];
        }
    }
}

