/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.CDFImpl;
import gov.nasa.gsfc.spdf.cdfj.DataTypes;
import gov.nasa.gsfc.spdf.cdfj.Stride;
import gov.nasa.gsfc.spdf.cdfj.Variable;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Vector;

public abstract class BaseVarContainer
implements Runnable {
    static final int chunkSize = 1024;
    final CDFImpl thisCDF;
    final Variable var;
    final int[] pt;
    final int[] overlap;
    final int type;
    final int itemSize;
    final int elements;
    final ByteOrder order;
    final Class _class;
    final int recordsPerChunk;
    final int csize;
    final boolean chunking;
    final Vector buffers = new Vector();
    final int fillCount;
    final boolean singlePoint;
    Boolean allocationMode;
    ByteBuffer userBuffer;

    protected BaseVarContainer(CDFImpl cDFImpl, Variable variable, int[] nArray, boolean bl, ByteOrder byteOrder, Class clazz) throws IllegalAccessException, InvocationTargetException, Throwable {
        this.type = variable.getType();
        if (!BaseVarContainer.isCompatible(this.type, bl, clazz)) {
            throw new Throwable("Variable " + variable.getName() + " may result in loss of precision");
        }
        this.thisCDF = cDFImpl;
        this.var = variable;
        this.order = byteOrder;
        this._class = clazz;
        this.itemSize = variable.getDataItemSize();
        this.elements = this.itemSize / DataTypes.size[this.type];
        int[] nArray2 = variable.getRecordRange();
        if (nArray2 == null) {
            throw new Throwable("Variable " + variable.getName() + " has no " + "records.");
        }
        if (nArray == null) {
            this.singlePoint = false;
            this.pt = nArray2;
        } else {
            int[] nArray3;
            boolean bl2 = this.singlePoint = nArray.length == 1;
            if (nArray.length == 1) {
                int[] nArray4 = new int[2];
                nArray4[0] = nArray[0];
                nArray3 = nArray4;
                nArray4[1] = nArray[0];
            } else {
                int[] nArray5 = new int[2];
                nArray5[0] = nArray[0];
                nArray3 = nArray5;
                nArray5[1] = nArray[1];
            }
            this.pt = nArray3;
        }
        int n = 0;
        int[] nArray6 = null;
        if (nArray != null) {
            if (variable.recordVariance()) {
                if (nArray[0] < 0) {
                    throw new Throwable("Negative start of Record Range ");
                }
                if (nArray.length > 1 && nArray[0] > nArray[1]) {
                    throw new Throwable("Invalid record Range first " + nArray[0] + ", last " + nArray[1]);
                }
                if (!variable.missingRecordValueIsPad() && !variable.missingRecordValueIsPrevious()) {
                    if (nArray2[0] > nArray[0] || nArray2[1] < nArray[0]) {
                        throw new Throwable("Invalid start of Record Range " + nArray[0] + ". Available record range is " + nArray2[0] + " - " + nArray2[1]);
                    }
                    if (nArray.length > 1) {
                        if (nArray2[1] < nArray[1]) {
                            throw new Throwable("Invalid end of Record Range " + nArray[1] + ". Last available record is " + nArray2[1]);
                        }
                        nArray6 = new int[]{nArray[0], nArray[1]};
                    } else {
                        nArray6 = new int[]{nArray[0], nArray[0]};
                    }
                } else if (nArray.length == 1) {
                    if (nArray[0] < nArray2[0] || nArray[0] > nArray2[1]) {
                        n = 1;
                    } else {
                        nArray6 = new int[]{nArray[0], nArray[0]};
                    }
                } else if (nArray[0] > nArray2[1] || nArray[1] < nArray2[0]) {
                    n = nArray[1] - nArray[0] + 1;
                } else if (nArray[0] < nArray2[0]) {
                    n = nArray2[0] - nArray[0];
                    nArray6 = new int[]{nArray2[0], nArray[1]};
                } else {
                    nArray6 = new int[]{nArray[0], nArray[1]};
                }
            } else {
                nArray6 = new int[]{0, 0};
            }
        } else {
            nArray6 = new int[]{nArray2[0], nArray2[1]};
        }
        this.fillCount = n;
        this.overlap = nArray6;
        if (DataTypes.size[this.type] > 1 || this._class != Byte.TYPE) {
            int n2 = 1024 / this.elements;
            this.recordsPerChunk = n2 == 0 ? 1 : n2;
            this.csize = this.recordsPerChunk * this.elements;
            this.chunking = true;
        } else {
            this.recordsPerChunk = -1;
            this.csize = -1;
            this.chunking = false;
        }
    }

    public void setDirect(boolean bl) {
        if (this.allocationMode == null) {
            this.allocationMode = new Boolean(bl);
        }
    }

    public boolean setUserBuffer(ByteBuffer byteBuffer) {
        if (this.allocationMode != null) {
            return false;
        }
        this.userBuffer = byteBuffer;
        return true;
    }

    public ByteBuffer getBuffer() {
        if (this.buffers.size() == 0) {
            return null;
        }
        ContentDescriptor contentDescriptor = (ContentDescriptor)this.buffers.get(0);
        return contentDescriptor.getBuffer();
    }

    public int[] getRecordRange() {
        if (this.buffers.size() == 0) {
            return null;
        }
        ContentDescriptor contentDescriptor = (ContentDescriptor)this.buffers.get(0);
        return new int[]{contentDescriptor.getFirstRecord(), contentDescriptor.getLastRecord()};
    }

    @Override
    public void run() {
        int n;
        int n2;
        int n3;
        if (this.buffers.size() > 0) {
            return;
        }
        int n4 = this.pt[1] - this.pt[0] + 1;
        int n5 = this.elements * n4;
        int n6 = n5 * this.getLength();
        ByteBuffer byteBuffer = this.allocationMode == null ? (this.userBuffer == null ? ByteBuffer.allocateDirect(n6) : this.userBuffer) : (this.allocationMode != false ? ByteBuffer.allocateDirect(n6) : ByteBuffer.allocate(n6));
        byteBuffer.order(this.order);
        Object object = null;
        if (this.overlap == null) {
            object = this.allocateDataArray(n5);
            this.doMissing(this.fillCount, byteBuffer, object, -1);
            if (this.buffers.size() == 0) {
                this.buffers.add(new ContentDescriptor(byteBuffer, this.pt[0], this.pt[1]));
            }
            return;
        }
        int n7 = this.overlap[0];
        int n8 = this.overlap[1];
        if (this.chunking) {
            object = this.allocateDataArray(n5 < this.csize ? n5 : this.csize);
        }
        if (this.fillCount > 0) {
            this.doMissing(this.fillCount, byteBuffer, object, -1);
        }
        Vector vector = ((CDFImpl.DataLocator)this.var.getLocator()).locations;
        int n9 = n7;
        if (n9 > 0) {
            n3 = -1;
            int n10 = -1;
            for (n2 = 0; n2 < vector.size(); ++n2) {
                long[] lArray = (long[])vector.elementAt(n2);
                n3 = (int)lArray[0];
                if (lArray[1] >= (long)n9) break;
                n10 = (int)lArray[1];
            }
            n = 0;
            if (n2 == vector.size()) {
                n = n8 - n7 + 1;
                if (!this.var.missingRecordValueIsPad() && !this.var.missingRecordValueIsPrevious()) {
                    return;
                }
            } else if (n9 < n3) {
                n = n3 - n9;
                if (n8 < n3) {
                    n = n8 + 1 - n9;
                }
            }
            if (n > 0) {
                if (this.var.missingRecordValueIsPrevious()) {
                    this.doMissing(n, byteBuffer, object, n2 == 0 ? -1 : n10);
                } else {
                    this.doMissing(n, byteBuffer, object, -1);
                }
                if ((n9 += n) > n8) {
                    if (this.buffers.size() == 0) {
                        this.buffers.add(new ContentDescriptor(byteBuffer, n7, n8));
                    }
                    return;
                }
            }
        }
        n3 = 1;
        while (n2 < vector.size()) {
            int n11;
            int n12;
            long[] lArray = (long[])vector.elementAt(n2);
            n = (int)lArray[0];
            int n13 = (int)lArray[1];
            int n14 = n13 - n + 1;
            ByteBuffer byteBuffer2 = this.thisCDF.positionBuffer(this.var, lArray[2], n14);
            if (n3 != 0) {
                if (this.pt != null) {
                    if (n7 > n) {
                        n12 = byteBuffer2.position() + (n7 - n) * this.itemSize;
                        byteBuffer2.position(n12);
                    }
                    if (n8 == n7) {
                        try {
                            this.doData(byteBuffer2, this.type, this.elements, 1, byteBuffer, object);
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                        if (this.buffers.size() == 0) {
                            this.buffers.add(new ContentDescriptor(byteBuffer, n7, n8));
                        }
                        return;
                    }
                }
                n3 = 0;
            } else if (n9 < n) {
                n12 = n8 >= n ? n : n8 + 1;
                n11 = n12 - n9;
                if (this.var.missingRecordValueIsPrevious()) {
                    int n15 = (int)((long[])vector.elementAt(n2 - 1))[1];
                    this.doMissing(n11, byteBuffer, object, n15);
                } else {
                    this.doMissing(n11, byteBuffer, object, -1);
                }
                if (n12 > n8) break;
                n9 = n;
            }
            while (n9 <= n8) {
                n12 = n8 - n9 + 1;
                n11 = n13 - n9 + 1;
                if (this.chunking && n11 > this.recordsPerChunk) {
                    n11 = this.recordsPerChunk;
                }
                if (n11 > n12) {
                    n11 = n12;
                }
                try {
                    this.doData(byteBuffer2, this.type, this.elements, n11, byteBuffer, object);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    return;
                }
                if ((n9 += n11) <= n13) continue;
                break;
            }
            if (n9 > n8) break;
            ++n2;
        }
        if (n9 <= n8) {
            if (this.var.missingRecordValueIsPrevious()) {
                this.doMissing(n8 - n9 + 1, byteBuffer, object, n9 - 1);
            } else {
                this.doMissing(n8 - n9 + 1, byteBuffer, object, -1);
            }
        }
        if (this.buffers.size() == 0) {
            this.buffers.add(new ContentDescriptor(byteBuffer, n7, n8));
        }
    }

    public static boolean isCompatible(int n, boolean bl, Class clazz) {
        if (clazz == Long.TYPE) {
            if (DataTypes.typeCategory[n] == 2 || DataTypes.typeCategory[n] == 3) {
                return true;
            }
            return DataTypes.typeCategory[n] == 5;
        }
        if (clazz == Double.TYPE) {
            if (n > 50) {
                return false;
            }
            return DataTypes.typeCategory[n] != 5 || !bl;
        }
        if (clazz == Float.TYPE) {
            if (n > 50) {
                return false;
            }
            if (DataTypes.typeCategory[n] == 0) {
                return true;
            }
            return !(DataTypes.typeCategory[n] == 5 || DataTypes.typeCategory[n] == 1 ? bl : bl && (n == 4 || n == 14));
        }
        if (clazz == Integer.TYPE) {
            if (n > 50) {
                return false;
            }
            if (DataTypes.typeCategory[n] != 2 && DataTypes.typeCategory[n] != 3) {
                return false;
            }
            return !bl || n != 14;
        }
        if (clazz == Short.TYPE) {
            if (n > 50) {
                return false;
            }
            if (n == 1 || n == 41 || n == 2) {
                return true;
            }
            if (n == 11) {
                return true;
            }
            return n == 12 && !bl;
        }
        if (clazz == Byte.TYPE) {
            if (bl) {
                if (n == 1 || n == 41 || n == 11) {
                    return true;
                }
                return n > 50;
            }
            return true;
        }
        return false;
    }

    public int getCapacity() {
        int n = this.pt[1] - this.pt[0] + 1;
        int n2 = this.elements * n;
        return n2 * this.getLength();
    }

    abstract ByteBuffer allocateBuffer(int var1);

    abstract Object allocateDataArray(int var1);

    abstract void doData(ByteBuffer var1, int var2, int var3, int var4, ByteBuffer var5, Object var6) throws Throwable;

    abstract void doMissing(int var1, ByteBuffer var2, Object var3, int var4);

    int getLength() {
        if (this._class == Long.TYPE) {
            return 8;
        }
        if (this._class == Double.TYPE) {
            return 8;
        }
        if (this._class == Float.TYPE) {
            return 4;
        }
        if (this._class == Integer.TYPE) {
            return 4;
        }
        if (this._class == Short.TYPE) {
            return 2;
        }
        if (this._class == Byte.TYPE) {
            return 1;
        }
        return -1;
    }

    static boolean validElement(Variable variable, int[] nArray) {
        int n = (Integer)variable.getElementCount().elementAt(0);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= 0 && nArray[i] < n) continue;
            return false;
        }
        return true;
    }

    public Object asSampledArray(Stride stride) {
        ByteBuffer byteBuffer;
        int[] nArray = this.getRecordRange();
        int n = nArray[1] - nArray[0] + 1;
        int n2 = stride.getStride(n);
        if (n2 > 1) {
            int n3 = n / n2;
            if (n % n2 != 0) {
                ++n3;
            }
            n = n3;
        }
        if ((byteBuffer = this.getBuffer()) == null) {
            return null;
        }
        int n4 = this.elements * n;
        int n5 = n2 * this.elements;
        int n6 = 0;
        int n7 = 0;
        if (this._class == Float.TYPE) {
            FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
            float[] fArray = new float[n4];
            for (int i = 0; i < n; ++i) {
                floatBuffer.position(n6);
                floatBuffer.get(fArray, n7, this.elements);
                n7 += this.elements;
                n6 += n5;
            }
            return fArray;
        }
        if (this._class == Double.TYPE) {
            DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
            double[] dArray = new double[n4];
            for (int i = 0; i < n; ++i) {
                doubleBuffer.position(n6);
                doubleBuffer.get(dArray, n7, this.elements);
                n7 += this.elements;
                n6 += n5;
            }
            return dArray;
        }
        if (this._class == Integer.TYPE) {
            IntBuffer intBuffer = byteBuffer.asIntBuffer();
            int[] nArray2 = new int[n4];
            for (int i = 0; i < n; ++i) {
                intBuffer.position(n6);
                intBuffer.get(nArray2, n7, this.elements);
                n7 += this.elements;
                n6 += n5;
            }
            return nArray2;
        }
        if (this._class == Short.TYPE) {
            ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
            short[] sArray = new short[n4];
            for (int i = 0; i < n; ++i) {
                shortBuffer.position(n6);
                shortBuffer.get(sArray, n7, this.elements);
                n7 += this.elements;
                n6 += n5;
            }
            return sArray;
        }
        if (this._class == Byte.TYPE) {
            ByteBuffer byteBuffer2 = byteBuffer.duplicate();
            byte[] byArray = new byte[n4];
            for (int i = 0; i < n; ++i) {
                byteBuffer2.position(n6);
                byteBuffer2.get(byArray, n7, this.elements);
                n7 += this.elements;
                n6 += n5;
            }
            return byArray;
        }
        if (this._class == Long.TYPE) {
            LongBuffer longBuffer = byteBuffer.asLongBuffer();
            long[] lArray = new long[n4];
            for (int i = 0; i < n; ++i) {
                longBuffer.position(n6);
                longBuffer.get(lArray, n7, this.elements);
                n7 += this.elements;
                n6 += n5;
            }
            return lArray;
        }
        return null;
    }

    public Object as1DArray() {
        ByteBuffer byteBuffer = this.getBuffer();
        if (byteBuffer == null) {
            return null;
        }
        if (this._class == Long.TYPE) {
            long[] lArray = new long[byteBuffer.remaining() / 8];
            byteBuffer.asLongBuffer().get(lArray);
            return lArray;
        }
        if (this._class == Double.TYPE) {
            double[] dArray = new double[byteBuffer.remaining() / 8];
            byteBuffer.asDoubleBuffer().get(dArray);
            return dArray;
        }
        if (this._class == Float.TYPE) {
            float[] fArray = new float[byteBuffer.remaining() / 4];
            byteBuffer.asFloatBuffer().get(fArray);
            return fArray;
        }
        if (this._class == Integer.TYPE) {
            int[] nArray = new int[byteBuffer.remaining() / 4];
            byteBuffer.asIntBuffer().get(nArray);
            return nArray;
        }
        if (this._class == Short.TYPE) {
            short[] sArray = new short[byteBuffer.remaining() / 2];
            byteBuffer.asShortBuffer().get(sArray);
            return sArray;
        }
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        return byArray;
    }

    Class componentType(Object object) {
        if (!object.getClass().isArray()) {
            return null;
        }
        Class<?> clazz = object.getClass();
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz;
    }

    public Variable getVariable() {
        return this.var;
    }

    public Object asOneDArray(boolean bl) {
        return this.asOneDArray(bl, null);
    }

    public Object asOneDArray(boolean bl, Stride stride) {
        int[] nArray = this.var.getEffectiveDimensions();
        if (nArray.length <= 1 || !bl && this.var.rowMajority() || bl && !this.var.rowMajority()) {
            if (stride == null) {
                return this.as1DArray();
            }
            return this.asSampledArray(stride);
        }
        int[] nArray2 = nArray;
        if (!this.var.rowMajority()) {
            nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[i] = nArray[nArray.length - 1 - i];
            }
        }
        return this.makeArray(nArray2, stride);
    }

    Object makeArray(int[] nArray, Stride stride) {
        int n;
        int n2;
        int n3;
        int n4;
        ByteBuffer byteBuffer = this.getBuffer();
        if (byteBuffer == null) {
            return null;
        }
        int n5 = -1;
        if (nArray.length == 2) {
            n5 = nArray[0] * nArray[1];
        }
        if (nArray.length == 3) {
            n5 = nArray[0] * nArray[1] * nArray[2];
        }
        int n6 = 1;
        int[] nArray2 = this.getRecordRange();
        int n7 = nArray2[1] - nArray2[0] + 1;
        if (stride != null && (n6 = stride.getStride(n7)) > 1) {
            n4 = n7 / n6;
            if (n7 % n6 != 0) {
                ++n4;
            }
            n7 = n4;
        }
        n4 = this.elements * n7;
        int n8 = n6 * n5;
        int n9 = 0;
        int n10 = 0;
        if (this._class == Long.TYPE) {
            int n11;
            int n12;
            int n13;
            long[] lArray = new long[n4];
            LongBuffer longBuffer = byteBuffer.asLongBuffer();
            if (nArray.length == 2) {
                for (n13 = 0; n13 < n7; ++n13) {
                    for (n12 = 0; n12 < nArray[1]; ++n12) {
                        for (n11 = 0; n11 < nArray[0]; ++n11) {
                            lArray[n10++] = longBuffer.get(n9 + n11 * nArray[1] + n12);
                        }
                    }
                    n9 += n8;
                }
            }
            if (nArray.length == 3) {
                for (n13 = 0; n13 < n7; ++n13) {
                    for (n12 = 0; n12 < nArray[2]; ++n12) {
                        for (n11 = 0; n11 < nArray[1]; ++n11) {
                            for (int i = 0; i < nArray[0]; ++i) {
                                lArray[n10++] = longBuffer.get(n9 + i * nArray[1] * nArray[2] + n11 * nArray[2] + n12);
                            }
                        }
                    }
                    n9 += n8;
                }
            }
            return lArray;
        }
        if (this._class == Double.TYPE) {
            int n14;
            int n15;
            int n16;
            double[] dArray = new double[n4];
            DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
            if (nArray.length == 2) {
                for (n16 = 0; n16 < n7; ++n16) {
                    for (n15 = 0; n15 < nArray[1]; ++n15) {
                        for (n14 = 0; n14 < nArray[0]; ++n14) {
                            dArray[n10++] = doubleBuffer.get(n9 + n14 * nArray[1] + n15);
                        }
                    }
                    n9 += n8;
                }
            }
            if (nArray.length == 3) {
                for (n16 = 0; n16 < n7; ++n16) {
                    for (n15 = 0; n15 < nArray[2]; ++n15) {
                        for (n14 = 0; n14 < nArray[1]; ++n14) {
                            for (int i = 0; i < nArray[0]; ++i) {
                                dArray[n10++] = doubleBuffer.get(n9 + i * nArray[1] * nArray[2] + n14 * nArray[2] + n15);
                            }
                        }
                    }
                    n9 += n8;
                }
            }
            return dArray;
        }
        if (this._class == Float.TYPE) {
            int n17;
            int n18;
            int n19;
            float[] fArray = new float[n4];
            FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
            if (nArray.length == 2) {
                for (n19 = 0; n19 < n7; ++n19) {
                    for (n18 = 0; n18 < nArray[1]; ++n18) {
                        for (n17 = 0; n17 < nArray[0]; ++n17) {
                            fArray[n10++] = floatBuffer.get(n9 + n17 * nArray[1] + n18);
                        }
                    }
                    n9 += n8;
                }
            }
            if (nArray.length == 3) {
                for (n19 = 0; n19 < n7; ++n19) {
                    for (n18 = 0; n18 < nArray[2]; ++n18) {
                        for (n17 = 0; n17 < nArray[1]; ++n17) {
                            for (int i = 0; i < nArray[0]; ++i) {
                                fArray[n10++] = floatBuffer.get(n9 + i * nArray[1] * nArray[2] + n17 * nArray[2] + n18);
                            }
                        }
                    }
                    n9 += n8;
                }
            }
            return fArray;
        }
        if (this._class == Integer.TYPE) {
            int n20;
            int n21;
            int n22;
            int[] nArray3 = new int[n4];
            IntBuffer intBuffer = byteBuffer.asIntBuffer();
            if (nArray.length == 2) {
                for (n22 = 0; n22 < n7; ++n22) {
                    for (n21 = 0; n21 < nArray[1]; ++n21) {
                        for (n20 = 0; n20 < nArray[0]; ++n20) {
                            nArray3[n10++] = intBuffer.get(n9 + n20 * nArray[1] + n21);
                        }
                    }
                    n9 += n8;
                }
            }
            if (nArray.length == 3) {
                for (n22 = 0; n22 < n7; ++n22) {
                    for (n21 = 0; n21 < nArray[2]; ++n21) {
                        for (n20 = 0; n20 < nArray[1]; ++n20) {
                            for (int i = 0; i < nArray[0]; ++i) {
                                nArray3[n10++] = intBuffer.get(n9 + i * nArray[1] * nArray[2] + n20 * nArray[2] + n21);
                            }
                        }
                    }
                    n9 += n8;
                }
            }
            return nArray3;
        }
        if (this._class == Short.TYPE) {
            int n23;
            int n24;
            int n25;
            short[] sArray = new short[n4];
            ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
            if (nArray.length == 2) {
                for (n25 = 0; n25 < n7; ++n25) {
                    for (n24 = 0; n24 < nArray[1]; ++n24) {
                        for (n23 = 0; n23 < nArray[0]; ++n23) {
                            sArray[n10++] = shortBuffer.get(n9 + n23 * nArray[1] + n24);
                        }
                    }
                    n9 += n8;
                }
            }
            if (nArray.length == 3) {
                for (n25 = 0; n25 < n7; ++n25) {
                    for (n24 = 0; n24 < nArray[2]; ++n24) {
                        for (n23 = 0; n23 < nArray[1]; ++n23) {
                            for (int i = 0; i < nArray[0]; ++i) {
                                sArray[n10++] = shortBuffer.get(n9 + i * nArray[1] * nArray[2] + n23 * nArray[2] + n24);
                            }
                        }
                    }
                    n9 += n8;
                }
            }
            return sArray;
        }
        byte[] byArray = new byte[n4];
        if (nArray.length == 2) {
            for (n3 = 0; n3 < n7; ++n3) {
                for (n2 = 0; n2 < nArray[1]; ++n2) {
                    for (n = 0; n < nArray[0]; ++n) {
                        byArray[n10++] = byteBuffer.get(n9 + n * nArray[1] + n2);
                    }
                }
                n9 += n8;
            }
        }
        if (nArray.length == 3) {
            for (n3 = 0; n3 < n7; ++n3) {
                for (n2 = 0; n2 < nArray[2]; ++n2) {
                    for (n = 0; n < nArray[1]; ++n) {
                        for (int i = 0; i < nArray[0]; ++i) {
                            byArray[n10++] = byteBuffer.get(n9 + i * nArray[1] * nArray[2] + n * nArray[2] + n2);
                        }
                    }
                }
                n9 += n8;
            }
        }
        byteBuffer.flip();
        return byArray;
    }

    class ContentDescriptor {
        final ByteBuffer buf;
        final int first;
        final int last;

        protected ContentDescriptor(ByteBuffer byteBuffer, int n, int n2) {
            this.buf = byteBuffer;
            this.first = n;
            this.last = n2;
        }

        ByteBuffer getBuffer() {
            ByteBuffer byteBuffer = this.buf.asReadOnlyBuffer();
            byteBuffer.order(this.buf.order());
            byteBuffer.position(0);
            return byteBuffer;
        }

        int getFirstRecord() {
            return this.first;
        }

        int getLastRecord() {
            return this.last;
        }
    }
}

