/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.ADR;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class AEDR {
    static int INT_TYPE = 4;
    static int FLOAT_TYPE = 21;
    static int DOUBLE_TYPE = 22;
    static int LONG_TYPE = 8;
    static int SHORT_TYPE = 2;
    static int BYTE_TYPE = 1;
    static int STRING_TYPE = 51;
    ByteBuffer record = ByteBuffer.allocate(56);
    long aEDRNext;
    protected long position;
    int attributeType;
    int attrNum;
    int dataType = -1;
    int num;
    int numElems;
    byte[] values;

    public AEDR(ADR aDR, int n, Object object) throws Throwable {
        this.setAttrNum(aDR.num);
        this.setDataType(n);
        Class<?> clazz = object.getClass();
        if (clazz == String.class) {
            String string = (String)object;
            this.setValues(string);
            return;
        }
        if (!clazz.isArray()) {
            throw new Throwable("supplied object not an array");
        }
        if ((clazz = clazz.getComponentType()) == Long.TYPE) {
            long[] lArray = (long[])object;
            this.setValues(lArray);
            return;
        }
        if (clazz == Double.TYPE) {
            double[] dArray = (double[])object;
            this.setValues(dArray);
            return;
        }
        if (clazz == Float.TYPE) {
            float[] fArray = (float[])object;
            this.setValues(fArray);
            return;
        }
        if (clazz == Integer.TYPE) {
            int[] nArray = (int[])object;
            this.setValues(nArray);
            return;
        }
        if (clazz == Short.TYPE) {
            short[] sArray = (short[])object;
            this.setValues(sArray);
            return;
        }
        if (clazz == Byte.TYPE) {
            byte[] byArray = (byte[])object;
            this.setValues(byArray);
            return;
        }
        throw new Throwable("Arrays of type " + clazz + " not supported");
    }

    public AEDR(ADR aDR, Object object) throws Throwable {
        this(aDR, -1, object);
    }

    public void setAEDRNext(long l) {
        this.aEDRNext = l;
    }

    public void setAttributeType(int n) {
        this.attributeType = n;
    }

    public void setAttrNum(int n) {
        this.attrNum = n;
    }

    public void setDataType(int n) throws Throwable {
        if (this.dataType != -1) {
            throw new Throwable("Data type is already defined");
        }
        this.dataType = n;
    }

    public void setNum(int n) {
        this.num = n;
    }

    public int getNum() {
        return this.num;
    }

    public void setNumElems(int n) {
        this.numElems = n;
    }

    public void setValues(String string) throws Throwable {
        this.setNumElems(string.length());
        if (this.dataType == -1) {
            this.setDataType(STRING_TYPE);
        } else if (this.dataType < 50 || this.dataType > 52) {
            throw new Throwable("Incompatible data type " + this.dataType + " for String.");
        }
        this.values = string.getBytes();
    }

    public void setValues(byte[] byArray) throws Throwable {
        if (this.dataType == -1) {
            this.setDataType(BYTE_TYPE);
        } else if (this.dataType != 1 && this.dataType != 11) {
            throw new Throwable("Incompatible data type " + this.dataType + " for Byte.");
        }
        this.values = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            this.values[i] = byArray[i];
        }
        this.setNumElems(byArray.length);
    }

    public void setValues(long[] lArray) throws Throwable {
        if (this.dataType == -1) {
            this.setDataType(LONG_TYPE);
        } else if (this.dataType != 8 && this.dataType != 33) {
            throw new Throwable("Incompatible data type " + this.dataType + " for Long.");
        }
        this.setNumElems(lArray.length);
        ByteBuffer byteBuffer = ByteBuffer.allocate(8 * lArray.length);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.asLongBuffer().put(lArray);
        this.values = new byte[8 * lArray.length];
        byteBuffer.get(this.values);
    }

    public void setValues(double[] dArray) throws Throwable {
        this.setNumElems(dArray.length);
        if (this.dataType == -1) {
            this.setDataType(DOUBLE_TYPE);
            ByteBuffer byteBuffer = ByteBuffer.allocate(8 * dArray.length);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.asDoubleBuffer().put(dArray);
            this.values = new byte[8 * dArray.length];
            byteBuffer.get(this.values);
            return;
        }
        if (this.dataType == 22 || this.dataType == 45 || this.dataType == 31 || this.dataType == 32) {
            if (this.dataType == 32) {
                this.setNumElems(dArray.length / 2);
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(8 * dArray.length);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.asDoubleBuffer().put(dArray);
            this.values = new byte[8 * dArray.length];
            byteBuffer.get(this.values);
            return;
        }
        if (this.dataType == 21 || this.dataType == 44) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(4 * dArray.length);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < dArray.length; ++i) {
                byteBuffer.putFloat((float)dArray[i]);
            }
            this.values = new byte[4 * dArray.length];
            byteBuffer.position(0);
            byteBuffer.get(this.values);
            return;
        }
        if (this.dataType == 1 || this.dataType == 11) {
            this.values = new byte[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                this.values[i] = (byte)dArray[i];
            }
            return;
        }
        if (this.dataType == 2 || this.dataType == 12) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(2 * dArray.length);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < dArray.length; ++i) {
                byteBuffer.putShort((short)dArray[i]);
            }
            this.values = new byte[2 * dArray.length];
            byteBuffer.position(0);
            byteBuffer.get(this.values);
            return;
        }
        if (this.dataType == 4) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(4 * dArray.length);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < dArray.length; ++i) {
                byteBuffer.putInt((int)dArray[i]);
            }
            this.values = new byte[4 * dArray.length];
            byteBuffer.position(0);
            byteBuffer.get(this.values);
            return;
        }
        if (this.dataType == 14) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(4 * dArray.length);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < dArray.length; ++i) {
                long l = (long)dArray[i];
                byteBuffer.putInt((int)l);
            }
            this.values = new byte[4 * dArray.length];
            byteBuffer.position(0);
            byteBuffer.get(this.values);
            return;
        }
        throw new Throwable("Incompatible data type " + this.dataType + " for Double.");
    }

    public void setValues(int[] nArray) throws Throwable {
        this.setNumElems(nArray.length);
        if (this.dataType == -1) {
            this.setDataType(INT_TYPE);
        } else if (this.dataType != 4 && this.dataType != 14) {
            throw new Throwable("Incompatible data type " + this.dataType + " for Int.");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 * nArray.length);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.asIntBuffer().put(nArray);
        this.values = new byte[4 * nArray.length];
        byteBuffer.get(this.values);
    }

    public void setValues(float[] fArray) throws Throwable {
        this.setNumElems(fArray.length);
        if (this.dataType == -1) {
            this.setDataType(FLOAT_TYPE);
        } else if (this.dataType != 21 && this.dataType != 44) {
            throw new Throwable("Incompatible data type " + this.dataType + " for Float.");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 * fArray.length);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.asFloatBuffer().put(fArray);
        this.values = new byte[4 * fArray.length];
        byteBuffer.get(this.values);
    }

    public void setValues(short[] sArray) throws Throwable {
        this.setNumElems(sArray.length);
        if (this.dataType == -1) {
            this.setDataType(SHORT_TYPE);
        } else if (this.dataType != 2 && this.dataType != 12) {
            throw new Throwable("Incompatible data type " + this.dataType + " for Short.");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 * sArray.length);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.asShortBuffer().put(sArray);
        this.values = new byte[2 * sArray.length];
        byteBuffer.get(this.values);
    }

    public ByteBuffer get() {
        int n;
        int n2 = this.record.capacity() + this.values.length;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        this.record.position(0);
        this.record.putLong(n2);
        this.record.putInt(this.attributeType);
        this.record.putLong(this.aEDRNext);
        this.record.putInt(this.attrNum);
        this.record.putInt(this.dataType);
        this.record.putInt(this.num);
        this.record.putInt(this.numElems);
        for (n = 0; n < 3; ++n) {
            this.record.putInt(0);
        }
        for (n = 0; n < 2; ++n) {
            this.record.putInt(-1);
        }
        this.record.position(0);
        byteBuffer.put(this.record);
        byteBuffer.put(this.values);
        byteBuffer.position(0);
        return byteBuffer;
    }

    public int getSize() {
        return this.record.capacity() + this.values.length;
    }
}

