/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessControlException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.python.core.JavaImporter;
import org.python.core.Options;
import org.python.core.PackageManager;
import org.python.core.PollingInputStream;
import org.python.core.PrecompiledImporter;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyEllipsis;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFrame;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyInteger;
import org.python.core.PyJavaClass;
import org.python.core.PyJavaPackage;
import org.python.core.PyList;
import org.python.core.PyModule;
import org.python.core.PyNone;
import org.python.core.PyNotImplemented;
import org.python.core.PyObject;
import org.python.core.PySingleton;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySyntaxError;
import org.python.core.PySystemStateFunctions;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PythonTraceFunction;
import org.python.core.StderrWrapper;
import org.python.core.StdoutWrapper;
import org.python.core.SysPackageManager;
import org.python.core.TraceFunction;
import org.python.core.ZipFileImporter;
import org.python.core.__builtin__;
import org.python.core.adapter.ClassicPyObjectAdapter;
import org.python.core.adapter.ExtensiblePyObjectAdapter;
import org.python.core.codecs;
import org.python.modules.Setup;

public class PySystemState
extends PyObject {
    public static final String JYTHON_JAR = "jython.jar";
    private static final String JAR_URL_PREFIX = "jar:file:";
    private static final String JAR_SEPARATOR = "!";
    private static final String PYTHON_CACHEDIR = "python.cachedir";
    protected static final String PYTHON_CACHEDIR_SKIP = "python.cachedir.skip";
    protected static final String CACHEDIR_DEFAULT_NAME = "cachedir";
    public static String version = "2.2.1";
    private static int PY_MAJOR_VERSION = 2;
    private static int PY_MINOR_VERSION = 2;
    private static int PY_MICRO_VERSION = 1;
    private static int PY_RELEASE_LEVEL = 15;
    private static int PY_RELEASE_SERIAL = 0;
    public static int hexversion = PY_MAJOR_VERSION << 24 | PY_MINOR_VERSION << 16 | PY_MICRO_VERSION << 8 | PY_RELEASE_LEVEL << 4 | PY_RELEASE_SERIAL << 0;
    public static PyTuple version_info;
    public static int maxunicode;
    public static String copyright;
    public PyList argv = new PyList();
    public PyObject modules;
    public PyList path;
    public static PyObject builtins;
    public PyList meta_path;
    public PyList path_hooks;
    public PyObject path_importer_cache;
    public static String platform;
    public static String byteorder;
    public PyObject ps1 = new PyString(">>> ");
    public PyObject ps2 = new PyString("... ");
    public static int maxint;
    public static int minint;
    public PyObject executable = Py.None;
    public static PyList warnoptions;
    private ClassLoader classLoader = null;
    public PyObject stdout;
    public PyObject stderr;
    public PyObject stdin;
    public PyObject __stdout__;
    public PyObject __stderr__;
    public PyObject __stdin__;
    public PyObject __displayhook__;
    public PyObject __excepthook__;
    public PyObject last_value = Py.None;
    public PyObject last_type = Py.None;
    public PyObject last_traceback = Py.None;
    public PyObject __dict__;
    private int recursionlimit = 1000;
    private static PyList defaultPath;
    private static PyList defaultArgv;
    public static Properties registry;
    public static String prefix;
    public static String exec_prefix;
    private static boolean initialized;
    public static PackageManager packageManager;
    public static File cachedir;
    private static Hashtable builtinNames;
    public static String[] builtin_module_names;
    public TraceFunction tracefunc = null;
    public TraceFunction profilefunc = null;

    public static void exit(PyObject status) {
        throw new PyException(Py.SystemExit, status);
    }

    public static void exit() {
        PySystemState.exit(Py.None);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static PyTuple exc_info() {
        PyException exc = Py.getThreadState().exception;
        if (exc == null) {
            return new PyTuple(new PyObject[]{Py.None, Py.None, Py.None});
        }
        return new PyTuple(new PyObject[]{exc.type, exc.value, exc.traceback});
    }

    public static PyFrame _getframe() {
        return PySystemState._getframe(-1);
    }

    public static PyFrame _getframe(int depth) {
        PyFrame f = Py.getFrame();
        while (depth > 0 && f != null) {
            f = f.f_back;
            --depth;
        }
        if (f == null) {
            throw Py.ValueError("call stack is not deep enough");
        }
        return f;
    }

    public PyObject __findattr__(String name) {
        if (name == "exc_value") {
            PyException exc = Py.getThreadState().exception;
            if (exc == null) {
                return null;
            }
            return exc.value;
        }
        if (name == "exc_type") {
            PyException exc = Py.getThreadState().exception;
            if (exc == null) {
                return null;
            }
            return exc.type;
        }
        if (name == "exc_traceback") {
            PyException exc = Py.getThreadState().exception;
            if (exc == null) {
                return null;
            }
            return exc.traceback;
        }
        if (name == "warnoptions") {
            if (warnoptions == null) {
                warnoptions = new PyList();
            }
            return warnoptions;
        }
        PyObject ret = super.__findattr__(name);
        if (ret != null) {
            return ret;
        }
        return this.__dict__.__finditem__(name);
    }

    public void __setattr__(String name, PyObject value) {
        PyType selftype = this.getType();
        if (selftype == null) {
            return;
        }
        PyObject ret = selftype.lookup(name);
        if (ret != null) {
            ret.jtryset(this, value);
            return;
        }
        if (this.__dict__ == null) {
            this.__dict__ = new PyStringMap();
        }
        this.__dict__.__setitem__(name, value);
    }

    public void __delattr__(String name) {
        if (this.__dict__ != null) {
            this.__dict__.__delitem__(name);
            return;
        }
        throw Py.AttributeError("del '" + name + "'");
    }

    public void __rawdir__(PyDictionary accum) {
        accum.update(this.__dict__);
    }

    public String safeRepr() throws PyIgnoreMethodTag {
        return "module 'sys'";
    }

    public String toString() {
        return "sys module";
    }

    public int getrecursionlimit() {
        return this.recursionlimit;
    }

    public void setrecursionlimit(int recursionlimit) {
        if (recursionlimit <= 0) {
            throw Py.ValueError("Recursion limit must be positive");
        }
        this.recursionlimit = recursionlimit;
    }

    public PySystemState() {
        PySystemState.initialize();
        this.modules = new PyStringMap();
        this.argv = (PyList)defaultArgv.repeat(1);
        this.path = (PyList)defaultPath.repeat(1);
        this.path.append(Py.newString("__classpath__"));
        this.meta_path = new PyList();
        this.meta_path.append(new PrecompiledImporter());
        this.path_hooks = new PyList();
        this.path_hooks.append(new JavaImporter());
        this.path_hooks.append(PyJavaClass.lookup(ZipFileImporter.class));
        this.path_importer_cache = new PyDictionary();
        this.__stdout__ = this.stdout = new PyFile(System.out, "<stdout>");
        this.__stderr__ = this.stderr = new PyFile(System.err, "<stderr>");
        this.__stdin__ = this.stdin = new PyFile(this.getSystemIn(), "<stdin>");
        this.__displayhook__ = new PySystemStateFunctions("displayhook", 10, 1, 1);
        this.__excepthook__ = new PySystemStateFunctions("excepthook", 30, 3, 3);
        if (builtins == null) {
            builtins = new PyStringMap();
            __builtin__.fillWithBuiltins(builtins);
        }
        PyModule __builtin__2 = new PyModule("__builtin__", builtins);
        this.modules.__setitem__("__builtin__", (PyObject)__builtin__2);
        if (this.getType() != null) {
            this.__dict__ = new PyStringMap();
            this.__dict__.invoke("update", this.getType().getDict());
            this.__dict__.__setitem__("displayhook", this.__displayhook__);
            this.__dict__.__setitem__("excepthook", this.__excepthook__);
        }
    }

    private static String findRoot(Properties preProperties, Properties postProperties, String jarFileName) {
        String classpath;
        String root = null;
        try {
            if (postProperties != null) {
                root = postProperties.getProperty("python.home");
            }
            if (root == null) {
                root = preProperties.getProperty("python.home");
            }
            if (root == null) {
                root = preProperties.getProperty("install.root");
            }
            PySystemState.determinePlatform(preProperties);
        }
        catch (Exception exc) {
            return null;
        }
        if (root == null && (classpath = preProperties.getProperty("java.class.path")) != null) {
            int jpy = classpath.toLowerCase().indexOf(JYTHON_JAR);
            if (jpy >= 0) {
                int start = classpath.lastIndexOf(File.pathSeparator, jpy) + 1;
                root = classpath.substring(start, jpy);
            } else {
                root = jarFileName;
            }
        }
        return root;
    }

    public static void determinePlatform(Properties props) {
        String lversion;
        String version = props.getProperty("java.version");
        if (version == null) {
            version = "???";
        }
        if ((lversion = version.toLowerCase()).startsWith("java")) {
            version = version.substring(4, version.length());
        }
        if (lversion.startsWith("jdk") || lversion.startsWith("jre")) {
            version = version.substring(3, version.length());
        }
        if (version.equals("12")) {
            version = "1.2";
        }
        if (version != null) {
            platform = "java" + version;
        }
    }

    private static void initRegistry(Properties preProperties, Properties postProperties, boolean standalone, String jarFileName) {
        if (registry != null) {
            Py.writeError("systemState", "trying to reinitialize registry");
            return;
        }
        registry = preProperties;
        exec_prefix = PySystemState.findRoot(preProperties, postProperties, jarFileName);
        prefix = exec_prefix;
        if (prefix != null) {
            if (prefix.length() == 0) {
                exec_prefix = ".";
                prefix = ".";
            }
            try {
                PySystemState.addRegistryFile(new File(prefix, "registry"));
                File homeFile = new File(registry.getProperty("user.home"), ".jython");
                PySystemState.addRegistryFile(homeFile);
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
        if (postProperties != null) {
            Enumeration<Object> e = postProperties.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = (String)postProperties.get(key);
                registry.put(key, value);
            }
        }
        if (standalone && !registry.containsKey(PYTHON_CACHEDIR_SKIP)) {
            registry.put(PYTHON_CACHEDIR_SKIP, "true");
        }
        Options.setFromRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addRegistryFile(File file) {
        if (file.exists()) {
            if (!file.isDirectory()) {
                registry = new Properties(registry);
                try {
                    FileInputStream fp = new FileInputStream(file);
                    try {
                        registry.load(fp);
                    }
                    finally {
                        fp.close();
                    }
                }
                catch (IOException e) {
                    System.err.println("couldn't open registry file: " + file.toString());
                }
            } else {
                System.err.println("warning: " + file.toString() + " is a directory, not a file");
            }
        }
    }

    public static Properties getBaseProperties() {
        try {
            return System.getProperties();
        }
        catch (AccessControlException ace) {
            return new Properties();
        }
    }

    public static synchronized void initialize() {
        if (initialized) {
            return;
        }
        PySystemState.initialize(PySystemState.getBaseProperties(), null, new String[]{""});
    }

    public static synchronized void initialize(Properties preProperties, Properties postProperties, String[] argv) {
        PySystemState.initialize(preProperties, postProperties, argv, null);
    }

    public static synchronized void initialize(Properties preProperties, Properties postProperties, String[] argv, ClassLoader classLoader) {
        PySystemState.initialize(preProperties, postProperties, argv, classLoader, new ClassicPyObjectAdapter());
    }

    public static synchronized void initialize(Properties preProperties, Properties postProperties, String[] argv, ClassLoader classLoader, ExtensiblePyObjectAdapter adapter) {
        if (initialized) {
            return;
        }
        initialized = true;
        Py.setAdapter(adapter);
        boolean standalone = false;
        String jarFileName = PySystemState.getJarFileName();
        if (jarFileName != null) {
            standalone = PySystemState.isStandalone(jarFileName);
        }
        PySystemState.initRegistry(preProperties, postProperties, standalone, jarFileName);
        PySystemState.initBuiltins(registry);
        PySystemState.initStaticFields();
        defaultPath = PySystemState.initPath(registry, standalone, jarFileName);
        defaultArgv = PySystemState.initArgv(argv);
        PySystemState.initPackages(registry);
        Py.defaultSystemState = new PySystemState();
        Py.setSystemState(Py.defaultSystemState);
        if (classLoader != null) {
            Py.defaultSystemState.setClassLoader(classLoader);
        }
        Py.initClassExceptions(builtins);
        new PySyntaxError("", 1, 1, "", "");
    }

    private static void initStaticFields() {
        Py.None = new PyNone();
        Py.NotImplemented = new PyNotImplemented();
        Py.NoKeywords = new String[0];
        Py.EmptyObjects = new PyObject[0];
        Py.EmptyTuple = new PyTuple(Py.EmptyObjects);
        Py.NoConversion = new PySingleton("Error");
        Py.Ellipsis = new PyEllipsis();
        Py.Zero = new PyInteger(0);
        Py.One = new PyInteger(1);
        Py.EmptyString = new PyString("");
        Py.Newline = new PyString("\n");
        Py.Space = new PyString(" ");
        Py.stderr = new StderrWrapper();
        Py.stdout = new StdoutWrapper();
        String s = null;
        if (PY_RELEASE_LEVEL == 10) {
            s = "alpha";
        } else if (PY_RELEASE_LEVEL == 11) {
            s = "beta";
        } else if (PY_RELEASE_LEVEL == 12) {
            s = "candidate";
        } else if (PY_RELEASE_LEVEL == 15) {
            s = "final";
        } else if (PY_RELEASE_LEVEL == 170) {
            s = "snapshot";
        }
        version_info = new PyTuple(new PyObject[]{Py.newInteger(PY_MAJOR_VERSION), Py.newInteger(PY_MINOR_VERSION), Py.newInteger(PY_MICRO_VERSION), Py.newString(s), Py.newInteger(PY_RELEASE_SERIAL)});
    }

    public static boolean isPackageCacheEnabled() {
        return cachedir != null;
    }

    private static void initCacheDirectory(Properties props) {
        if (Py.frozen) {
            cachedir = null;
            return;
        }
        String skip = props.getProperty(PYTHON_CACHEDIR_SKIP, "false");
        if (skip.equalsIgnoreCase("true")) {
            cachedir = null;
            return;
        }
        cachedir = new File(props.getProperty(PYTHON_CACHEDIR, CACHEDIR_DEFAULT_NAME));
        if (!cachedir.isAbsolute()) {
            cachedir = new File(prefix, cachedir.getPath());
        }
    }

    private static void initPackages(Properties props) {
        PySystemState.initCacheDirectory(props);
        File pkgdir = cachedir != null ? new File(cachedir, "packages") : null;
        packageManager = new SysPackageManager(pkgdir, props);
    }

    private static PyList initArgv(String[] args) {
        PyList argv = new PyList();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                argv.append(new PyString(args[i]));
            }
        }
        return argv;
    }

    private static void addBuiltin(String name) {
        String classname;
        String modname;
        int colon = name.indexOf(58);
        if (colon != -1) {
            modname = name.substring(0, colon).trim();
            classname = name.substring(colon + 1, name.length()).trim();
            if (classname.equals("null")) {
                classname = null;
            }
        } else {
            modname = name.trim();
            classname = "org.python.modules." + modname;
        }
        if (classname != null) {
            builtinNames.put(modname, classname);
        } else {
            builtinNames.remove(modname);
        }
    }

    private static void initBuiltins(Properties props) {
        builtinNames = new Hashtable();
        for (int i = 0; i < Setup.builtinModules.length; ++i) {
            PySystemState.addBuiltin(Setup.builtinModules[i]);
        }
        String builtinprop = props.getProperty("python.modules.builtin", "");
        StringTokenizer tok = new StringTokenizer(builtinprop, ",");
        while (tok.hasMoreTokens()) {
            PySystemState.addBuiltin(tok.nextToken());
        }
        int n = builtinNames.size();
        builtin_module_names = new String[n];
        Enumeration keys = builtinNames.keys();
        for (int i = 0; i < n; ++i) {
            PySystemState.builtin_module_names[i] = (String)keys.nextElement();
        }
    }

    static String getBuiltin(String name) {
        return (String)builtinNames.get(name);
    }

    private static PyList initPath(Properties props, boolean standalone, String jarFileName) {
        PyList path = new PyList();
        if (!Py.frozen) {
            PySystemState.addPaths(path, props.getProperty("python.prepath", ""));
            if (prefix != null) {
                String libpath = new File(prefix, "Lib").toString();
                path.append(new PyString(libpath));
            }
            PySystemState.addPaths(path, props.getProperty("python.path", ""));
        }
        if (standalone) {
            PySystemState.addPaths(path, jarFileName + "/Lib");
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isStandalone(String jarFileName) {
        boolean standalone = false;
        if (jarFileName != null) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(jarFileName);
                JarEntry jarEntry = jarFile.getJarEntry("Lib/javaos.py");
                standalone = jarEntry != null;
            }
            catch (IOException ioe) {
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return standalone;
    }

    private static String getJarFileName() {
        String fullClassName;
        String className;
        String jarFileName = null;
        Class thisClass = PySystemState.class;
        URL url = thisClass.getResource((className = (fullClassName = thisClass.getName()).substring(fullClassName.lastIndexOf(".") + 1)) + ".class");
        if (url != null) {
            try {
                String urlString = URLDecoder.decode(url.toString());
                int jarSeparatorIndex = urlString.indexOf(JAR_SEPARATOR);
                if (urlString.startsWith(JAR_URL_PREFIX) && jarSeparatorIndex > 0) {
                    jarFileName = urlString.substring(JAR_URL_PREFIX.length(), jarSeparatorIndex);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return jarFileName;
    }

    private static void addPaths(PyList path, String pypath) {
        StringTokenizer tok = new StringTokenizer(pypath, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            path.append(new PyString(tok.nextToken().trim()));
        }
    }

    public static PyJavaPackage add_package(String n) {
        return PySystemState.add_package(n, null);
    }

    public static PyJavaPackage add_package(String n, String contents) {
        return packageManager.makeJavaPackage(n, contents, null);
    }

    public static void add_classdir(String directoryPath) {
        packageManager.addDirectory(new File(directoryPath));
    }

    public static void add_extdir(String directoryPath) {
        packageManager.addJarDir(directoryPath, false);
    }

    public static void add_extdir(String directoryPath, boolean cache) {
        packageManager.addJarDir(directoryPath, cache);
    }

    public void settrace(PyObject tracefunc) {
        this.tracefunc = tracefunc == Py.None ? null : new PythonTraceFunction(tracefunc);
    }

    public void setprofile(PyObject profilefunc) {
        this.profilefunc = profilefunc == Py.None ? null : new PythonTraceFunction(profilefunc);
    }

    private InputStream getSystemIn() {
        if (Options.pollStandardIn) {
            return new PollingInputStream(System.in);
        }
        return System.in;
    }

    public String getdefaultencoding() {
        return codecs.getDefaultEncoding();
    }

    public void setdefaultencoding(String encoding) {
        codecs.setDefaultEncoding(encoding);
    }

    static void displayhook(PyObject o) {
        if (o == Py.None) {
            return;
        }
        PySystemState sys = Py.getThreadState().systemState;
        builtins.__setitem__("_", Py.None);
        Py.stdout.println(o.__repr__());
        builtins.__setitem__("_", o);
    }

    static void excepthook(PyObject type, PyObject val, PyObject tb) {
        Py.displayException(type, val, tb, null);
    }

    public void callExitFunc() throws PyIgnoreMethodTag {
        PyObject exitfunc = this.__findattr__("exitfunc");
        if (exitfunc != null) {
            try {
                exitfunc.__call__();
            }
            catch (PyException exc) {
                if (!Py.matchException(exc, Py.SystemExit)) {
                    Py.println(this.stderr, Py.newString("Error in sys.exitfunc:"));
                }
                Py.printException(exc);
            }
        }
    }

    static {
        maxunicode = 65535;
        copyright = "Copyright (c) 2000-2007, Jython Developers\nAll rights reserved.\n\nCopyright (c) 2000 BeOpen.com.\nAll Rights Reserved.\n\nCopyright (c) 2000 The Apache Software Foundation.  All rights\nreserved.\n\nCopyright (c) 1995-2000 Corporation for National Research Initiatives.\nAll Rights Reserved.\n\nCopyright (c) 1991-1995 Stichting Mathematisch Centrum, Amsterdam.\nAll Rights Reserved.\n\n";
        platform = "java";
        byteorder = "big";
        maxint = Integer.MAX_VALUE;
        minint = Integer.MIN_VALUE;
        exec_prefix = "";
        initialized = false;
        builtin_module_names = null;
    }
}

