/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.autoplot.ScriptContext;
import org.autoplot.bookmarks.Bookmark;
import org.autoplot.bookmarks.BookmarksException;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.datasource.URISplit;
import org.autoplot.dom.Application;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.jythonsupport.Util;
import org.autoplot.state.StatePersistence;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.filesystem.HtmlUtil;
import org.das2.util.monitor.CancelledOperationException;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.xml.sax.SAXException;

public class Test140 {
    private static int testid;

    private static String getUniqueFilename(String name, String ext, boolean append) {
        File ff = new File(name + ext);
        while (ff.exists()) {
            name = name + "_";
            ff = new File(name + ".png");
        }
        if (append) {
            return name + ext;
        }
        return name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String do1(String uri, int iid, boolean doTest, boolean isPublic) throws Exception {
        String result;
        String name;
        Object dom;
        System.err.printf("== %03d ==\n", iid);
        if (isPublic) {
            System.err.printf("uri: %s\n", uri);
        } else {
            System.err.printf("uri: (uri is not public)\n", new Object[0]);
        }
        String label = String.format("test%03d_%03d", testid, iid);
        long t0 = System.currentTimeMillis();
        double tsec = t0;
        double psec = t0;
        QDataSet ds = null;
        if (uri.endsWith(".vap") || uri.contains(".vap?timerange=")) {
            if (isPublic) {
                URISplit split = URISplit.parse(uri);
                try (InputStream in = DataSetURI.getInputStream(split.resourceUri, (ProgressMonitor)new NullProgressMonitor());){
                    dom = StatePersistence.restoreState(in, URISplit.parseParams(split.params));
                    for (DataSourceFilter dsf : ((Application)dom).getDataSourceFilters()) {
                        System.err.printf("  %s: %s\n", dsf.getId(), dsf.getUri());
                    }
                    System.err.println("  timerange: " + ((Application)dom).getTimeRange());
                }
            }
            ScriptContext.load(uri);
            ds = ScriptContext.getDocumentModel().getDataSourceFilters(0).getController().getDataSet();
            tsec = (double)(System.currentTimeMillis() - t0) / 1000.0;
            if (ds == null) throw new IllegalArgumentException("a dataset from the vap was null: " + uri);
            MutablePropertyDataSet hist = (MutablePropertyDataSet)Ops.autoHistogram(ds);
            hist.putProperty("LABEL", label);
            ScriptContext.formatDataSet(hist, Test140.getUniqueFilename(label, ".qds", true));
        } else if (uri.startsWith("script:")) {
            System.err.println("skipping script");
        } else if (uri.startsWith("bookmarks:")) {
            System.err.println("skipping bookmarks");
        } else if (uri.startsWith("pngwalk:")) {
            System.err.println("skipping pngwalk");
        } else {
            ds = Util.getDataSet(uri);
            tsec = (double)(System.currentTimeMillis() - t0) / 1000.0;
            if (ds == null) throw new IllegalArgumentException("uri results in null dataset: " + uri);
            if (isPublic) {
                MutablePropertyDataSet hist = (MutablePropertyDataSet)Ops.autoHistogram(ds);
                hist.putProperty("TITLE", uri);
                hist.putProperty("LABEL", label);
                ScriptContext.formatDataSet(hist, label + ".qds");
                QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
                if (dep0 != null) {
                    MutablePropertyDataSet hist2 = (MutablePropertyDataSet)Ops.autoHistogram(dep0);
                    ScriptContext.formatDataSet(hist2, label + ".dep0.qds");
                } else {
                    PrintWriter pw = new PrintWriter(label + ".dep0.qds");
                    dom = null;
                    try {
                        pw.println("no dep0");
                    }
                    catch (Throwable throwable) {
                        dom = throwable;
                        throw throwable;
                    }
                    finally {
                        if (pw != null) {
                            if (dom != null) {
                                try {
                                    pw.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)dom).addSuppressed(throwable);
                                }
                            } else {
                                pw.close();
                            }
                        }
                    }
                }
            } else {
                System.err.println("TODO Turkey: Make a hash of the .qds of the data");
            }
            ScriptContext.plot(ds);
            ScriptContext.setCanvasSize(450, 300);
            ScriptContext.getDocumentModel().getCanvases(0).getMarginColumn().setLeft("5.0em");
            ScriptContext.getDocumentModel().getCanvases(0).getMarginColumn().setRight("100.00%-10.0em");
            int i = uri.lastIndexOf("/");
            ScriptContext.getApplicationModel().waitUntilIdle();
            String fileUri = uri.substring(i + 1);
            if (!ScriptContext.getDocumentModel().getPlotElements(0).getComponent().equals("")) {
                String dsstr = String.valueOf(ScriptContext.getDocumentModel().getDataSourceFilters(0).getController().getDataSet());
                fileUri = fileUri + " " + dsstr + " " + ScriptContext.getDocumentModel().getPlotElements(0).getComponent();
            }
            ScriptContext.setTitle(fileUri);
            psec = (double)(System.currentTimeMillis() - t0) / 1000.0;
        }
        if (isPublic) {
            System.err.println("dataset: " + ds);
        } else {
            System.err.println("dataset: (data is not public)");
        }
        if (doTest) {
            String id = URLEncoder.encode(uri, "US-ASCII");
            id = id.replaceAll("%3A", "");
            id = id.replaceAll("%2F%2F", "_");
            if ((id = id.replaceAll("%[0-9A-F][0-9A-F]", "_")).length() > 150) {
                id = id.substring(0, 150) + "..." + String.format("%016d", id.hashCode());
            }
            if (!isPublic) {
                id = String.format("%08x", id.hashCode());
            }
            result = name = String.format("test%03d_%s", testid, id);
        } else {
            name = String.format("ex_test%03d_%03d", testid, iid);
            result = null;
        }
        String name1 = Test140.getUniqueFilename(name, ".png", true);
        if (isPublic) {
            ScriptContext.writeToPng(name1);
        } else {
            ScriptContext.writeToPng("/home/jbf/ct/hudson/privateArtifacts/" + name1);
            int width = ScriptContext.getApplicationModel().getDocumentModel().getController().getCanvas().getWidth();
            int height = ScriptContext.getApplicationModel().getDocumentModel().getController().getCanvas().getHeight();
            BufferedImage image = ScriptContext.getApplicationModel().getDocumentModel().getController().getCanvas().getController().getDasCanvas().getImage(width, height);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", outputStream);
            byte[] data = outputStream.toByteArray();
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(data);
            byte[] hash = md.digest();
            try (PrintStream bout = new PrintStream(new FileOutputStream(Test140.getUniqueFilename(name, ".txt", true)));){
                for (byte b : hash) {
                    bout.println(String.format("%03d", b));
                }
            }
        }
        if (isPublic) {
            System.err.printf("wrote to file: %s\n", name1);
            System.err.printf("Read in %9.3f seconds (%s): %s\n", tsec, label, uri);
            System.err.printf("Plot in %9.3f seconds (%s): %s\n", psec, label, uri);
        } else {
            System.err.printf("wrote to file: %s\n", "/home/jbf/ct/hudson/privateArtifacts/" + name1);
            System.err.printf("Read in %9.3f seconds (%s): %s\n", tsec, label, "(uri is not public)");
            System.err.printf("Plot in %9.3f seconds (%s): %s\n", psec, label, "(uri is not public)");
        }
        if (!uri.endsWith(".vap") && !uri.contains(".vap?timerange=")) return result;
        ScriptContext.reset();
        return result;
    }

    private static int doBookmarks(File f, int iid, Map<String, Exception> exceptions, Map<String, Integer> exceptionNumbers) throws IOException, SAXException, BookmarksException {
        List<Bookmark> books = Bookmark.parseBookmarks(f.toURI().toURL());
        return Test140.doBookmarks(books, iid, exceptions, exceptionNumbers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int doBookmarks(List<Bookmark> books, int iid, Map<String, Exception> exceptions, Map<String, Integer> exceptionNumbers) throws IOException, SAXException, BookmarksException {
        for (Bookmark b : books) {
            boolean hidden = b.isHidden();
            if (!hidden) {
                if (b instanceof Bookmark.Folder) {
                    if (((Bookmark.Folder)b).getRemoteUrl() != null) {
                        System.err.println("Skipping remote bookmarks file " + ((Bookmark.Folder)b).getRemoteUrl());
                        continue;
                    }
                    iid = Test140.doBookmarks(((Bookmark.Folder)b).getBookmarks(), iid, exceptions, exceptionNumbers);
                    continue;
                }
                String uri = ((Bookmark.Item)b).getUri();
                try {
                    Test140.do1(uri, iid, true, true);
                    continue;
                }
                catch (Exception ex) {
                    exceptions.put(uri, ex);
                    continue;
                }
                finally {
                    ++iid;
                    continue;
                }
            }
            if (b instanceof Bookmark.Folder) {
                System.err.println("Skipping hidden bookmark: \n\t" + b.getTitle() + "\n\t" + b.getDescription());
                continue;
            }
            if (!(b instanceof Bookmark.Item)) continue;
            System.err.println("Skipping hidden bookmark: \n\t" + ((Bookmark.Item)b).getUri() + "\n\t" + b.getTitle() + "\n\t" + b.getDescription());
            ++iid;
        }
        return iid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int doHtml(URL url, int iid, Map<String, Exception> exceptions, Map<String, Integer> exceptionNumbers) throws IOException, CancelledOperationException {
        try (InputStream in = url.openStream();){
            URL[] urls = HtmlUtil.getDirectoryListing(url, in, false);
            ArrayList result = new ArrayList();
            ArrayList<String> sresult = new ArrayList<String>();
            for (URL url1 : urls) {
                if (!url1.getFile().endsWith(".vap") && !url1.getFile().contains("autoplot.jnlp?")) continue;
                String s = url1.toString();
                if (s.startsWith("http://autoplot.org/autoplot.jnlp?")) {
                    s = s.substring(34);
                }
                s = s.replaceAll(" ", "+");
                s = DataSourceUtil.unescape(s);
                sresult.add(s);
            }
            for (String suri : sresult) {
                try {
                    Test140.do1(suri, iid, true, true);
                }
                catch (Exception ex) {
                    exceptions.put(suri, ex);
                    exceptionNumbers.put(suri, iid);
                }
                finally {
                    ++iid;
                }
            }
            int n = iid;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int doHistory(File f, int iid, Map<String, Exception> exceptions, Map<String, Integer> exceptionNumbers) throws IOException {
        try (BufferedReader read = new BufferedReader(new FileReader(f));){
            String s = read.readLine();
            while (s != null) {
                int i = s.indexOf(35);
                if (i > -1) {
                    s = s.substring(0, i);
                }
                if ((s = s.trim()).length() > 0) {
                    String[] ss = s.split("\t");
                    String uri = ss[ss.length - 1].trim();
                    boolean publc = true;
                    if (ss.length > 1) {
                        boolean isPrivate = ss[ss.length - 2].trim().startsWith("x");
                        boolean bl = publc = !isPrivate;
                    }
                    if (uri.startsWith("x ")) {
                        uri = uri.substring(2).trim();
                        publc = false;
                    }
                    try {
                        Test140.do1(uri, iid, true, publc);
                    }
                    catch (Exception ex) {
                        exceptions.put(uri, ex);
                        exceptionNumbers.put(uri, iid);
                    }
                    finally {
                        ++iid;
                    }
                }
                s = read.readLine();
            }
            int n = iid;
            return n;
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            args = new String[]{"099", "/home/jbf/ct/hudson/test099.txt"};
        }
        testid = Integer.parseInt(args[0]);
        int iid = 0;
        LinkedHashMap<String, Exception> exceptions = new LinkedHashMap<String, Exception>();
        LinkedHashMap<String, Integer> exceptionNumbers = new LinkedHashMap<String, Integer>();
        ScriptContext.getDocumentModel().getOptions().setAutolayout(false);
        for (int i = 1; i < args.length; ++i) {
            File ff;
            String uri = args[i];
            System.err.println("\n=======================");
            System.err.println("== from " + uri);
            System.err.println("=======================\n");
            if (uri.endsWith(".xml")) {
                ff = DataSetURI.getFile(uri, (ProgressMonitor)new NullProgressMonitor());
                iid = Test140.doBookmarks(ff, iid, exceptions, exceptionNumbers);
            } else if (uri.endsWith(".txt")) {
                ff = DataSetURI.getFile(uri, (ProgressMonitor)new NullProgressMonitor());
                iid = Test140.doHistory(ff, iid, exceptions, exceptionNumbers);
            } else {
                iid = Test140.doHtml(new URL(uri), iid, exceptions, exceptionNumbers);
            }
            iid = ((iid + 1) / 100 + 1) * 100;
        }
        System.err.println("\n\n=== Exceptions encountered ==============");
        for (Map.Entry e : exceptions.entrySet()) {
            System.err.println(String.format("== %4d: %s ==", exceptionNumbers.get(e.getKey()), e.getKey()));
            ((Exception)e.getValue()).printStackTrace();
        }
        if (exceptions.isEmpty()) {
            System.err.println("(none)\n\n");
            System.exit(0);
        } else {
            System.err.println("(" + exceptions.size() + " exceptions)\n\n");
            System.exit(1);
        }
        System.err.println("\n\n==============");
    }
}

