/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.GraphUtil;
import org.das2.graph.Renderer;
import org.das2.graph.SeriesRenderer;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.AboutUtil;
import org.das2.util.LoggerManager;
import test.graph.QFunctionLarry;

public class Test039 {
    private static final boolean headless = "true".equals(System.getProperty("java.awt.headless"));

    private static void testTCA() throws ParseException, IOException {
        int width = 500;
        int height = 400;
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        DasCanvas canvas = new DasCanvas(width, height);
        canvas.setAntiAlias(true);
        panel.add((Component)canvas, "Center");
        QDataSet yds = Ops.sin(Ops.linspace(0.0, 10.0, 1000));
        QDataSet tds = Ops.timegen("2010-01-01T00:00", "1 s", 1000);
        QDataSet ds = Ops.link(tds, yds);
        DasAxis xaxis = GraphUtil.guessXAxis(ds);
        DasAxis yaxis = GraphUtil.guessYAxis(ds);
        DasPlot plot = new DasPlot(xaxis, yaxis);
        Renderer r = GraphUtil.guessRenderer(ds);
        plot.addRenderer(r);
        if (r instanceof SeriesRenderer) {
            ((SeriesRenderer)r).setAntiAliased(true);
        }
        xaxis.setTcaFunction(new QFunctionLarry());
        xaxis.setDrawTca(true);
        canvas.add(plot, DasRow.create(canvas, null, "0%+2em", "100%-5em"), DasColumn.create(canvas, null, "0%+14em", "100%-4em"));
        canvas.setPrintingTag("APL $Y");
        canvas.writeToPng("test039_tca.png");
    }

    public static void demoSpectrogram() throws IOException {
        try {
            QDataSet yds = Ops.pow((Object)10, (Object)Ops.linspace(3.0, 8.0, 30));
            QDataSet tds = Ops.timegen("2015-03-31T00:00", "30 min", 48);
            Ops.randomSeed(5334L);
            QDataSet zz = Ops.randn(48, 30);
            zz = Ops.link(tds, yds, zz);
            DasAxis xaxis = GraphUtil.guessXAxis(zz);
            DasAxis yaxis = new DasAxis(Datum.create(100.0, Units.dimensionless), Datum.create(1.0E9, Units.dimensionless), 3, true);
            DasPlot plot = new DasPlot(xaxis, yaxis);
            Renderer r = GraphUtil.guessRenderer(zz);
            plot.addRenderer(r);
            plot.setPreviewEnabled(true);
            DasCanvas canvas = new DasCanvas(600, 400);
            canvas.add(plot, DasRow.create(canvas, null, "0%+2em", "100%-5em"), DasColumn.create(canvas, null, "0%+4em", "100%-4em"));
            canvas.setPrintingTag("demoSpectrogram");
            canvas.writeToPng("test039_spectrogram.png");
            if (!headless) {
                JOptionPane.showMessageDialog(null, canvas);
            }
        }
        catch (ParseException ex) {
            Logger.getLogger(Test039.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void demoTicks() throws IOException {
        try {
            QDataSet yds = Ops.pow((Object)10, (Object)Ops.linspace(3.0, 8.0, 30));
            QDataSet tds = Ops.timegen("2015-03-31T00:00", "30 min", 48);
            Ops.randomSeed(5334L);
            QDataSet zz = Ops.randn(48, 30);
            zz = Ops.link(tds, yds, zz);
            DasAxis xaxis = GraphUtil.guessXAxis(zz);
            DasAxis yaxis = new DasAxis(Datum.create(100.0, Units.dimensionless), Datum.create(1.0E9, Units.dimensionless), 3, true);
            DasPlot plot = new DasPlot(xaxis, yaxis);
            double[] ticks = new double[]{10000.0, 1000000.0, 1.0E8};
            yaxis.setTickV(ticks, ticks);
            Renderer r = GraphUtil.guessRenderer(zz);
            plot.addRenderer(r);
            plot.setPreviewEnabled(true);
            DasCanvas canvas = new DasCanvas(600, 400);
            canvas.add(plot, DasRow.create(canvas, null, "0%+2em", "100%-5em"), DasColumn.create(canvas, null, "0%+7em", "100%-4em"));
            canvas.setPrintingTag("demoTicks");
            canvas.writeToPng("test039_demoTicks.png");
            if (!headless) {
                JOptionPane.showMessageDialog(null, canvas);
            }
        }
        catch (ParseException ex) {
            Logger.getLogger(Test039.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) throws Exception {
        String[] ss;
        String s = AboutUtil.getAboutHtml();
        for (String sss : ss = s.split("\\<br\\>")) {
            System.err.println(sss);
        }
        LoggerManager.getLogger("das2.graphics.axis").setLevel(Level.ALL);
        if (args.length == 0 || args[0].contains("tca")) {
            Test039.testTCA();
        }
        if (args.length == 0 || args[0].contains("spectrogram")) {
            Test039.demoSpectrogram();
        }
        if (args.length == 0 || args[0].contains("ticks")) {
            Test039.demoTicks();
        }
        System.exit(0);
    }
}

