/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import org.autoplot.jythonsupport.JythonUtil;
import org.python.util.InteractiveInterpreter;

public class Test038 {
    static final Logger logger = Logger.getLogger("autoplot");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doTestGetParams(String testId, String file) {
        long t0 = System.currentTimeMillis();
        System.err.println("== test " + testId + ": " + file + " ==");
        try {
            String script = JythonUtil.readScript(new FileReader(file));
            String scrip = JythonUtil.simplifyScriptToGetParams(script, true);
            File f = new File(file);
            String fout = "./test038_" + f.getName();
            try (FileWriter fw = new FileWriter(fout);){
                fw.append(scrip);
            }
            List<JythonUtil.Param> parms = JythonUtil.getGetParams(script);
            for (JythonUtil.Param p : parms) {
                System.err.println(p);
            }
            System.err.println(String.format("read params in %d millis: %s\n", System.currentTimeMillis() - t0, file));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(String.format("failed within %d millis: %s\n", System.currentTimeMillis() - t0, file));
        }
    }

    public static void testGetParams() {
        Test038.doTestGetParams("009", "/home/jbf/ct/hudson/script/test038/jydsCommentBug.jyds");
        Test038.doTestGetParams("008", "/home/jbf/ct/hudson/script/test038/jedi_l3_valid_tofxe_events.jyds");
        Test038.doTestGetParams("000", "/home/jbf/ct/hudson/script/test038/trivial.jy");
        Test038.doTestGetParams("001", "/home/jbf/ct/hudson/script/test038/demoParms0.jy");
        Test038.doTestGetParams("002", "/home/jbf/ct/hudson/script/test038/demoParms1.jy");
        Test038.doTestGetParams("003", "/home/jbf/ct/hudson/script/test038/demoParms.jy");
        Test038.doTestGetParams("004", "/home/jbf/ct/hudson/script/test038/rbsp/emfisis/background_removal_wfr.jyds");
        Test038.doTestGetParams("005", "/home/jbf/ct/hudson/script/test038/demoParms2.jy");
        Test038.doTestGetParams("006", "/home/jbf/ct/hudson/script/test038/fce_A.jyds");
        Test038.doTestGetParams("007", "/home/jbf/ct/hudson/script/test038/fce_A_2.jyds");
    }

    public static void main(String[] args) throws IOException {
        long t0 = System.currentTimeMillis();
        InteractiveInterpreter interp = JythonUtil.createInterpreter(true);
        interp.eval("1+2");
        System.err.println(String.format("== first initialize in %d millis\n", System.currentTimeMillis() - t0));
        Test038.testGetParams();
    }
}

