/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.autoplot.jythonsupport.JythonUtil;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.qds.DRank0DataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PyReflectedFunction;
import org.python.util.InteractiveInterpreter;

public class Test029 {
    public static void main(String[] args) throws IOException {
        int status = Test029.testStringToDataSet();
        if (status != 0) {
            System.exit(status);
        }
        if ((status = Test029.testBuiltIns()) != 0) {
            System.exit(status);
        }
        if ((status = Test029.testJythonLib()) != 0) {
            System.exit(status);
        }
    }

    private static int testJythonLib() throws IOException {
        int c;
        URL s = Test029.class.getResource("/glob.py");
        InputStream in = s.openStream();
        int count = 0;
        while ((c = in.read()) != -1) {
            if (c != 10) continue;
            ++count;
        }
        in.close();
        System.err.printf("glob.py is approx %d lines long.\n", count);
        InteractiveInterpreter interp = JythonUtil.createInterpreter(false);
        interp.exec("import glob\n");
        PyObject res = interp.eval("glob.glob('*')\n");
        System.err.println(res);
        return 0;
    }

    private static int testBuiltIns() throws IOException {
        String builtIns = "abs() \tdivmod() \tinput() \topen() \tstaticmethod() all() \tenumerate() \tint() \tord() \tstr() any() \teval() \tisinstance() \tpow() \tsum() basestring() \texecfile() \tissubclass() \tprint() \tsuper() bin() \tfile() \titer() \tproperty() \ttuple() bool() \tfilter() \tlen() \trange() \ttype() bytearray() \tfloat() \tlist() \traw_input() \tunichr() callable() \tformat() \tlocals() \treduce() \tunicode()chr() \tfrozenset() \tlong() \treload() \tvars()classmethod() \tgetattr() \tmap() \trepr() \txrange()cmp() \tglobals() \tmax() \treversed() \tzip()compile() \thasattr() \tmemoryview() \tround() \t__import__()complex() \thash() \tmin() \tset() \tapply()delattr() \thelp() \tnext() \tsetattr() \tbuffer()dict() \thex() \tobject() \tslice() \tcoerce()dir() \tid() \toct() \tsorted() \tintern()";
        String supported = "abs() pow() round()";
        String notYetSupported = "all() any()  print()  bin()  bytearray()   format()  frozenset()   reversed()   memoryview()   set()   help()   next()   buffer()   sorted() ";
        String[] bb = builtIns.replaceAll("\\(\\)", " ").split("\\s+");
        InteractiveInterpreter interp = JythonUtil.createInterpreter(false);
        for (int i = 0; i < bb.length; ++i) {
            String b = bb[i];
            try {
                PyObject result = interp.eval(b);
                if (result instanceof PyReflectedFunction) {
                    System.err.println("!!!" + b + ": " + result);
                    if (supported.contains(b)) continue;
                    return -3;
                }
                System.err.println("   " + b + ": " + result);
                continue;
            }
            catch (PyException ex) {
                System.err.println("Error finding symbol \"" + b + "\"");
                if (notYetSupported.contains(b)) continue;
                return -2;
            }
        }
        return 0;
    }

    private static int equiv(QDataSet norm, QDataSet test) {
        return Ops.equivalent(norm, test) ? 0 : 1;
    }

    private static int testStringToDataSet() {
        DRank0DataSet r0 = DataSetUtil.asDataSet(0.0, Units.dimensionless);
        QDataSet r1 = Ops.indgen(4);
        DRank0DataSet t1 = DataSetUtil.asDataSet(TimeUtil.toDatum(new int[]{2014, 1, 1, 0, 0, 0, 0}));
        DRank0DataSet r0_2014 = DataSetUtil.asDataSet(2014.0);
        DRank0DataSet r0_2014_s = DataSetUtil.asDataSet(2014.0, Units.seconds);
        QDataSet tr1 = DataSetUtil.asDataSet(DatumRangeUtil.parseValidISO8601Range("2014-01-01T00:00/2014-01-04T00:00"));
        int r = Test029.equiv(r0, Ops.dataset("0"));
        if (r != 0) {
            throw new IllegalStateException("failed to make dataset: 0");
        }
        r = Test029.equiv(t1, Ops.dataset("2014-01-01T00:00"));
        if (r != 0) {
            throw new IllegalStateException("failed to make dataset: time");
        }
        r = Test029.equiv(tr1, Ops.dataset("2014-01-01T00:00/2014-01-04T00:00"));
        if (r != 0) {
            throw new IllegalStateException("failed to make dataset: time range");
        }
        r = Test029.equiv(tr1, Ops.dataset("2014-01-01T00:00/P3D"));
        if (r != 0) {
            throw new IllegalStateException("failed to make dataset: time range");
        }
        r = Test029.equiv(tr1, Ops.dataset("P3D/2014-01-04T00:00"));
        if (r != 0) {
            throw new IllegalStateException("failed to make dataset: time range");
        }
        r = Test029.equiv(r0_2014, Ops.dataset("2014"));
        if (r != 0) {
            throw new IllegalStateException("failed to make dataset: datum");
        }
        r = Test029.equiv(r0_2014, Ops.dataset("2014."));
        if (r != 0) {
            throw new IllegalStateException("failed to make dataset: datum with decimal");
        }
        r = Test029.equiv(r0_2014_s, Ops.dataset("2014s"));
        if (r != 0) {
            throw new IllegalStateException("failed to make dataset: datum with units");
        }
        r = Test029.equiv(r1, Ops.dataset(new int[]{0, 1, 2, 3}));
        if (r != 0) {
            throw new IllegalStateException("failed to make dataset: array");
        }
        return 0;
    }
}

