/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.io.PrintWriter;
import org.autoplot.ScriptContext;
import org.autoplot.jythonsupport.Util;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;

public class Test025 {
    public static void doTest(int id, String uri) throws Exception {
        long t0 = System.currentTimeMillis();
        QDataSet ds = Util.getDataSet(uri);
        if (ds == null) {
            throw new NullPointerException("URI results in null: " + uri);
        }
        double t = (double)(System.currentTimeMillis() - t0) / 1000.0;
        MutablePropertyDataSet hist = (MutablePropertyDataSet)Ops.autoHistogram(ds);
        hist.putProperty("TITLE", uri);
        String label = String.format("test025_%03d", id);
        hist.putProperty("LABEL", label);
        ScriptContext.formatDataSet(hist, label + ".qds");
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 != null) {
            MutablePropertyDataSet hist2 = (MutablePropertyDataSet)Ops.autoHistogram(dep0);
            ScriptContext.formatDataSet(hist2, label + ".dep0.qds");
        } else {
            PrintWriter pw = new PrintWriter(label + ".dep0.qds");
            pw.println("no dep0");
            pw.close();
        }
        ScriptContext.plot(ds);
        int i = uri.lastIndexOf("/");
        ScriptContext.setTitle(uri.substring(i + 1));
        ScriptContext.writeToPng(String.format("test025_%03d.png", id));
        System.err.printf("Read in %9.3f seconds (%s): %s\n", t, label, uri);
    }

    public static void main(String[] args) {
        try {
            ScriptContext.setCanvasSize(750, 300);
            ScriptContext.getDocumentModel().getOptions().setAutolayout(false);
            ScriptContext.getDocumentModel().getCanvases(0).getMarginColumn().setRight("100%-10em");
            ScriptContext.getDocumentModel().getCanvases(0).getMarginColumn().setLeft("0%+5em");
            ScriptContext.getDocumentModel().getCanvases(0).getMarginRow().setTop("0%+2em");
            ScriptContext.getDocumentModel().getCanvases(0).getMarginRow().setBottom("100%-3em");
            Test025.doTest(0, "file:///home/jbf/ct/hudson/jyds/test025_000.jyds?ds1");
            Test025.doTest(1, "file:///home/jbf/ct/hudson/jyds/test025_000.jyds?ds2");
            ScriptContext.setCanvasSize(500, 500);
            Test025.doTest(2, "file:///home/jbf/ct/hudson/jyds/lambda.jyds?yy");
            Test025.doTest(3, "file:///home/jbf/ct/hudson/jyds/lambda.jyds?zz");
            Test025.doTest(4, "file:///home/jbf/ct/hudson/jyds/lambda.jyds?zz2");
            Test025.doTest(5, "http://autoplot.org/data/imageDiff.jyds");
            Test025.doTest(6, "file:///home/jbf/ct/hudson/jyds/test025_001.jyds?ds2");
            System.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }
}

