/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.io.PrintWriter;
import org.autoplot.ScriptContext;
import org.autoplot.jythonsupport.Util;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;

public class Test023 {
    public static void doTest(int id, String uri) throws Exception {
        long t0 = System.currentTimeMillis();
        QDataSet ds = Util.getDataSet(uri);
        double t = (double)(System.currentTimeMillis() - t0) / 1000.0;
        MutablePropertyDataSet hist = (MutablePropertyDataSet)Ops.autoHistogram(ds);
        hist.putProperty("TITLE", uri);
        String label = String.format("test023_%03d", id);
        hist.putProperty("LABEL", label);
        ScriptContext.formatDataSet(hist, label + ".qds");
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 != null) {
            MutablePropertyDataSet hist2 = (MutablePropertyDataSet)Ops.autoHistogram(dep0);
            ScriptContext.formatDataSet(hist2, label + ".dep0.qds");
        } else {
            PrintWriter pw = new PrintWriter(label + ".dep0.qds");
            pw.println("no dep0");
            pw.close();
        }
        ScriptContext.plot(ds);
        int i = uri.lastIndexOf("/");
        ScriptContext.setTitle(uri.substring(i + 1));
        ScriptContext.writeToPng(String.format("test023_%03d.png", id));
        System.err.printf("Read in %9.3f seconds (%s): %s\n", t, label, uri);
    }

    public static void main(String[] args) {
        try {
            ScriptContext.setCanvasSize(750, 300);
            ScriptContext.getDocumentModel().getOptions().setAutolayout(false);
            ScriptContext.getDocumentModel().getCanvases(0).getMarginColumn().setRight("100%-10em");
            Test023.doTest(0, "file:///home/jbf/ct/hudson/data.backup/h5/SourceAcronym_Subset1-1-v0.h5?ExtendibleArray");
            Test023.doTest(1, "file:///home/jbf/ct/hudson/data/ncml/ap_service_provider_agg.ncml?Elastischer_Modul");
            System.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }
}

