/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import org.das2.datum.Datum;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.IndexListDataSetIterator;
import org.das2.qds.QDataSet;
import org.das2.qds.QubeDataSetIterator;
import org.das2.qds.WritableDataSet;
import org.das2.qds.ops.Ops;

public class Test020 {
    public static void main(String[] args) {
        int i;
        for (i = 0; i < 5; ++i) {
            Test020.testValid();
        }
        for (i = 0; i < 5; ++i) {
            Test020.testValidSlow();
        }
        for (i = 0; i < 5; ++i) {
            Test020.testClosestIndex();
        }
        Test020.testArrayIndexing();
        for (i = 0; i < 10; ++i) {
            Test020.testRank1DDatasetAccess(i > 5);
        }
        for (i = 0; i < 10; ++i) {
            Test020.testRank2DDatasetAccess(i > 5);
        }
    }

    private static void testValid() {
        int SIZE = 10000000;
        WritableDataSet ds = Ops.copy(Ops.findgen(10000000));
        long t0 = System.currentTimeMillis();
        QDataSet wds = Ops.valid(ds);
        System.err.println("  valid returns " + wds.getClass());
        QDataSet r = Ops.where(wds);
        System.err.println("testValid (millis): " + (System.currentTimeMillis() - t0));
    }

    private static void testValidSlow() {
        int SIZE = 10000000;
        WritableDataSet ds = Ops.copy(Ops.findgen(10000000));
        ds.putProperty("VALID_MIN", 0);
        ds.putProperty("VALID_MAX", 10000000);
        long t0 = System.currentTimeMillis();
        QDataSet wds = Ops.valid(ds);
        System.err.println("  valid returns " + wds.getClass());
        QDataSet r = Ops.where(wds);
        System.err.println("testValidSlow (millis): " + (System.currentTimeMillis() - t0));
    }

    private static void testClosestIndex() {
        int SIZE = 10000000;
        WritableDataSet ds = Ops.copy(Ops.findgen(10000000));
        ds.putProperty("VALID_MIN", 0);
        ds.putProperty("VALID_MAX", 10000000);
        long t0 = System.currentTimeMillis();
        int i0 = DataSetUtil.closestIndex(ds, Datum.create(6666666));
        System.err.println("closest index time (millis): " + (System.currentTimeMillis() - t0));
    }

    private static void testRank1DDatasetAccess(boolean print) {
        int SIZE = 1000000;
        double[] dd = new double[1000000];
        double tot = 0.0;
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            tot += dd[i];
        }
        long t1 = System.currentTimeMillis();
        if (print) {
            System.err.println("total from array access=" + tot);
        }
        DDataSet rank1 = DDataSet.wrap(dd);
        tot = 0.0;
        long t02 = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            tot += rank1.value(i);
        }
        long t2 = System.currentTimeMillis();
        if (print) {
            System.err.println("total from DDataSet access=" + tot);
        }
        if (print) {
            System.err.println("array, rank1 DDataSet access (millis): " + (t1 - t0) + ", " + (t2 - t02));
        }
    }

    private static void testRank2DDatasetAccess(boolean print) {
        int SIZE = 1000000;
        int JSIZE = 10;
        double[][] dd = new double[1000000][10];
        double tot = 0.0;
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            for (int j = 0; j < 10; ++j) {
                tot += dd[i][j];
            }
        }
        long t1 = System.currentTimeMillis();
        if (print) {
            System.err.println("total from array access=" + tot);
        }
        double[] dd1 = new double[10000000];
        DDataSet rank2 = DDataSet.wrap(dd1, 1000000, 10);
        tot = 0.0;
        long t02 = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            for (int j = 0; j < 10; ++j) {
                tot += rank2.value(i, j);
            }
        }
        long t2 = System.currentTimeMillis();
        if (print) {
            System.err.println("total from DDataSet access=" + tot);
        }
        if (print) {
            System.err.println("array, rank2 DDataSet access (millis): " + (t1 - t0) + ", " + (t2 - t02));
        }
    }

    private static void testArrayIndexing() {
        QDataSet rank3 = Ops.findgen(400, 50, 60);
        QDataSet rank1 = Ops.shuffle(Ops.findgen(63));
        long t2 = System.currentTimeMillis();
        long t0 = System.currentTimeMillis();
        double tot = 0.0;
        QubeDataSetIterator it = new QubeDataSetIterator(rank3);
        while (it.hasNext()) {
            it.next();
            tot += it.getValue(rank3);
        }
        long t1 = System.currentTimeMillis();
        System.err.printf("total[:,:,:]=%.0f   in %d millis\n", tot, t1 - t0);
        t0 = System.currentTimeMillis();
        tot = 0.0;
        it = new QubeDataSetIterator(rank3);
        it.setIndexIteratorFactory(0, new QubeDataSetIterator.SingletonIteratorFactory(30));
        while (it.hasNext()) {
            it.next();
            tot += it.getValue(rank3);
        }
        t1 = System.currentTimeMillis();
        System.err.printf("total[30,:,:]=%.0f   in %d millis\n", tot, t1 - t0);
        t0 = System.currentTimeMillis();
        tot = 0.0;
        it = new QubeDataSetIterator(rank3);
        it.setIndexIteratorFactory(2, new QubeDataSetIterator.SingletonIteratorFactory(30));
        while (it.hasNext()) {
            it.next();
            tot += it.getValue(rank3);
        }
        t1 = System.currentTimeMillis();
        System.err.printf("total[:,:,30]=%.0f   in %d millis\n", tot, t1 - t0);
        t0 = System.currentTimeMillis();
        tot = 0.0;
        it = new QubeDataSetIterator(rank3);
        it.setIndexIteratorFactory(0, new QubeDataSetIterator.StartStopStepIteratorFactory(100, 300, 1));
        while (it.hasNext()) {
            it.next();
            tot += it.getValue(rank3);
        }
        t1 = System.currentTimeMillis();
        System.err.printf("total[100:300,:,:]=%.0f   in %d millis\n", tot, t1 - t0);
        t0 = System.currentTimeMillis();
        tot = 0.0;
        it = new QubeDataSetIterator(rank3);
        QDataSet list3000 = Ops.add(Ops.replicate(5L, 3000), Ops.mod(Ops.findgen(3000), Ops.replicate(30L, 3000)));
        it.setIndexIteratorFactory(0, new QubeDataSetIterator.IndexListIteratorFactory(list3000));
        it.setIndexIteratorFactory(1, new QubeDataSetIterator.IndexListIteratorFactory(list3000));
        it.setIndexIteratorFactory(2, new QubeDataSetIterator.IndexListIteratorFactory(list3000));
        while (it.hasNext()) {
            it.next();
            tot += it.getValue(rank3);
        }
        t1 = System.currentTimeMillis();
        System.err.printf("total[list3000,list3000,list3000]=%.0f   in %d millis\n", tot, t1 - t0);
        t0 = System.currentTimeMillis();
        tot = 0.0;
        it = new QubeDataSetIterator(rank3);
        QDataSet list30 = Ops.linspace(5.0, 34.0, 30);
        QDataSet list20 = Ops.linspace(5.0, 24.0, 20);
        it.setIndexIteratorFactory(0, new QubeDataSetIterator.SingletonIteratorFactory(30));
        it.setIndexIteratorFactory(1, new QubeDataSetIterator.IndexListIteratorFactory(list30));
        it.setIndexIteratorFactory(2, new QubeDataSetIterator.IndexListIteratorFactory(list20));
        while (it.hasNext()) {
            it.next();
            tot += it.getValue(rank3);
        }
        t1 = System.currentTimeMillis();
        System.err.printf("total[30,list30,list20]=%.0f   in %d millis\n", tot, t1 - t0);
        t0 = System.currentTimeMillis();
        tot = 0.0;
        QDataSet s = Ops.sort(rank1);
        IndexListDataSetIterator it2 = new IndexListDataSetIterator(s);
        while (it2.hasNext()) {
            it2.next();
            tot += it2.getValue(rank1);
        }
        t1 = System.currentTimeMillis();
        System.err.printf("total[rank1[s]]=%.0f   in %d millis\n", tot, t1 - t0);
        System.err.printf("total test time %d millis\n", t1 - t2);
    }
}

