/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.io.IOException;
import java.util.List;
import org.autoplot.ScriptContext;
import org.autoplot.dom.Application;
import org.autoplot.dom.ApplicationController;
import org.autoplot.dom.Axis;
import org.autoplot.dom.BindingModel;
import org.autoplot.dom.Plot;
import org.autoplot.dom.PlotElement;
import org.autoplot.layout.LayoutConstants;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.EnumerationUnits;
import org.das2.qds.DRank0DataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.system.DasLogger;

public class Test018 {
    static long t0 = System.currentTimeMillis();

    public static void xxx(String id) {
        System.err.println("-- timer -- " + id + " --: " + (System.currentTimeMillis() - t0));
        t0 = System.currentTimeMillis();
    }

    private static void test3(String testId) throws IOException, InterruptedException {
        System.err.println("=== test018 test3 ===");
        ScriptContext.reset();
        Application dom = ScriptContext.getDocumentModel();
        dom.getController().reset();
        dom.getDataSourceFilters(0).setUri("file:///home/jbf/ct/hudson/data.backup/qds/series/hyd_%Y%m%d.qds?timerange=2000-01-01 through 2000-01-12");
        ScriptContext.getApplicationModel().waitUntilIdle();
        Axis xaxis = dom.getPlots(0).getXaxis();
        ApplicationController controller = dom.getController();
        Plot domPlot = dom.getPlots(0);
        Plot that = dom.getController().copyPlotAndPlotElements(domPlot, null, false, false);
        controller.bind(domPlot.getZaxis(), "range", that.getZaxis(), "range");
        controller.bind(domPlot.getZaxis(), "log", that.getZaxis(), "log");
        controller.bind(domPlot.getZaxis(), "label", that.getZaxis(), "label");
        controller.addConnector(domPlot, that);
        that.getController().resetZoom(true, true, false);
        that.getZaxis().setRange(DatumRange.newDatumRange(10000.0, 1.0E8, that.getZaxis().getRange().getUnits()));
        xaxis.setRange(DatumRangeUtil.rescale(xaxis.getRange(), 0.2, 0.5));
        System.err.println("Before writeToPng:");
        System.err.println("xaxis.getRange()=" + xaxis.getRange());
        System.err.println("cacheImageValid=" + domPlot.getController().getDasPlot().isCacheImageValid());
        System.err.println("canvas isPendingChanges=" + domPlot.getController().getDasPlot().getCanvas().isPendingChanges());
        System.err.println("canvas isDirty=" + domPlot.getController().getDasPlot().getCanvas().isDirty());
        ScriptContext.writeToPng(testId + "_003.png");
        System.err.println("After writeToPng:");
        System.err.println("xaxis.getRange()=" + xaxis.getRange());
        System.err.println("cacheImageValid=" + domPlot.getController().getDasPlot().isCacheImageValid());
        System.err.println("canvas isPendingChanges=" + domPlot.getController().getDasPlot().getCanvas().isPendingChanges());
        System.err.println("canvas isDirty=" + domPlot.getController().getDasPlot().getCanvas().isDirty());
    }

    private static void test1(String testId) throws IOException, InterruptedException {
        System.err.println("=== test018 test1 ===");
        ScriptContext.reset();
        Application dom = ScriptContext.getDocumentModel();
        dom.getDataSourceFilters(0).setUri("file:///home/jbf/ct/hudson/data.backup/cdf/ac_k0_mfi_20080602_v01.cdf?BGSEc");
        dom.getPlots(0).getYaxis().setRange(new DatumRange(-10.0, 10.0, SemanticOps.lookupUnits("nT")));
        dom.getController().waitUntilIdle();
        ScriptContext.writeToPng(testId + "_000.png");
        dom.getController().copyPlotAndPlotElements(dom.getPlots(0), null, true, false);
        ScriptContext.writeToPng(testId + "_001.png");
        dom.getController().setPlot(dom.getPlots(1));
        List<Plot> plots = dom.getController().addPlots(1, 3, LayoutConstants.BELOW);
        for (int i = 0; i < plots.size(); ++i) {
            Plot pl = plots.get(i);
            PlotElement p = dom.getController().getPlotElementsFor(pl).get(0);
            p.setComponent(String.format("B%s GSE", Character.valueOf((char)(120 + i))));
            p.setDataSourceFilterId("data_0");
            pl.setTitle("");
            pl.getYaxis().setLabel(p.getComponent());
        }
        ScriptContext.writeToPng(testId + "_002.png");
    }

    public static void test4(String testId) throws IOException, InterruptedException {
        System.err.println("=== test018 test4 ===");
        ScriptContext.reset();
        ScriptContext.setCanvasSize(400, 300);
        System.err.println("+++++++++++++++++++++++++");
        ScriptContext.plot(0, "http://autoplot.org/data/autoplot.cdf?BGSM");
        ScriptContext.waitUntilIdle();
        ScriptContext.plot(0, "http://autoplot.org/data/autoplot.cdf?BGSEc");
        ScriptContext.waitUntilIdle();
        ScriptContext.writeToPng(testId + "_004a.png");
        System.err.println("+++++++++++++++++++++++++");
        ScriptContext.plot(0, "vap+cdfj:file:///home/jbf/ct/hudson/data.backup/cdf/lon/thb_l2_esa_20080907_v01.cdf?thb_peef_velocity_dsl");
        ScriptContext.waitUntilIdle();
        ScriptContext.plot(0, "vap+cdf:file:///home/jbf/ct/hudson/data.backup/cdf/lon/thb_l2_esa_20080907_v01.cdf?thb_peef_velocity_dsl");
        ScriptContext.waitUntilIdle();
        ScriptContext.writeToPng(testId + "_004.png");
        System.err.println("+++++++++++++++++++++++++");
    }

    public static void test5(String testId) throws InterruptedException, IOException {
        System.err.println("=== test018 test5 ===");
        ScriptContext.reset();
        Application dom = ScriptContext.getDocumentModel();
        ScriptContext.plot("vap+cdf:http://cdaweb.gsfc.nasa.gov/istp_public/data/polar/hydra/hyd_h0/$Y/po_h0_hyd_$Y$m$d_v01.cdf?ELECTRON_DIFFERENTIAL_ENERGY_FLUX&timerange=20000109");
        dom.getController().getPlot().getXaxis().setRange(dom.getController().getPlot().getXaxis().getRange().next());
        ScriptContext.plot(1, "vap+cdf:http://cdaweb.gsfc.nasa.gov/istp_public/data/polar/hydra/hyd_h0/$Y/po_h0_hyd_$Y$m$d_v01.cdf?ION_DIFFERENTIAL_ENERGY_FLUX&timerange=20000110");
        dom.getController().getPlot().getXaxis().setRange(dom.getController().getPlot().getXaxis().getRange().next());
        ScriptContext.writeToPng(testId + "_005.png");
    }

    public static void test6(String testId) throws Exception {
        System.err.println("=== test018 test6 ===");
        ScriptContext.reset();
        ScriptContext.plot("http://autoplot.org/vap/swpc.vap?timeRange=2012-04-07+through+2012-04-17");
        ScriptContext.waitUntilIdle();
        ScriptContext.plot(0, "vap+tsds:http://tsds.net/cgi-bin/get.cgi?StartDate=19910101&EndDate=20041231&ext=bin&out=tsml&ppd=24&filter=mean&param1=Augsburg_ULF-1-v1");
        ScriptContext.writeToPng(testId + "_006.png");
    }

    private static Plot docKludge(int position, String mes) throws InterruptedException {
        EnumerationUnits eu = new EnumerationUnits("default");
        Datum d = eu.createDatum(mes);
        DRank0DataSet ds = DataSetUtil.asDataSet(d);
        ScriptContext.plot(position, (QDataSet)ds);
        ScriptContext.waitUntilIdle();
        ApplicationController ac = ScriptContext.getDocumentModel().getController();
        Plot p = ac.getFirstPlotFor(ScriptContext.getDocumentModel().getDataSourceFilters(position));
        return p;
    }

    private static String bindStr(Application dom) {
        StringBuilder b = new StringBuilder();
        for (BindingModel bm : dom.getBindings()) {
            if (bm.toString().contains("colortable")) continue;
            b.append(bm.toString()).append("!c");
        }
        return b.toString();
    }

    public static void test7_bindings(String testId) throws Exception {
        Application dom = ScriptContext.getDocumentModel();
        System.err.println("=== test018 007_1 ========================");
        ScriptContext.reset();
        ScriptContext.plot("vap+cdaweb:ds=AC_H2_SWE&id=Np&timerange=1998-03-01");
        ScriptContext.waitUntilIdle();
        ScriptContext.plot(1, "vap+cdaweb:ds=AC_H2_SWE&id=Vp&timerange=1998-03-01");
        dom.setTimeRange(dom.getTimeRange().next());
        Test018.docKludge(2, "These should be bound!c" + Test018.bindStr(dom));
        System.err.println(Test018.bindStr(dom).replaceAll("!c", "\n"));
        ScriptContext.writeToPng(testId + "_007_1.png");
        System.err.println("=== test018 007_2 ========================");
        ScriptContext.reset();
        ScriptContext.plot("vap+cdaweb:ds=AC_H2_SWE&id=Np&timerange=1998-03-01");
        ScriptContext.waitUntilIdle();
        ScriptContext.plot(1, "vap+cdaweb:ds=AC_H2_SWE&id=Vp&timerange=1998-03-01");
        ScriptContext.plot("vap+cdaweb:ds=AC_H2_SWE&id=Np&timerange=1998-03-02");
        Test018.docKludge(2, "These should be bound!c" + Test018.bindStr(dom));
        System.err.println(Test018.bindStr(dom).replaceAll("!c", "\n"));
        ScriptContext.writeToPng(testId + "_007_2.png");
        System.err.println("=== test018 007_3 ========================");
        ScriptContext.reset();
        ScriptContext.plot("vap+cdaweb:ds=AC_H2_SWE&id=Np&timerange=1998-03-01");
        ScriptContext.waitUntilIdle();
        ScriptContext.plot(1, "vap+cdaweb:ds=AC_H2_SWE&id=Np&timerange=1999-04-05");
        Test018.docKludge(2, "These should not be bound!c" + Test018.bindStr(dom));
        System.err.println(Test018.bindStr(dom).replaceAll("!c", "\n"));
        ScriptContext.writeToPng(testId + "_007_3.png");
        System.err.println("=== test018 007_4 ========================");
        ScriptContext.reset();
        ScriptContext.plot("vap+cdaweb:ds=AC_H2_SWE&id=Np&timerange=1998-03-01");
        ScriptContext.waitUntilIdle();
        ScriptContext.plot(1, "vap+cdaweb:ds=AC_H2_SWE&id=Vp&timerange=1998-03-01");
        ScriptContext.plot("vap+cdaweb:ds=AC_H2_SWE&id=Np&timerange=1998-04-05");
        Test018.docKludge(2, "These should be bound!c" + Test018.bindStr(dom));
        System.err.println(Test018.bindStr(dom).replaceAll("!c", "\n"));
        ScriptContext.writeToPng(testId + "_007_4.png");
        System.err.println("==============================");
    }

    public static void main(String[] args) {
        boolean exit = true;
        DasLogger.setUpHandler("mini");
        try {
            if (!exit) {
                ScriptContext.createGui();
            }
            String testId = "test018";
            ScriptContext.getDocumentModel().getOptions().setAutolayout(false);
            Test018.test7_bindings(testId);
            ScriptContext.setCanvasSize(600, 600);
            ScriptContext.getDocumentModel().getOptions().setAutolayout(false);
            ScriptContext.getDocumentModel().getOptions().setCanvasFont("sans-8");
            ScriptContext.getDocumentModel().getCanvases(0).getMarginColumn().setRight("100%-10em");
            Test018.test1(testId);
            Test018.test3(testId);
            Test018.test4(testId);
            Test018.test5(testId);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        if (exit) {
            System.exit(0);
        }
    }
}

