/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.autoplot.ScriptContext;
import org.autoplot.jythonsupport.Util;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import test.endtoend.TestSupport;

public class Test017 {
    static long t0 = System.currentTimeMillis();
    static String[] uris = new String[]{"006 vap+das2server:http://www-wbd.physics.uiowa.edu/das/das2Server?dataset=das2_1/cluster/wbd/r_wbd&start_time=2007-04-17T08:40Z&end_time=2007-04-17T08:50Z&spacecraft=c1&mode=DSN&antenna=Any&frequencyOffset=Any&fftSize=1024", "007 vap+das2server:http://www-wbd.physics.uiowa.edu/das/das2Server?dataset=das2_1/cluster/wbd/r_wbd&start_time=2007-04-17T08:40Z&end_time=2007-04-17T08:50Z&spacecraft=c1&mode=DSN&antenna=Ey&frequencyOffset=Any&fftSize=1024", "008 http://cdaweb.gsfc.nasa.gov/istp_public/data/canopus/mari_mag/1994/cn_k0_mari_19940122_v01.cdf?Epoch", "009 http://cdaweb.gsfc.nasa.gov/istp_public/data/canopus/bars/%Y/cn_k0_bars_%Y%m%d_v...cdf?E_vel&timerange=1993-01-02+through+1993-01-14", "010 CC ftp://cdaweb.gsfc.nasa.gov/pub/data/imp/imp8/mag/mag_15sec_cdaweb/1973/i8_15sec_mag_19731030_v03.cdf", "012 http://cdaweb.gsfc.nasa.gov/istp_public/data/cluster/c2/pp/cis/2003/c2_pp_cis_20030104_v02.cdf?N_p__C2_PP_CIS", "014 ftp://cdaweb.gsfc.nasa.gov/pub/data/imp/imp8/mag/mag_15sec_cdaweb/2000/i8_15sec_mag_20000101_v03.cdf?F1_Average_B_15s", "015 ftp://cdaweb.gsfc.nasa.gov/pub/data/lanl/97_spa/2005/l7_k0_spa_20050405_v01.cdf?spa_p_dens", "016 ftp://cdaweb.gsfc.nasa.gov/pub/data/themis/tha/l2/fgm/2007/tha_l2_fgm_20070224_v01.cdf?tha_fgh_gse", "017 ftp://cdaweb.gsfc.nasa.gov/pub/data/geotail/orbit/def_or/1995/ge_or_def_19950101_v02.cdf?GSE_POS", "018 ftp://cdaweb.gsfc.nasa.gov/pub/data/geotail/mgf/mgf_k0/1998/ge_k0_mgf_19980102_v01.cdf?IB", "020 https://www.spacetelescope.org/static/projects/fits_liberator/datasets/m42/m42_40min_red.zip/m42_40min_red.fits", "021 vap+bin:ftp://ftp.nmh.ac.uk/wdc/obsdata/hourval/single_year/1909/clh1909.wdc", "023 vap+dat:http://wind.nasa.gov/swe_apbimax/wi_swe_fc_apbimax.1995005.txt?comment=;&column=21&timeFormat=$Y+$j&time=field0", "028 vap+dat:ftp://spdf.gsfc.nasa.gov/pub/data/omni/high_res_omni/monthly_1min/omni_min200101.asc?time=field0&column=field14&timeFormat=$Y+$j+$H+$M&validMax=9999", "029 http://wind.nasa.gov/swe_apbimax/wi_swe_fc_apbimax.2001017.txt?column=field2&comment=;&time=field0&timeFormat=$Y+$j", "030 http://vho.nasa.gov/mission/soho/celias_pm_30sec/1998.txt?time=YY&column=GSE_X&timeFormat=$y+$b+$d+$(ignore):$H:$M:$S", "031 ftp://nis-ftp.lanl.gov/pub/projects/genesis/3dmom/gim-3dl2-2002-01_v02.txt?skip=68&time=field0&timeFormat=$Y+$j+$H+$M+$S&column=field8&fill=-9999.0", "033 http://cdaweb.gsfc.nasa.gov/istp_public/data/omni/hro_5min/$Y/omni_hro_5min_$Y$m01_v$v.cdf?HR[::100]&timerange=1995+to+2000", "036 vap+dat:http://vmo.igpp.ucla.edu/data1/GOES/GOES10/SEM/$Y/A105$y$m.TXT?skip=23&timeFormat=$y$m$d+$H$M&column=E1&time=YYMMDD&fill=32700&timerange=Dec+2004", "037 CC ftp://ftp.nmh.ac.uk/wdc/obsdata/hourval/single_year/", "038 http://www-pw.physics.uiowa.edu/helios/data1/data/average/a7510-12.zip/av751229.dat?depend0=field0&rank2=1:", "040 http://www-pw.physics.uiowa.edu/helios/data1/data/average/a$y$m-...zip/av$y$m$d.dat?rank2=1:&time=field0&timerange=1975-oct", "041 file:///media/mini/data.backup/examples/xls/2008-lion%20and%20tiger%20summary.xls?sheet=Samantha+tiger+lp+lofreq&column=Elastic_Modulus&firstRow=53&depend0=Time", "042 file:///c:/documents and settings/Jeremy Faden/Desktop/Product Summary.xls?sheet=nist+lo&column=H", "044 file:///c:/documents%20and%20settings/Jeremy Faden/Desktop/Product%20Summary.xls?sheet=nist%20lo&column=H", "045 http://vmo.igpp.ucla.edu/data1/GOES/GOES10/SEM/2004/A1050402.TXT", "050 file:/home/jbf/ct/hudson/vap/cdaweb_ace.vap?timerange=2010-10-20+12:00+to+18:00", "051 file:/home/jbf/ct/hudson/vap/cdaweb_ace.vap?timerange=2010-10-20T12:00/2010-10-20T18:00", "052 file:/home/jbf/ct/hudson/vap/cdaweb_ace.vap?timerange=2010-10-20T12:00/PT6H", "100 file:///home/jbf/ct/hudson/data/csv/pw/2011_08_23T20.hrs_rec.coeff.csv?depend0=SCET&column=Pkt%20%26%20Src%20ID"};
    private static Set<String> usedIds = new HashSet<String>();

    public static void xxx(String id) {
        System.err.println("timer: in " + (System.currentTimeMillis() - t0) + "ms finished " + id);
        t0 = System.currentTimeMillis();
    }

    public static void main(String[] args) {
        try {
            ScriptContext.setCanvasSize(750, 300);
            ScriptContext.getDocumentModel().getOptions().setAutolayout(false);
            ScriptContext.getDocumentModel().getCanvases(0).getMarginColumn().setRight("100%-10em");
            ScriptContext.getDocumentModel().getCanvases(0).getMarginColumn().setLeft("5em");
            ScriptContext.getDocumentModel().getCanvases(0).getMarginRow().setTop("2em");
            ScriptContext.getDocumentModel().getCanvases(0).getMarginRow().setBottom("100%-2em");
            Test017.xxx("start");
            ThreadPoolExecutor exec = new ThreadPoolExecutor(12, 12, 3600L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
            for (String s : uris) {
                int count = Integer.parseInt(s.substring(0, 4).trim());
                s = s.substring(4);
                String label = String.format("test017_%03d", count);
                try {
                    if (s.startsWith("CC ")) {
                        String[] list = Util.listDirectory(s.substring(3));
                        PrintWriter out = new PrintWriter(label + ".txt");
                        for (String l : list) {
                            out.println(l);
                        }
                        out.close();
                    } else if (s.contains("file:/") && !s.contains("/home/jbf/ct/hudson")) {
                        System.err.println("skipping local " + s);
                    } else {
                        Test017.doTest(s, label, exec);
                    }
                }
                catch (Exception ex) {
                    PrintWriter pw = new PrintWriter(label + ".error");
                    pw.println(s);
                    pw.println("");
                    ex.printStackTrace(pw);
                    pw.close();
                    ex.printStackTrace();
                }
                Test017.xxx(label + ": " + s);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private static void doTest(String uri, String id, ThreadPoolExecutor exec) throws IOException, InterruptedException, Exception {
        System.err.printf("== %s ==\n", id);
        System.err.printf("uri: %s\n", uri);
        if (usedIds.contains(id)) {
            throw new IllegalArgumentException("id " + id + " used twice, test code needs attention");
        }
        usedIds.add(id);
        ResultRunnable run = new ResultRunnable(uri, id);
        int timeoutSeconds = 180;
        Future<String> f = null;
        while (true) {
            try {
                f = exec.submit(run, "Success!");
            }
            catch (RejectedExecutionException ex) {
                if (exec.isShutdown()) break;
                System.err.println("Thread pool is full. Retrying...");
                Thread.sleep(100L);
                continue;
            }
            break;
        }
        if (f != null && "Success!".equals(f.get(timeoutSeconds, TimeUnit.SECONDS))) {
            System.err.println(run.getResultMessage());
        } else {
            PrintWriter pw = new PrintWriter(id + ".error");
            pw.println(uri);
            pw.println("\ntimeout in " + timeoutSeconds + " seconds.");
            pw.close();
        }
    }

    private static class ResultRunnable
    implements Runnable {
        String uri;
        String id;
        String resultMessage;

        ResultRunnable(String uri, String id) {
            this.uri = uri;
            this.id = id;
            this.resultMessage = "";
        }

        @Override
        public void run() {
            try {
                QDataSet ds = Util.getDataSet(this.uri);
                MutablePropertyDataSet hist = (MutablePropertyDataSet)Ops.autoHistogram(ds);
                hist.putProperty("TITLE", this.uri);
                hist.putProperty("LABEL", this.id);
                ScriptContext.formatDataSet(hist, this.id + ".qds");
                QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
                if (dep0 != null) {
                    MutablePropertyDataSet hist2 = (MutablePropertyDataSet)Ops.autoHistogram(dep0);
                    ScriptContext.formatDataSet(hist2, this.id + ".dep0.qds");
                } else {
                    PrintWriter pw = new PrintWriter(this.id + ".dep0.qds");
                    pw.println("no dep0");
                    pw.close();
                }
                ScriptContext.plot(ds);
                ScriptContext.setCanvasSize(750, 300);
                int i = this.uri.lastIndexOf("/");
                ScriptContext.setTitle(this.uri.substring(i + 1));
                ScriptContext.writeToPng(this.id + ".png");
                this.resultMessage = "okay!";
            }
            catch (Exception ex) {
                TestSupport.logger.log(Level.SEVERE, ex.getMessage(), ex);
                this.resultMessage = "exception occurred.";
            }
        }

        public String getResultMessage() {
            return this.resultMessage;
        }
    }
}

