/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.ScriptContext;
import org.autoplot.jythonsupport.Util;
import org.das2.client.DataSetStreamHandler;
import org.das2.dataset.DataSet;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.qds.DDataSet;
import org.das2.qds.FDataSet;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.QubeDataSetIterator;
import org.das2.qds.WritableDataSet;
import org.das2.qds.ops.Ops;
import org.das2.qstream.QDataSetStreamHandler;
import org.das2.qstream.SimpleStreamFormatter;
import org.das2.qstream.StreamException;
import org.das2.qstream.StreamTool;
import org.das2.util.monitor.NullProgressMonitor;
import test.BundleBinsDemo;
import test.endtoend.TestSupport;

public class Test013 {
    static long t0 = System.currentTimeMillis();

    public static void xxx(String id) {
        System.err.println("-- timer -- " + id + " --: " + (System.currentTimeMillis() - t0));
        t0 = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void formatParse(QDataSet ds, String file) throws FileNotFoundException, IOException, StreamException {
        try (FileOutputStream out = null;){
            out = new FileOutputStream(file);
            SimpleStreamFormatter format = new SimpleStreamFormatter();
            System.err.println("attempt to format " + ds + " into " + file);
            format.format(ds, out, true);
        }
        try (FileInputStream in = null;){
            in = new FileInputStream(file);
            QDataSetStreamHandler handler = new QDataSetStreamHandler();
            System.err.println("attempt to parse " + file);
            StreamTool.readStream(Channels.newChannel(in), handler);
            QDataSet qds = handler.getDataSet();
            System.err.println("" + qds);
            ScriptContext.plot(qds);
            ScriptContext.writeToPng(file + ".png");
        }
    }

    private static QDataSet test1() throws ParseException, StreamException, IOException {
        QDataSet ds = Ops.timegen("2003-09-09", "1 " + Units.days, 11);
        Test013.formatParse(ds, "test013_test1.qds");
        return ds;
    }

    private static QDataSet test1_5() throws ParseException, StreamException, IOException {
        QDataSet ds = Ops.labels(new String[]{"B-GSM,X", "B-GSM,Y", "B-GSM,Z"});
        Test013.formatParse(ds, "test013_test1_5.qds");
        return ds;
    }

    private static QDataSet test2() throws ParseException, StreamException, IOException {
        MutablePropertyDataSet tags = (MutablePropertyDataSet)Ops.timegen("2003-09-09", "1 " + Units.days, 11);
        tags.putProperty("NAME", "time");
        MutablePropertyDataSet ds = (MutablePropertyDataSet)Ops.findgen(11, 3);
        ds.putProperty("DEPEND_0", tags);
        ds.putProperty("NAME", "B_GSM");
        MutablePropertyDataSet labels = (MutablePropertyDataSet)Ops.labels(new String[]{"B-GSM-X", "B-GSM-Y", "B-GSM-Z"});
        labels.putProperty("NAME", "dimLabels");
        ds.putProperty("DEPEND_1", labels);
        Test013.formatParse(ds, "test013_test2.qds");
        return ds;
    }

    private static QDataSet test3() throws ParseException, StreamException, IOException {
        MutablePropertyDataSet tags = (MutablePropertyDataSet)Ops.timegen("2003-09-09", "13.86 " + Units.seconds, 11);
        tags.putProperty("NAME", "time");
        MutablePropertyDataSet ds = (MutablePropertyDataSet)Ops.multiply(Ops.pow(Ops.replicate(100000.0, 11, 3), Ops.randomu(12345L, 11, 3)), Ops.randomu(12345L, 11, 3));
        ds.putProperty("DEPEND_0", tags);
        ds.putProperty("NAME", "B_GSM");
        MutablePropertyDataSet mode = (MutablePropertyDataSet)Ops.floor(Ops.multiply(Ops.randomu(12345L, 11), Ops.replicate(4L, 11)));
        EnumerationUnits u = new EnumerationUnits("quality");
        u.createDatum(0, "Good");
        u.createDatum(1, "Better");
        u.createDatum(2, "Best");
        u.createDatum(3, "Perfect");
        mode.putProperty("UNITS", u);
        mode.putProperty("DEPEND_0", tags);
        mode.putProperty("NAME", "quality");
        ds.putProperty("DEPEND_0", tags);
        ds.putProperty("NAME", "B_GSM");
        MutablePropertyDataSet labels = (MutablePropertyDataSet)Ops.labels(new String[]{"B-GSM-X", "B-GSM-Y", "B-GSM-Z"});
        labels.putProperty("NAME", "dimLabels");
        ds.putProperty("DEPEND_1", labels);
        ds.putProperty("PLANE_0", mode);
        Test013.formatParse(ds, "test013_test3.qds");
        return ds;
    }

    private static QDataSet test4_rank3() throws ParseException, StreamException, IOException {
        DDataSet ds = (DDataSet)Ops.dindgen(3, 4, 5);
        ds.putValue(1, 2, 3, 0.05);
        Test013.formatParse(ds, "test013_test4_rank3.qds");
        return ds;
    }

    private static QDataSet test0_rank2() throws ParseException, StreamException, IOException {
        DDataSet ds = (DDataSet)Ops.dindgen(3, 4);
        String file = "test013_test0_rank2.qds";
        Test013.formatParse(ds, file);
        return ds;
    }

    private static QDataSet test5() throws StreamException, IOException {
        DDataSet ds = (DDataSet)Ops.dindgen(5);
        String file = "test013_test5.qds";
        Test013.formatParse(ds, file);
        return ds;
    }

    private static QDataSet test6() throws StreamException, IOException {
        QDataSet result = null;
        result = Ops.join(result, Ops.dindgen(5));
        result = Ops.join(result, Ops.dindgen(5));
        result = Ops.join(result, Ops.dindgen(5));
        result = Ops.join(result, Ops.dindgen(4));
        result = Ops.join(result, Ops.dindgen(4));
        result = Ops.join(result, Ops.dindgen(4));
        result = Ops.join(result, Ops.dindgen(4));
        Test013.formatParse(result, "test013_test6.qds");
        return result;
    }

    private static void test8() throws ParseException, IOException, StreamException {
        MutablePropertyDataSet dsBundle = (MutablePropertyDataSet)Ops.labels(new String[]{"X", "Y", "Z"});
        int seed = 1234;
        int len0 = 34;
        MutablePropertyDataSet ds1 = (MutablePropertyDataSet)Ops.add(Ops.randomn(seed, 34, 3), Ops.outerProduct(Ops.replicate(30L, 34), Ops.ones(3)));
        QDataSet ds0 = Ops.timegen("2000-01-01T10:00", "1s", 34);
        ds1.putProperty("DEPEND_0", ds0);
        ds1.putProperty("DEPEND_1", dsBundle);
        int len1 = 44;
        MutablePropertyDataSet ds2 = (MutablePropertyDataSet)Ops.add(Ops.randomn(seed, 44, 3), Ops.outerProduct(Ops.replicate(35L, 44), Ops.ones(3)));
        ds0 = Ops.timegen("2000-01-01T11:00", "1s", 44);
        ds2.putProperty("DEPEND_0", ds0);
        ds2.putProperty("DEPEND_1", dsBundle);
        int len2 = 54;
        MutablePropertyDataSet ds3 = (MutablePropertyDataSet)Ops.add(Ops.randomn(seed, 54, 3), Ops.outerProduct(Ops.replicate(40L, 54), Ops.ones(3)));
        ds0 = Ops.timegen("2000-01-01T12:00", "1s", 54);
        ds3.putProperty("DEPEND_0", ds0);
        ds3.putProperty("DEPEND_1", dsBundle);
        MutablePropertyDataSet ds = (MutablePropertyDataSet)Ops.join(Ops.join(ds1, ds2), ds3);
        Test013.formatParse(ds, "test013_test8.qds");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static QDataSet test7() throws StreamException, IOException {
        int nrec = 190000;
        long lt0 = System.currentTimeMillis();
        FDataSet result = FDataSet.createRank1(nrec);
        Test013.funData(result, 9.2, 0.01, 0, false);
        DDataSet dep0 = DDataSet.createRank1(nrec);
        Test013.funData(dep0, 10000.0, 0.01, 0, true);
        result.putProperty("DEPEND_0", dep0);
        Random rand = new Random(12345L);
        for (int i = 0; i < 13; ++i) {
            FDataSet planeds = FDataSet.createRank1(nrec);
            Test013.funData(planeds, rand.nextDouble() * 100.0, rand.nextDouble() * 10.0, 0, false);
            planeds.putProperty("NAME", "myplane_" + i);
            result.putProperty("PLANE_" + i, planeds);
        }
        System.err.println("generated data in  " + (System.currentTimeMillis() - lt0));
        lt0 = System.currentTimeMillis();
        System.err.println("formatting... ");
        try (FileOutputStream out = null;){
            out = new FileOutputStream("test013_test7.qds");
            SimpleStreamFormatter format = new SimpleStreamFormatter();
            format.format(result, out, false);
            System.err.println("time: " + (System.currentTimeMillis() - lt0));
        }
        return result;
    }

    private static void testBundle() throws StreamException, FileNotFoundException, IOException {
        QDataSet ds = BundleBinsDemo.demo1();
        Test013.formatParse(ds, "test013_testBundle.qds");
    }

    private static void funData(WritableDataSet ds, double start, double res, int seed, boolean mono) {
        Random rand = new Random(seed);
        if (!mono) {
            QubeDataSetIterator it = new QubeDataSetIterator(ds);
            while (it.hasNext()) {
                it.next();
                it.putValue(ds, start);
                start += res * (rand.nextDouble() - 0.5);
            }
        } else {
            QubeDataSetIterator it = new QubeDataSetIterator(ds);
            while (it.hasNext()) {
                it.next();
                it.putValue(ds, start);
                start += res;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void formatBenchmark() throws ParseException, IOException, StreamException {
        int nrec = 100000;
        MutablePropertyDataSet tags = (MutablePropertyDataSet)Ops.timegen("2003-09-09", "1 " + Units.days, nrec);
        tags.putProperty("NAME", "time");
        MutablePropertyDataSet ds = (MutablePropertyDataSet)Ops.randomn(12345L, nrec, 3);
        ds.putProperty("DEPEND_0", tags);
        ds.putProperty("NAME", "B_GSM");
        MutablePropertyDataSet labels = (MutablePropertyDataSet)Ops.findgen(3);
        labels.putProperty("NAME", "dimLabels");
        ds.putProperty("DEPEND_1", labels);
        for (int j = 0; j < 2; ++j) {
            boolean ascii = j == 0;
            SimpleStreamFormatter format = new SimpleStreamFormatter();
            for (int i = 0; i < 3; ++i) {
                long lt0 = System.currentTimeMillis();
                String filename = ascii ? "test013_benchmark1.qds" : "test013_benchmark1.binary.qds";
                try (FileOutputStream fo = null;){
                    fo = new FileOutputStream(filename);
                    format.format(ds, fo, ascii);
                }
                System.err.println("Time to write " + nrec + " records: " + (System.currentTimeMillis() - lt0));
            }
        }
    }

    public static void parseBenchmark() throws FileNotFoundException, StreamException, org.das2.stream.StreamException {
        Test013.readAsciiQds();
        Test013.readBinaryQds();
    }

    private static void readStream(File f) throws FileNotFoundException, StreamException, org.das2.stream.StreamException {
        String ext = f.toString().substring(f.toString().lastIndexOf("."));
        if (ext.equals(".qds")) {
            long lt0 = System.currentTimeMillis();
            FileInputStream in = new FileInputStream(f);
            QDataSetStreamHandler handler = new QDataSetStreamHandler();
            StreamTool.readStream(Channels.newChannel(in), handler);
            QDataSet qds = handler.getDataSet();
            System.err.println("Time to read " + qds.length() + " records: " + (System.currentTimeMillis() - lt0));
        } else {
            long lt0 = System.currentTimeMillis();
            FileInputStream in = new FileInputStream(f);
            DataSetStreamHandler handler = new DataSetStreamHandler(new HashMap(), new NullProgressMonitor());
            org.das2.stream.StreamTool.readStream(Channels.newChannel(in), handler);
            DataSet ds = handler.getDataSet();
            System.err.println("Time to read " + ds.getXLength() + " records: " + (System.currentTimeMillis() - lt0));
        }
    }

    private static void readAsciiQds() throws FileNotFoundException, StreamException, org.das2.stream.StreamException {
        File f = new File("test013_benchmark1.qds");
        for (int i = 0; i < 5; ++i) {
            Test013.readStream(f);
        }
    }

    private static void readBinaryQds() throws FileNotFoundException, StreamException, org.das2.stream.StreamException {
        File f = new File("test013_benchmark1.binary.qds");
        for (int i = 0; i < 5; ++i) {
            Test013.readStream(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeLimitPrecision() throws StreamException, IOException {
        QDataSetStreamHandler handler = new QDataSetStreamHandler();
        StreamTool.readStream(Channels.newChannel(new FileInputStream("/home/jbf/ct/hudson/data.backup/qds/too_many_decimals.qds")), handler);
        File f = new File("test013_writeLimitPrecision.qds");
        QDataSet ds = handler.getDataSet("means");
        SimpleStreamFormatter format = new SimpleStreamFormatter();
        try (FileOutputStream out = null;){
            out = new FileOutputStream(f);
            format.format(ds, out, true);
        }
    }

    private static void testException() {
        block5: {
            try {
                PrintStream fout = new PrintStream("test013_exception.qds");
                fout.println("[00]000067<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                fout.println("<stream dataset_id=\"ds_0\"/>");
                fout.println("[xx]000144<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                fout.println("<exception type=\"NoDataInInterval\" message=\"No data found in interval.  Last data found at 2012-02-01\"/>");
                fout.close();
                FileInputStream in = new FileInputStream("test013_exception.qds");
                ReadableByteChannel rin = Channels.newChannel(in);
                QDataSetStreamHandler h = new QDataSetStreamHandler();
                try {
                    StreamTool.readStream(rin, h);
                }
                catch (StreamException ex) {
                    if (ex.getCause() != null && ex.getCause() instanceof NoDataInIntervalException) {
                        System.err.println(ex.getCause().getMessage());
                        break block5;
                    }
                    ex.printStackTrace();
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static void testRank2Spectrogram() {
        try {
            SimpleStreamFormatter ssf = new SimpleStreamFormatter();
            QDataSet ds = Util.getDataSet("vap+inline:ripples(5,4)&DEPEND_1=pow(10,linspace(1,3,4))&DEPEND_0=timegen('2013-04-04T00:00','60 sec',5)");
            File f = new File("test013_spectrogram.qds");
            try (FileOutputStream out = new FileOutputStream(f);){
                ssf.format(ds, out, true);
            }
            Test013.readStream(f);
        }
        catch (Exception ex) {
            Logger.getLogger(Test013.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) {
        try {
            Test013.test2();
            Test013.xxx("test2");
            Test013.testException();
            Test013.testRank2Spectrogram();
            Test013.test8();
            Test013.test6();
            Test013.xxx("init");
            Test013.writeLimitPrecision();
            Test013.xxx("writeLimitPrecision");
            Test013.test0_rank2();
            Test013.xxx("test0_rank2()");
            Test013.test1();
            Test013.xxx("test1");
            Test013.test1_5();
            Test013.xxx("test1_5");
            Test013.test3();
            Test013.xxx("test3");
            Test013.test4_rank3();
            Test013.xxx("test4_rank3");
            Test013.test5();
            Test013.xxx("test5");
            Test013.test6();
            Test013.xxx("test6 disabled until bug is resolved");
            Test013.test7();
            Test013.xxx("test7");
            Test013.testBundle();
            Test013.xxx("testBundle");
            Test013.formatBenchmark();
            Test013.xxx("formatBenchmark");
            Test013.parseBenchmark();
            Test013.xxx("parseBenchmark");
            MutablePropertyDataSet ds = TestSupport.sampleDataRank2(100000, 30);
            ds.putProperty("DEPEND_0", Ops.timegen("2009-08-25T10:00", "13.6 ms", 100000));
            ds.putProperty("DEPEND_1", Ops.exp10(Ops.linspace(1.01, 3.4, 30)));
            Test013.xxx("created fake rank2");
            ScriptContext.formatDataSet(ds, "test013_001.qds?type=binary");
            Test013.xxx("test013_001.qds");
            ScriptContext.formatDataSet(ds, "test013_002.qds");
            Test013.xxx("test013_002.qds");
            System.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }
}

