/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.io.PrintWriter;
import org.autoplot.ScriptContext;
import org.autoplot.jythonsupport.Util;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;

public class Test012 {
    private static int testid;

    public static void doTest(int testid, int id, String uri) throws Exception {
        long t0 = System.currentTimeMillis();
        System.err.printf(String.format("== %03d %s ==\n", id, uri), new Object[0]);
        QDataSet ds = Util.getDataSet(uri);
        double t = (double)(System.currentTimeMillis() - t0) / 1000.0;
        MutablePropertyDataSet hist = (MutablePropertyDataSet)Ops.autoHistogram(ds);
        hist.putProperty("TITLE", uri);
        String label = String.format("test%03d_%03d", testid, id);
        hist.putProperty("LABEL", label);
        ScriptContext.formatDataSet(hist, label + ".qds");
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 != null) {
            if (Ops.total(Ops.valid(dep0)) == 0.0) {
                Ops.total(Ops.valid(dep0));
                throw new IllegalArgumentException("no valid DEPEND_0");
            }
            MutablePropertyDataSet hist2 = (MutablePropertyDataSet)Ops.autoHistogram(dep0);
            ScriptContext.formatDataSet(hist2, label + ".dep0.qds");
        } else {
            PrintWriter pw = new PrintWriter(label + ".dep0.qds");
            pw.println("no dep0");
            pw.close();
        }
        ScriptContext.plot(ds);
        ScriptContext.setCanvasSize(750, 300);
        int i = uri.lastIndexOf("/");
        ScriptContext.getApplicationModel().waitUntilIdle();
        String fileUri = uri.substring(i + 1);
        if (!ScriptContext.getDocumentModel().getPlotElements(0).getComponent().equals("")) {
            String dsstr = String.valueOf(ScriptContext.getDocumentModel().getDataSourceFilters(0).getController().getDataSet());
            fileUri = fileUri + " " + dsstr + " " + ScriptContext.getDocumentModel().getPlotElements(0).getComponent();
        }
        ScriptContext.setTitle(fileUri);
        ScriptContext.writeToPng(String.format("test%03d_%03d.png", testid, id));
        System.err.printf("Read in %9.3f seconds (%s): %s\n", t, label, uri);
    }

    public static void main(String[] args) {
        try {
            ScriptContext.getDocumentModel().getOptions().setAutolayout(false);
            ScriptContext.getDocumentModel().getCanvases(0).getMarginColumn().setRight("100%-10em");
            testid = args.length == 1 ? Integer.parseInt(args[0]) : 12;
            Test012.doTest(testid, 0, "vap:file:///home/jbf/ct/hudson/data.backup/cdf/c4_cp_fgm_spin_20030102_v01.cdf?B_vec_xyz_gse__C4_CP_FGM_SPIN");
            Test012.doTest(testid, 1, "vap:file:///home/jbf/ct/hudson/data.backup/cdf/tha_l1_efw_20080402_v01.cdf?tha_efw");
            Test012.doTest(testid, 2, "vap:file:///home/jbf/ct/hudson/data.backup/cdf/l1_h0_mpa_20020202_v02.cdf?dens_e");
            Test012.doTest(testid, 3, "vap:file:///home/jbf/ct/hudson/data.backup/cdf/l1_h0_mpa_20020202_v02.cdf?Theta_l");
            Test012.doTest(testid, 4, "vap:file:///home/jbf/ct/hudson/data.backup/cdf/l1_h0_mpa_20020202_v02.cdf?Ecounts[1]");
            Test012.doTest(testid, 5, "vap:file:///home/jbf/ct/hudson/data.backup/cdf/c2_waveform_wbd_200704170840_u01.cdf?WBD_Elec[1000000:1100000]");
            Test012.doTest(testid, 6, "vap:file:///home/jbf/ct/hudson/data.backup/cdf/c2_waveform_wbd_200704170840_u01.cdf?DATA_QUALITY[::1090]");
            Test012.doTest(testid, 7, "vap:file:///home/jbf/ct/hudson/data.backup/cdf/i8_15sec_mag_19731030_v02.cdf?F1_Average_B_15s");
            Test012.doTest(testid, 8, "vap:file:///home/jbf/ct/hudson/data.backup/cdf/i8_15sec_mag_19731030_v02.cdf?B_Vector_GSM");
            Test012.doTest(testid, 9, "vap:file:///home/jbf/ct/hudson/data.backup/cdf/wi_h0_mfi_19941123_v04.cdf?P1GSM");
            Test012.doTest(testid, 10, "vap:file:///home/jbf/ct/hudson/data.backup/cdf/wi_h0_mfi_19941123_v04.cdf?ORTH_I");
            Test012.doTest(testid, 11, "vap:file:///home/jbf/ct/hudson/data.backup/cdf/po_h0_hyd_20010117_v01.cdf?ION_DIFFERENTIAL_ENERGY_FLUX");
            Test012.doTest(testid, 12, "vap:file:///home/jbf/ct/hudson/data.backup/cdf/po_h0_tim_19960409_v03.cdf?Flux_H");
            Test012.doTest(testid, 13, "vap:file:///home/jbf/ct/hudson/data.backup/cdf/tha_l1_fgm_20100101_v01.cdf?tha_fgh[0:10000]");
            Test012.doTest(testid, 14, "vap:file:///home/jbf/ct/hudson/data.backup/cdf/twins/twins1_l1_imager_2009011102_v01.cdf?smooth_image&interpMeta=no");
            Test012.doTest(testid, 15, "vap:file:///home/jbf/ct/hudson/data.backup/cdf/fa_k0_ees_19980111_v01.cdf?el_0");
            Test012.doTest(testid, 16, "vap:file:///home/jbf/ct/hudson/data.backup/cdf/tha_l1_ffp_32_20090101_v01.cdf?tha_ffp_32");
            Test012.doTest(testid, 17, "file:///home/jbf/ct/hudson/data.backup/cdf/virbo/poes_n17_20041228.cdf?P1_90[0:300]");
            Test012.doTest(testid, 18, "file:///home/jbf/ct/hudson/data.backup/cdf/cn_k0_asi_19991230_v01.cdf?Image");
            Test012.doTest(testid, 19, "file:///home/jbf/ct/hudson/data.backup/cdf/pw/rbsp/rbsp-a_magnetometer_emfisis-L1_20120904_v1.2.2.cdf?Mag_UVW[0:100000]");
            Test012.doTest(testid, 20, "file:///home/jbf/ct/hudson/data.backup/cdf/pw/rbsp/rbsp-a_magnetometer_emfisis-L1_20120904_v1.2.2.cdf?Mag_UVW");
            Test012.doTest(testid, 21, "file:///home/jbf/ct/hudson/data.backup/cdf/ge_k0_lep_20111016_v01.cdf?V0");
            Test012.doTest(testid, 22, "file:///home/jbf/ct/hudson/data.backup/cdf/rbspb_pre_ect-mageisHIGH-sp-L1_20130709_v1.0.0.cdf?Histogram_prot");
            Test012.doTest(testid, 23, "file:///home/jbf/ct/hudson/data.backup/cdf/lanl/rbspb_ect-hope-sci-L2SA_20121219_v3.0.0.cdf?FPSA[0:100:5]");
            Test012.doTest(testid, 24, "file:///home/jbf/ct/hudson/data.backup/cdf/rbsp/rbsp-a_HFR-spectra-burst_emfisis-L2_20140121_v1.3.6.cdf?HFR_Spectra[0:100]");
            Test012.doTest(testid, 25, "http://cdaweb.gsfc.nasa.gov/istp_public/data/themis/thc/l2/esa/2015/thc_l2_esa_20151214_v01.cdf?thc_peif_velocity_dslQ&slice1=0");
            System.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }
}

