/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.io.PrintWriter;
import org.autoplot.ScriptContext;
import org.autoplot.jythonsupport.Util;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;

public class Test006 {
    public static Exception doTest(int id, String uri, Exception ex) throws Exception {
        block4: {
            try {
                long t0 = System.currentTimeMillis();
                QDataSet ds = Util.getDataSet(uri);
                double t = (double)(System.currentTimeMillis() - t0) / 1000.0;
                MutablePropertyDataSet hist = (MutablePropertyDataSet)Ops.autoHistogram(ds);
                hist.putProperty("TITLE", uri);
                String label = String.format("test006_%03d", id);
                hist.putProperty("LABEL", label);
                ScriptContext.formatDataSet(hist, label + ".qds");
                QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
                if (dep0 != null) {
                    MutablePropertyDataSet hist2 = (MutablePropertyDataSet)Ops.autoHistogram(dep0);
                    ScriptContext.formatDataSet(hist2, label + ".dep0.qds");
                } else {
                    PrintWriter pw = new PrintWriter(label + ".dep0.qds");
                    pw.println("no dep0");
                    pw.close();
                }
                System.err.printf("Read in %9.3f seconds (%s): %s\n", t, label, uri);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (ex == null) break block4;
                ex = e;
            }
        }
        return ex;
    }

    public static void main(String[] args) {
        try {
            Exception e = null;
            e = Test006.doTest(0, "ftp://spdf.gsfc.nasa.gov/pub/data/omni/low_res_omni/omni2_$Y.dat?column=field17&timerange=1963&timeFormat=$Y+$j+$H&time=field0&validMax=999", e);
            e = Test006.doTest(1, "vap+dat:file:///home/jbf/ct/hudson/data.backup/dat/A1050412.TXT?skip=23&timeFormat=$y$m$d+$H$M&column=E1&time=YYMMDD", e);
            e = Test006.doTest(2, "vap+dat:file:///home/jbf/ct/hudson/data.backup/dat/V11979066.CSV?depend0=field0&column=field13", e);
            e = Test006.doTest(3, "file:///home/jbf/ct/hudson/data.backup/dat/power.dat.txt", e);
            e = Test006.doTest(4, "vap+csv:file:///home/jbf/ct/hudson/data.backup/dat/V11979066.CSV?depend0=field0&column=field13", e);
            if (e != null) {
                throw e;
            }
            System.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }
}

