/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import org.autoplot.ScriptContext;
import org.autoplot.datasource.DataSetURI;
import org.das2.datum.DatumRangeUtil;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.KeyChain;
import org.das2.util.filesystem.WebFileSystem;
import org.das2.util.monitor.CancelledOperationException;
import test.endtoend.TestSupport;

public class Test003 {
    public static void doit(int id, String uri) {
        try {
            System.err.println(String.format("== %03d == ", id));
            long t0 = System.currentTimeMillis();
            System.err.println("uri: " + uri);
            ScriptContext.load(uri);
            ScriptContext.writeToPng("test003_" + String.format("%03d", id) + ".png");
            System.err.println(String.format("test003_%03d read in %.2f sec", id, (double)(System.currentTimeMillis() - t0) / 1000.0));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        block9: {
            boolean headless = true;
            boolean loginBeforeTest = false;
            if (loginBeforeTest) {
                try {
                    DataSetURI.getExplicitExt("foo.dat");
                    KeyChain.getDefault().getUserInfo(new URL("http://ectsoc@www.rbsp-ect.lanl.gov/"));
                    KeyChain.getDefault().getUserInfo(new URL("http://ectrept@www.rbsp-ect.lanl.gov/"));
                    KeyChain.getDefault().getUserInfo(new URL("http://www.rbsp-ect.lanl.gov/"));
                    KeyChain.getDefault().getUserInfo(new URL("http://ectmageis@www.rbsp-ect.lanl.gov/"));
                    KeyChain.getDefault().getUserInfo(new URL("http://ecthope@www.rbsp-ect.lanl.gov/"));
                }
                catch (CancelledOperationException ex) {
                    TestSupport.logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
                catch (MalformedURLException ex) {
                    TestSupport.logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
            try {
                FileSystem[] fss;
                if (!headless) {
                    ScriptContext.createGui();
                }
                ScriptContext.getDocumentModel().getOptions().setAutolayout(false);
                ScriptContext.getDocumentModel().getCanvases(0).getMarginColumn().setRight("100%-10em");
                Test003.doit(26, "http://www.rbsp-ect.lanl.gov/data_pub/autoplot/scripts//rbsp_ect-rept-lvt.jyds?timerange=2012-10-15");
                Test003.doit(27, "http://www.rbsp-ect.lanl.gov/data_pub/autoplot/scripts/rbsp_ect-mageis-lvt.jyds");
                Test003.doit(28, "http://www.rbsp-ect.lanl.gov/data_pub/autoplot/scripts/rbsp_ephem.jyds?R=T&L=T&MLT=T&ILT=T");
                Test003.doit(9, "http://ectsoc@www.rbsp-ect.lanl.gov/data_prot/rbspa/mageis/level1/plots/dr-elec-L1/rbspa_rel01_ect-mageis-dr-elec-L1.vap");
                Test003.doit(10, "http://ectsoc@www.rbsp-ect.lanl.gov/data_prot/rbspa/mageis/level1/plots/mr-elec-L1/rbspa_rel01_ect-mageis-mr-elec-L1.vap");
                Test003.doit(12, "file:///home/jbf/ct/lanl/rbsp/fixvaps20130423/rbspa_pre_ect-mageis-sci-elec-L2.vap");
                Test003.doit(16, "file:///home/jbf/ct/hudson/vap/lanl/rbspa_pre_ect-hope-sci-L2.vap");
                Test003.doit(19, "file:///home/jbf/ct/hudson/vap/lanl/rbspa_rel01_ect-rept-hk-bias-L1.vap?timerange=20121202");
                Test003.doit(20, "http://ectsoc@www.rbsp-ect.lanl.gov/data_prot/rbspa/rept/level1/plots/hk-fc-L1/rbspa_rel01_ect-rept-hk-fc-L1.vap?timerange=20120918");
                Test003.doit(21, "http://ectsoc@www.rbsp-ect.lanl.gov/data_prot/rbspa/rept/level1/plots/hk-tvc-L1/rbspa_rel01_ect-rept-hk-tvc-L1.vap?timerange=20120919");
                Test003.doit(22, "http://ectsoc@www.rbsp-ect.lanl.gov/data_prot/rbspa/rept/level1/plots/sci-all-L1/rbspa_rel01_ect-rept-sci-all-L1.vap?timerange=20121004");
                Test003.doit(24, "file:///home/jbf/ct/lanl/rbsp/fixvaps20130423/rbspa_pre_ect-rept-sci-elec-L2.vap");
                Test003.doit(25, "file:///home/jbf/ct/lanl/rbsp/fixvaps20130423/rbspa_pre_ect-rept-sci-ion-L2.vap");
                ScriptContext.getDocumentModel().getCanvases(0).setFitted(false);
                ScriptContext.setCanvasSize(800, 600);
                ScriptContext.load("file:///home/jbf/ct/hudson/vap/geo_pitch_stack_test1_local_1.vap");
                ScriptContext.setCanvasSize(800, 600);
                ScriptContext.writeToPng("test003_001.png");
                ScriptContext.reset();
                ScriptContext.load("file:///home/jbf/ct/hudson/vap/contextOverview2_v1.03a.vap");
                ScriptContext.setCanvasSize(800, 600);
                ScriptContext.writeToPng("test003_002.png");
                ScriptContext.reset();
                ScriptContext.load("file:///home/jbf/ct/hudson/vap/lanl_97A_sopa_panel_slices_3_v1.03a.vap");
                ScriptContext.setCanvasSize(800, 600);
                ScriptContext.writeToPng("test003_003.png");
                ScriptContext.reset();
                ScriptContext.load("file:///home/jbf/ct/hudson/vap/energyCompareHydra.vap");
                ScriptContext.writeToPng("test003_004.png");
                ScriptContext.getDocumentModel().getPlots(0).getXaxis().setRange(DatumRangeUtil.parseTimeRangeValid("2000-01-09 10:00 to 12:00"));
                ScriptContext.writeToPng("test003_004a.png");
                ScriptContext.reset();
                ScriptContext.load("file:///home/jbf/ct/hudson/vap/lanl/cpaRichHeaders.vap");
                ScriptContext.writeToPng("test003_006.png");
                ScriptContext.reset();
                ScriptContext.load("http://cdaweb.gsfc.nasa.gov/istp_public/data/crres/particle_mea/mea_h0_cdaweb/$Y/crres_h0_mea_$Y$m$(d,span=10)_v01.cdf?B&timerange=1991-01-15");
                ScriptContext.writeToPng("test003_008.png");
                System.err.println("Local Cache Dir: " + FileSystem.settings().getLocalCacheDir());
                for (FileSystem fs : fss = FileSystem.peekInstances()) {
                    if (!(fs instanceof WebFileSystem)) continue;
                    System.err.println(fs.toString() + ":\t" + (((WebFileSystem)fs).isOffline() ? "offline" : "ok"));
                }
                if (headless) {
                    System.exit(0);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (!headless) break block9;
                System.exit(1);
            }
        }
    }
}

