/*
 * Decompiled with CFR 0.152.
 */
package test.components;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.das2.components.TearoffTabbedPane;

public class TearoffTabbedPaneDemo {
    private static JPanel getPanel(final TearoffTabbedPane pane, final int index) {
        JPanel panel = new JPanel();
        panel.setName("tab" + index);
        panel.setLayout(new BoxLayout(panel, 1));
        JLabel label = new JLabel(" --" + index + "--");
        label.setFont(Font.decode("HELVETICA").deriveFont(1, 40.0f));
        panel.add(label);
        JLabel sublabel = new JLabel("name=" + panel.getName() + " hash=" + panel.hashCode());
        sublabel.setFont(Font.decode("HELVETICA").deriveFont(2, 8.0f));
        panel.add(sublabel);
        JButton action = new JButton(new AbstractAction("Remove Second Tab"){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.err.println("Button " + index);
                if (pane.getTabCount() > 1) {
                    pane.removeTabAt(1);
                    if (pane.getTabCount() == 1) {
                        ((JButton)e.getSource()).setEnabled(false);
                    }
                } else {
                    ((JButton)e.getSource()).setEnabled(false);
                }
            }
        });
        panel.add(action);
        JButton peek = new JButton(new AbstractAction("Peek (see stderr)"){

            @Override
            public void actionPerformed(ActionEvent e) {
                pane.peek();
            }
        });
        panel.add(peek);
        panel.setMinimumSize(new Dimension(400, 300));
        panel.setPreferredSize(panel.getMinimumSize());
        return panel;
    }

    public static void main(String[] args) {
        Logger.getLogger("das2.gui").setLevel(Level.FINE);
        ConsoleHandler h = new ConsoleHandler();
        h.setLevel(Level.ALL);
        Logger.getLogger("das2.gui").addHandler(h);
        TearoffTabbedPane pane = new TearoffTabbedPane();
        pane.addTab("firstTab", TearoffTabbedPaneDemo.getPanel(pane, 1));
        pane.addTab("secondTab", TearoffTabbedPaneDemo.getPanel(pane, 2));
        pane.addTab("thirdTab", TearoffTabbedPaneDemo.getPanel(pane, 3));
        pane.addTab("fourthTab", TearoffTabbedPaneDemo.getPanel(pane, 4));
        JFrame frame = new JFrame();
        frame.setName("MainFrame");
        frame.getContentPane().add(pane);
        frame.setTitle("MainFrame");
        pane.setPreferredSize(new Dimension(600, 400));
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }
}

