/*
 * Decompiled with CFR 0.152.
 */
package org.tsds.datasource;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.das2.datum.LoggerManager;
import org.das2.datum.Units;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.TagGenDataSet;
import org.das2.qds.buffer.BufferDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TsmlNcml {
    private static final int RANK_LIMIT = 2;
    URL codebase = null;
    private static final Logger logger = LoggerManager.getLogger("apdss.tsds");

    public static void main(String[] args) throws Exception {
        new TsmlNcml().doRead(new URL("http://timeseries.org/cgi-bin/get.cgi?StartDate=19890104&EndDate=19890104&ext=bin&out=ncml&ppd=8&filter=4&param1=SourceAcronym_Subset1-1-v0"), null);
    }

    public QDataSet doRead(URL url, URLConnection connect) throws IOException, ParserConfigurationException, SAXException {
        this.codebase = url;
        InputStream in = connect != null ? connect.getInputStream() : url.openStream();
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        InputSource source = new InputSource(in);
        Document document = builder.parse(source);
        in.close();
        MutablePropertyDataSet result = null;
        NodeList kids = document.getChildNodes();
        for (int i = 0; i < kids.getLength(); ++i) {
            Node n = kids.item(i);
            if (!n.getNodeName().equals("netcdf")) continue;
            result = this.netcdf(n);
        }
        return result;
    }

    private MutablePropertyDataSet aggregation(Node aggr) throws MalformedURLException, IOException {
        NodeList kids = aggr.getChildNodes();
        Object result = null;
        LinkedHashMap<String, MutablePropertyDataSet> dss = new LinkedHashMap<String, MutablePropertyDataSet>();
        QDataSet depend = null;
        String lastKey = null;
        for (int i = 0; i < kids.getLength(); ++i) {
            Node n = kids.item(i);
            if (!n.getNodeName().equals("netcdf")) continue;
            MutablePropertyDataSet ds = this.netcdf(n);
            dss.put((String)ds.property("NAME"), ds);
            lastKey = (String)ds.property("NAME");
            if (ds.property("shape").equals(ds.property("NAME"))) continue;
            depend = ds;
        }
        if (depend != null) {
            String shape = (String)depend.property("shape");
            String[] shapes = shape.split("[, ]");
            for (int i = 0; i < shapes.length; ++i) {
                Ops.dependsOn(depend, i, (QDataSet)dss.get(shapes[i]));
            }
            return depend;
        }
        return (MutablePropertyDataSet)dss.get(lastKey);
    }

    private Units lookupUnits(String sunits) {
        if (sunits.contains("since")) {
            try {
                return Units.lookupTimeUnits(sunits);
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
        }
        return Units.lookupUnits(sunits);
    }

    protected MutablePropertyDataSet netcdf(Node node) throws MalformedURLException, IOException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        NodeList nl = node.getChildNodes();
        MutablePropertyDataSet result = null;
        LinkedHashMap<String, Node> dimensions = new LinkedHashMap<String, Node>();
        NamedNodeMap attrs = node.getAttributes();
        String dataType = null;
        if (attrs.getNamedItem("location") != null) {
            result = this.location(node);
        } else {
            for (int i = 0; i < nl.getLength(); ++i) {
                String oldLabel;
                Node child = nl.item(i);
                if (child.getNodeName().equals("aggregation")) {
                    result = this.aggregation(child);
                    continue;
                }
                if (child.getNodeName().equals("dimension")) {
                    dimensions.put(TsmlNcml.maybeGetAttr(child, "name"), child);
                    continue;
                }
                if (child.getNodeName().equals("attribute")) {
                    String attName = ((Attr)child.getAttributes().getNamedItem("name")).getValue();
                    String attValue = ((Attr)child.getAttributes().getNamedItem("value")).getTextContent();
                    if (attName.equals("units")) {
                        props.put("UNITS", this.lookupUnits(attValue));
                        continue;
                    }
                    if (attName.equals("DataType")) {
                        dataType = attValue;
                        continue;
                    }
                    if (attName.equals("long_name")) {
                        props.put("LABEL", attValue);
                        continue;
                    }
                    if (!attName.equals("title")) continue;
                    props.put("TITLE", attValue);
                    continue;
                }
                if (!child.getNodeName().equals("variable") || (oldLabel = (String)(result = this.variable(child, dimensions, null)).property("LABEL")) != null) continue;
                result.putProperty("LABEL", ((Attr)child.getAttributes().getNamedItem("name")).getValue());
            }
        }
        if (dataType != null && dataType.equals("vector")) {
            String[] componentLabels = new String[result.length(0)];
            for (int i = 0; i < componentLabels.length; ++i) {
                componentLabels[i] = "c" + i;
            }
            result.putProperty("DEPEND_1", Ops.labels(componentLabels));
        }
        for (Map.Entry e : props.entrySet()) {
            result.putProperty((String)e.getKey(), e.getValue());
        }
        return result;
    }

    private static int dimensionLength(Node dimension) {
        int n = Integer.parseInt(((Attr)dimension.getAttributes().getNamedItem("length")).getNodeValue());
        return n;
    }

    private static String maybeGetAttr(Node node, String name) {
        Node niosp = node.getAttributes().getNamedItem(name);
        if (niosp == null) {
            return null;
        }
        return niosp.getNodeValue();
    }

    protected MutablePropertyDataSet location(Node node) throws MalformedURLException, IOException {
        MutablePropertyDataSet result = null;
        String iosp = TsmlNcml.maybeGetAttr(node, "iosp");
        if ("org.timeseries.tsds".equals(iosp)) {
            result = this.tsdsLocation(node);
        }
        return result;
    }

    protected MutablePropertyDataSet variable(Node node, Map<String, Node> dimensions, MutablePropertyDataSet values) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        NodeList nl = node.getChildNodes();
        MutablePropertyDataSet result = values;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node child = nl.item(i);
            if (child.getNodeName().equals("attribute")) {
                String attName = ((Attr)child.getAttributes().getNamedItem("name")).getValue();
                String attValue = ((Attr)child.getAttributes().getNamedItem("value")).getTextContent();
                if (attName.equals("units")) {
                    props.put("UNITS", this.lookupUnits(attValue));
                    continue;
                }
                if (attName.equals("long_name")) {
                    props.put("LABEL", attValue);
                    continue;
                }
                if (!attName.equals("title")) continue;
                props.put("TITLE", attValue);
                continue;
            }
            if (!child.getNodeName().equals("values")) continue;
            Node increment = child.getAttributes().getNamedItem("increment");
            Double scale = Double.parseDouble(increment.getTextContent());
            Node start = child.getAttributes().getNamedItem("start");
            Double offset = Double.parseDouble(start.getTextContent());
            int n = TsmlNcml.dimensionLength(dimensions.get(TsmlNcml.maybeGetAttr(node, "shape")));
            result = new TagGenDataSet(n, scale, offset);
        }
        for (Map.Entry e : props.entrySet()) {
            result.putProperty((String)e.getKey(), e.getValue());
        }
        result.putProperty("NAME", TsmlNcml.maybeGetAttr(node, "name"));
        result.putProperty("shape", TsmlNcml.maybeGetAttr(node, "shape"));
        return result;
    }

    protected MutablePropertyDataSet tsdsLocation(Node node) throws MalformedURLException, IOException {
        MutablePropertyDataSet values;
        LinkedHashMap<String, Node> dims = new LinkedHashMap<String, Node>();
        Node variable = null;
        NodeList kids = node.getChildNodes();
        for (int i = 0; i < kids.getLength(); ++i) {
            Node n = kids.item(i);
            if (n.getNodeName().equals("dimension")) {
                dims.put(TsmlNcml.maybeGetAttr(n, "name"), n);
                continue;
            }
            if (!n.getNodeName().equals("variable")) continue;
            variable = n;
        }
        String shape = TsmlNcml.maybeGetAttr(variable, "shape");
        String[] shapes = shape.split("[, ]");
        int len1 = -1;
        if (dims.size() > 1) {
            len1 = TsmlNcml.dimensionLength((Node)dims.get(shapes[1]));
        }
        Object type = BufferDataSet.DOUBLE;
        int size = (len1 != -1 ? len1 : 1) * TsmlNcml.dimensionLength((Node)dims.get(shapes[0])) * BufferDataSet.byteCount(type);
        String surl = TsmlNcml.maybeGetAttr(node, "location");
        if (surl.contains("%2F%2F")) {
            surl = URLDecoder.decode(surl, "US-ASCII");
        }
        String s = TsmlNcml.maybeGetAttr(node, "iospParam");
        List<Object> iospParam = Collections.emptyList();
        if (s != null) {
            iospParam = Arrays.asList(s.split(","));
        }
        if (iospParam.contains("filter4")) {
            int points = TsmlNcml.dimensionLength((Node)dims.get(shapes[0])) / 3;
            BufferDataSet data3 = (BufferDataSet)this.tsds(new URL(this.codebase, surl), size, len1, type, new NullProgressMonitor());
            BufferDataSet data = (BufferDataSet)data3.trim(0, points);
            BufferDataSet dataMin = (BufferDataSet)data3.trim(2 * points, 3 * points);
            dataMin.putProperty("NAME", "binmin");
            BufferDataSet dataMax = (BufferDataSet)data3.trim(1 * points, 2 * points);
            dataMax.putProperty("NAME", "binmax");
            data.putProperty("DELTA_PLUS", Ops.subtract(dataMax, data));
            data.putProperty("DELTA_MINUS", Ops.subtract(data, dataMin));
            values = data;
        } else {
            values = this.tsds(new URL(this.codebase, surl), size, len1, type, new NullProgressMonitor());
        }
        return this.variable(variable, dims, values);
    }

    protected MutablePropertyDataSet tsds(URL url, int size, int len1, Object type, ProgressMonitor mon) throws IOException {
        URLConnection connection = url.openConnection();
        InputStream in = connection.getInputStream();
        String encoding = connection.getContentEncoding();
        logger.finer("downloading " + connection.getURL());
        if (encoding != null && encoding.equalsIgnoreCase("gzip")) {
            logger.finer("got gzip encoding");
            in = new GZIPInputStream(in);
        } else if (encoding != null && encoding.equalsIgnoreCase("deflate")) {
            logger.finer("got deflate encoding");
            in = new InflaterInputStream(in, new Inflater(true));
        }
        ReadableByteChannel bin = Channels.newChannel(in);
        logger.finer(String.format(Locale.US, "allocating space for dataset (%9.1f KB)", (double)size / 1000.0));
        ByteBuffer bbuf = ByteBuffer.allocate(size);
        int totalBytesRead = 0;
        int bytesRead = bin.read(bbuf);
        mon.setTaskSize(size);
        while (bytesRead >= 0 && bytesRead + totalBytesRead < size) {
            totalBytesRead += bytesRead;
            bytesRead = bin.read(bbuf);
            if (mon.isCancelled()) break;
            mon.setTaskProgress(totalBytesRead);
        }
        in.close();
        bbuf.flip();
        bbuf.order(ByteOrder.LITTLE_ENDIAN);
        if (len1 == -1) {
            int points = bbuf.limit() / BufferDataSet.byteCount(type);
            return BufferDataSet.makeDataSet(1, BufferDataSet.byteCount(type), 0, points, 1, 1, 1, bbuf, type);
        }
        int points = bbuf.limit() / len1 / BufferDataSet.byteCount(type);
        return BufferDataSet.makeDataSet(2, len1 * BufferDataSet.byteCount(type), 0, points, len1, 1, 1, bbuf, type);
    }
}

