/*
 * Decompiled with CFR 0.152.
 */
package org.tsds.datasource;

import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.LoggerManager;
import org.das2.datum.TimeParser;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;

public class TsdsTimeSeriesBrowse
implements TimeSeriesBrowse {
    private static final Logger logger = LoggerManager.getLogger("apdss.tsds");
    DatumRange timeRange;
    Datum resolution;
    int currentPpd = -1;
    int parameterPpd = -1;

    private DatumRange quantizeTimeRange(DatumRange timeRange) {
        timeRange = new DatumRange(TimeUtil.prevMidnight(timeRange.min()), TimeUtil.nextMidnight(timeRange.max()));
        return timeRange;
    }

    private int quantizePpd(Datum resolution) {
        int[] ppds = new int[]{1, 8, 24, 96, 144, 4320, 17280, 86400, 864000};
        if (resolution == null) {
            return 1;
        }
        double resdays = resolution.doubleValue(Units.days);
        double dppd = 1.0 / resdays;
        for (int i = 0; i < ppds.length && ppds[i] <= this.parameterPpd; ++i) {
            if (!((double)ppds[i] > dppd)) continue;
            int ppd = ppds[i];
            return ppd;
        }
        return this.parameterPpd;
    }

    @Override
    public void setTimeRange(DatumRange dr) {
        logger.log(Level.FINE, "{0}", dr);
        this.timeRange = this.quantizeTimeRange(dr);
        logger.log(Level.FINE, "{0}", this.timeRange);
        logger.log(Level.FINE, "{0}", this.timeRange.width());
    }

    @Override
    public void setTimeResolution(Datum d) {
        this.resolution = d;
        if (this.resolution == null) {
            this.currentPpd = -1;
        } else {
            this.currentPpd = this.quantizePpd(this.resolution);
            this.resolution = Units.days.createDatum(1.0).divide(this.currentPpd);
        }
    }

    @Override
    public String getURI() {
        TimeParser tp = TimeParser.create("%Y%m%d");
        String sparams = "StartDate=" + tp.format(this.timeRange.min(), null) + "&EndDate=" + tp.format(this.timeRange.max(), null) + "&ppd=" + this.currentPpd;
        return "vap+tsds:" + sparams;
    }

    @Override
    public String blurURI() {
        return "vap+tsds:";
    }

    @Override
    public DatumRange getTimeRange() {
        return this.timeRange;
    }

    @Override
    public Datum getTimeResolution() {
        return this.resolution;
    }

    @Override
    public void setURI(String suri) throws ParseException {
        URISplit split = URISplit.parse(suri);
        LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
        String startTime = (String)params.remove("StartDate");
        String endTime = (String)params.get("EndDate");
        String sppd = (String)params.get("ppd");
        if (startTime != null && endTime != null) {
            this.timeRange = new DatumRange(Units.us2000.parse(startTime), Units.us2000.parse(endTime));
        }
        if (sppd != null) {
            this.currentPpd = Integer.parseInt(sppd);
        }
    }
}

