/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.das2.util.FileUtil;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.AppletHttpProtocol;
import org.das2.util.filesystem.DefaultHttpProtocol;
import org.das2.util.filesystem.ExpensiveOpCache;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.FileSystemUtil;
import org.das2.util.filesystem.HtmlUtil;
import org.das2.util.filesystem.HttpUtil;
import org.das2.util.filesystem.WebFileObject;
import org.das2.util.filesystem.WebProtocol;
import org.das2.util.monitor.ProgressMonitor;

public abstract class WebFileSystem
extends FileSystem {
    protected static final Logger logger = LoggerManager.getLogger("das2.filesystem.wfs");
    public static final int LISTING_TIMEOUT_MS = 10000;
    public static final int MEMORY_LISTING_TIMEOUT_MS = 10000;
    public static final int HTTP_CHECK_TIMESTAMP_LIMIT_MS = 10000;
    ExpensiveOpCache accessCache;
    protected final File localRoot;
    private boolean applet;
    protected WebProtocol protocol;
    protected boolean offline = false;
    protected String offlineMessage = "";
    public static final String PROP_OFFLINE = "offline";
    protected int offlineResponseCode = 0;
    public static final String PROP_READ_ONLY_CACHE = "readOnlyCache";
    private File readOnlyCache = null;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final Map downloads = new HashMap();
    protected static final String id = String.format("%014d_%s", System.currentTimeMillis(), ManagementFactory.getRuntimeMXBean().getName());
    private final Map<String, FileSystem.DirectoryEntry[]> listings = new HashMap<String, FileSystem.DirectoryEntry[]>();
    private final Map<String, Long> listingFreshness = new HashMap<String, Long>();

    public static File getDownloadDirectory() {
        File local = FileSystem.settings().getLocalCacheDir();
        return local;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean offline) {
        boolean oldOffline = offline;
        this.offline = offline;
        this.propertyChangeSupport.firePropertyChange(PROP_OFFLINE, oldOffline, offline);
    }

    public String getOfflineMessage() {
        return this.offlineMessage;
    }

    public int getOfflineResponseCode() {
        return this.offlineResponseCode;
    }

    public final void setReadOnlyCache(File f) {
        File oldValue = this.readOnlyCache;
        this.readOnlyCache = f;
        this.propertyChangeSupport.firePropertyChange(PROP_READ_ONLY_CACHE, oldValue, this.readOnlyCache);
    }

    public final File getReadOnlyCache() {
        return this.readOnlyCache;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File lookForROCache(File start) {
        File localRoot = start;
        File stopFile = FileSystem.settings().getLocalCacheDir();
        File result = null;
        if (!localRoot.toString().startsWith(stopFile.toString())) {
            throw new IllegalArgumentException("localRoot filename (" + stopFile + ") must be parent of local root: " + start);
        }
        block11: while (!localRoot.equals(stopFile)) {
            File f = new File(localRoot, "ro_cache.txt");
            if (f.exists()) {
                BufferedReader read = null;
                try {
                    read = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
                    String s = read.readLine();
                    while (s != null) {
                        int i = s.indexOf("#");
                        if (i > -1) {
                            s = s.substring(0, i);
                        }
                        if (s.trim().length() > 0) {
                            if (s.startsWith("http:") || s.startsWith("https:") || s.startsWith("ftp:")) {
                                throw new IllegalArgumentException("ro_cache should contain the name of a local folder");
                            }
                            String sf = s.trim();
                            result = new File(sf);
                            break block11;
                        }
                        s = read.readLine();
                    }
                    break;
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    break;
                }
                finally {
                    try {
                        if (read != null) {
                            read.close();
                        }
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                }
            }
            localRoot = localRoot.getParentFile();
        }
        if (result == null) {
            return result;
        }
        String tail = start.getAbsolutePath().substring(localRoot.getAbsolutePath().length());
        if (tail.length() > 0) {
            return new File(result, tail);
        }
        return result;
    }

    protected Map<String, FileSystem.DirectoryEntry> addRoCacheEntries(String directory, Map<String, FileSystem.DirectoryEntry> remoteList) {
        File f = this.getReadOnlyCache();
        if (f != null) {
            String[] ss = new File(f, directory).list();
            if (ss == null) {
                return remoteList;
            }
            ArrayList<FileSystem.DirectoryEntry> add = new ArrayList<FileSystem.DirectoryEntry>();
            for (String s : ss) {
                File f1 = new File(f, directory + s);
                if (f1.isDirectory()) {
                    s = s + "/";
                }
                if (remoteList.containsKey(s)) continue;
                FileSystem.DirectoryEntry de1 = new FileSystem.DirectoryEntry();
                de1.modified = f1.lastModified();
                de1.name = s;
                de1.type = (char)(f1.isDirectory() ? 100 : 102);
                de1.size = f1.length();
                add.add(de1);
            }
            for (FileSystem.DirectoryEntry de1 : add) {
                remoteList.put(de1.name, de1);
            }
        }
        return remoteList;
    }

    protected WebFileSystem(URI root, File localRoot) {
        super(root);
        this.localRoot = localRoot;
        if (localRoot == null) {
            if (root.getScheme().equals("http") || root.getScheme().equals("https")) {
                this.protocol = new AppletHttpProtocol();
            }
        } else {
            File f;
            if (root.getScheme().equals("http") || root.getScheme().equals("https")) {
                this.protocol = new DefaultHttpProtocol();
            }
            if ((f = WebFileSystem.lookForROCache(localRoot)) != null) {
                this.setReadOnlyCache(f);
            }
        }
        ExpensiveOpCache.Op accessTime = root.getScheme().equals("http") || root.getScheme().equals("https") ? new LastAccessTime() : new ListingsLastAccessTime();
        this.accessCache = new ExpensiveOpCache(accessTime, 10000);
    }

    public static File localRoot(URI root) {
        File local = FileSystem.settings().getLocalCacheDir();
        logger.log(Level.FINE, "WFS localRoot={0}", local);
        String s = root.getScheme() + "/" + root.getHost() + "/" + root.getPath();
        local = new File(local, s);
        try {
            FileSystemUtil.maybeMkdirs(local);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
        return local;
    }

    private void waitForDownload(ProgressMonitor monitor, String filename) {
        monitor.setProgressMessage("waiting for file to download");
        ProgressMonitor downloadMonitor = (ProgressMonitor)this.downloads.get(filename);
        monitor.started();
        while (downloadMonitor != null) {
            monitor.setTaskSize(downloadMonitor.getTaskSize());
            boolean isCancelled = monitor.isCancelled();
            if (isCancelled) {
                downloadMonitor.cancel();
            } else {
                monitor.setTaskProgress(downloadMonitor.getTaskProgress());
            }
            try {
                this.downloads.wait(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            downloadMonitor = (ProgressMonitor)this.downloads.get(filename);
            if (downloadMonitor == null || !downloadMonitor.isFinished()) continue;
            logger.warning("watched downloadMonitor is finished but is not being unlocked");
            monitor.setProgressMessage("file is downloaded, just a moment");
        }
        monitor.finished();
    }

    public final File getPartFile(File localFile) {
        return new File(localFile.toString() + "." + id + ".part");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Lock getDownloadLock(String filename, File f, ProgressMonitor monitor) throws IOException {
        logger.log(Level.FINER, "{0} wants download lock for {1} wfs impl {2}", new Object[]{Thread.currentThread().getName(), filename, this.hashCode()});
        Map map = this.downloads;
        synchronized (map) {
            ProgressMonitor mon = (ProgressMonitor)this.downloads.get(filename);
            if (mon != null) {
                logger.log(Level.FINER, "another thread is downloading {0}, waiting...", filename);
                this.waitForDownload(monitor, filename);
                if (f.exists()) {
                    return null;
                }
                if (monitor.isCancelled()) {
                    throw new InterruptedIOException("request was cancelled");
                }
                throw new FileNotFoundException("expected to find " + f);
            }
            logger.log(Level.FINER, "this thread will download {0}.", filename);
            this.downloads.put(filename, monitor);
            monitor.started();
            return new LocalReentrantLock(filename);
        }
    }

    protected abstract void downloadFile(String var1, File var2, File var3, ProgressMonitor var4) throws IOException;

    public String getLocalRootAbsPath() {
        return this.localRoot.getAbsolutePath();
    }

    @Override
    public File getLocalRoot() {
        return this.localRoot;
    }

    public synchronized void resetListingCache() {
        if (!FileUtil.deleteWithinFileTree(this.localRoot, ".listing")) {
            throw new IllegalArgumentException("unable to delete all .listing files");
        }
        this.listings.clear();
        this.listingFreshness.clear();
    }

    public synchronized void resetListCache(String directory) {
        File f = new File(this.localRoot, (directory = WebFileSystem.toCanonicalFolderName(directory)) + ".listing");
        if (f.exists() && !f.delete()) {
            throw new IllegalArgumentException("unable to delete .listing file: " + f);
        }
        this.listings.remove(directory);
        this.listingFreshness.remove(directory);
    }

    protected File listingFile(String directory) {
        File f = new File(this.localRoot, directory);
        try {
            FileSystemUtil.maybeMkdirs(f);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("unable to mkdir " + f, ex);
        }
        File listing = new File(this.localRoot, directory + ".listing");
        return listing;
    }

    public synchronized boolean isListingCached(String directory) {
        File f = new File(this.localRoot, directory);
        if (!f.exists()) {
            return false;
        }
        File listing = this.listingFile(directory);
        if (listing.exists()) {
            long ageMs = System.currentTimeMillis() - listing.lastModified();
            if (ageMs < 10000L) {
                logger.log(Level.FINE, "listing date is {0} millisec old", ageMs);
                return true;
            }
            return false;
        }
        return false;
    }

    public synchronized void cacheListing(String directory, FileSystem.DirectoryEntry[] listing) {
        this.listings.put(directory, listing);
        this.listingFreshness.put(directory, System.currentTimeMillis());
    }

    protected synchronized FileSystem.DirectoryEntry[] listDirectoryFromMemory(String directory) {
        Long freshness = this.listingFreshness.get(directory = WebFileSystem.toCanonicalFilename(directory));
        if (freshness == null) {
            return null;
        }
        long ageMillis = System.currentTimeMillis() - freshness;
        if (System.currentTimeMillis() - freshness < 10000L) {
            logger.log(Level.FINER, "list directory from memory for {0}", directory);
            FileSystem.DirectoryEntry[] result = this.listings.get(directory);
            return result;
        }
        logger.log(Level.FINER, "remove old ({0}ms) directory listing for {1}", new Object[]{ageMillis, directory});
        this.listings.remove(directory);
        this.listingFreshness.remove(directory);
        return null;
    }

    public FileSystem.DirectoryEntry maybeUpdateDirectoryEntry(String filename, boolean force) throws IOException {
        String path = WebFileSystem.toCanonicalFilename(filename);
        int i = path.lastIndexOf("/");
        FileSystem.DirectoryEntry[] des = this.listDirectoryFromMemory(path.substring(0, i + 1));
        int itry = 10;
        while (force && des == null && itry-- > 0) {
            this.listDirectory(path.substring(0, i + 1));
            des = this.listDirectoryFromMemory(path.substring(0, i + 1));
        }
        if (force && des == null) {
            throw new IOException("unable to get listing: " + this.getRootURL() + path.substring(1, i + 1));
        }
        FileSystem.DirectoryEntry result = null;
        if (des != null) {
            String fname = path.substring(i + 1);
            for (i = 0; i < des.length; ++i) {
                if (!fname.equals(des[i].name)) continue;
                result = des[i];
            }
        }
        return result;
    }

    @Override
    public abstract boolean isDirectory(String var1) throws IOException;

    @Override
    public abstract String[] listDirectory(String var1) throws IOException;

    @Override
    public String[] listDirectory(String directory, String regex) throws IOException {
        String[] names = this.listDirectory(directory);
        Pattern pattern = Pattern.compile(regex);
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < names.length; ++i) {
            if (names[i].endsWith("/")) {
                names[i] = names[i].substring(0, names[i].length() - 1);
            }
            if (!pattern.matcher(names[i]).matches()) continue;
            result.add(names[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    public URL getURL(String filename) {
        filename = FileSystem.toCanonicalFilename(filename);
        try {
            return new URL(this.root.toURL(), FileSystemUtil.uriEncode(filename.substring(1)));
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public URI getURI(String filename) {
        try {
            filename = FileSystem.toCanonicalFilename(filename);
            return new URI(this.root + FileSystemUtil.uriEncode(filename.substring(1)));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public URL getRootURL() {
        try {
            return this.root.toURL();
        }
        catch (MalformedURLException ex) {
            String auth = this.root.getAuthority();
            String[] ss = auth.split("@");
            Object userInfo = null;
            if (ss.length > 3) {
                throw new IllegalArgumentException("user info section can contain at most two at (@) symbols");
            }
            if (ss.length == 3) {
                StringBuilder userInfo_ = new StringBuilder(ss[0]);
                for (int i = 1; i < 2; ++i) {
                    userInfo_.append("%40").append(ss[i]);
                }
                auth = ss[2];
                try {
                    URI rooturi2 = new URI(this.root.getScheme() + "://" + userInfo_.toString() + "@" + auth + this.root.getPath());
                    return rooturi2.toURL();
                }
                catch (MalformedURLException | URISyntaxException ex2) {
                    throw new RuntimeException(ex2);
                }
            }
            throw new RuntimeException(ex);
        }
    }

    public String getLocalName(File file) {
        if (!file.toString().startsWith(this.localRoot.toString())) {
            throw new IllegalArgumentException("file \"" + file + "\"is not of this web file system");
        }
        String filename = file.toString().substring(this.localRoot.toString().length());
        filename = filename.replaceAll("\\\\", "/");
        return filename;
    }

    public String getLocalName(URL url) {
        if (!url.toString().startsWith(this.root.toString())) {
            throw new IllegalArgumentException("url \"" + url + "\"is not of this web file system");
        }
        String filename = FileSystem.toCanonicalFilename(url.toString().substring(this.root.toString().length()));
        return filename;
    }

    @Override
    public FileObject getFileObject(String filename) {
        return new WebFileObject(this, filename, new Date(Long.MAX_VALUE));
    }

    protected synchronized long getLastAccessed(String filename) {
        try {
            FileSystem.DirectoryEntry result = (FileSystem.DirectoryEntry)this.accessCache.doOp(filename);
            return result.modified;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "returning 1970-01-01", ex);
            return 0L;
        }
    }

    protected void copyStream(InputStream is, OutputStream out, ProgressMonitor monitor) throws IOException {
        byte[] buffer = new byte[2048];
        int bytesRead = is.read(buffer, 0, 2048);
        long totalBytesRead = bytesRead;
        while (bytesRead > -1) {
            if (monitor.isCancelled()) {
                throw new InterruptedIOException();
            }
            monitor.setTaskProgress(totalBytesRead);
            out.write(buffer, 0, bytesRead);
            bytesRead = is.read(buffer, 0, 2048);
            totalBytesRead += (long)bytesRead;
            logger.finest("transferring data");
        }
    }

    public static void consumeStream(InputStream err) throws IOException {
        HtmlUtil.consumeStream(err);
    }

    public String toString() {
        return "wfs " + this.root;
    }

    public boolean isAppletMode() {
        return this.applet;
    }

    public void setAppletMode(boolean applet) {
        this.applet = applet;
    }

    private class LastAccessTime
    implements ExpensiveOpCache.Op {
        private LastAccessTime() {
        }

        @Override
        public Object doOp(String key) throws IOException {
            URL url = WebFileSystem.this.getURL(key);
            Map<String, String> meta = HttpUtil.getMetadata(url, null);
            FileSystem.DirectoryEntry result = new FileSystem.DirectoryEntry();
            result.modified = Long.parseLong(meta.get("LastModified"));
            result.name = key;
            result.size = Long.parseLong(meta.get("ContentLength"));
            return result;
        }
    }

    private class ListingsLastAccessTime
    implements ExpensiveOpCache.Op {
        private ListingsLastAccessTime() {
        }

        @Override
        public Object doOp(String key) throws IOException {
            File localFile = new File(WebFileSystem.this.getLocalRoot(), key);
            String name = localFile.getName();
            String parent = WebFileSystem.this.getLocalName(localFile.getParentFile());
            parent = parent + '/';
            String[] ss = WebFileSystem.this.listDirectory(parent);
            logger.log(Level.FINE, "ss.length={0}", ss.length);
            FileSystem.DirectoryEntry[] des = WebFileSystem.this.listDirectoryFromMemory(parent);
            if (des == null) {
                return new Date(0L);
            }
            for (FileSystem.DirectoryEntry de : des) {
                if (!de.name.equals(name)) continue;
                return de;
            }
            return FileSystem.NULL;
        }
    }

    private class LocalReentrantLock
    extends ReentrantLock {
        String filename;

        private LocalReentrantLock(String filename) {
            this.filename = filename;
        }

        @Override
        public void lock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unlock() {
            Map map = WebFileSystem.this.downloads;
            synchronized (map) {
                WebFileSystem.this.downloads.remove(this.filename);
                WebFileSystem.this.downloads.notifyAll();
            }
        }
    }
}

