/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.util.Base64;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.FileSystemSettings;
import org.das2.util.filesystem.FileSystemUtil;
import org.das2.util.filesystem.HttpFileSystem;
import org.das2.util.filesystem.HttpUtil;
import org.das2.util.filesystem.KeyChain;
import org.das2.util.filesystem.WebFileSystem;
import org.das2.util.monitor.CancelledOperationException;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class WebFileObject
extends FileObject {
    private static final Logger logger = LoggerManager.getLogger("das2.filesystem.wfs");
    final WebFileSystem wfs;
    String pathname;
    File localFile;
    boolean isRoot;
    boolean isFolder;
    Map<String, String> metadata;
    long metaFresh = 0L;
    Date modifiedDate;
    long size = -1L;
    boolean isFolderResolved = false;
    public int METADATA_FRESH_TIMEOUT_MS = 10000;

    @Override
    public boolean canRead() {
        return true;
    }

    protected synchronized void maybeLoadMetadata() throws IOException {
        if (this.metadata == null) {
            if (this.wfs.offline) {
                if (FileSystem.settings().isOffline()) {
                    this.metadata = new HashMap<String, String>();
                    this.metadata.put("exist", this.isLocal() ? "true" : "false");
                } else if (this.wfs.protocol != null) {
                    this.metadata = this.wfs.protocol.getMetadata(this);
                }
            } else if (this.wfs.protocol != null) {
                this.metadata = this.wfs.protocol.getMetadata(this);
            }
            this.metaFresh = System.currentTimeMillis();
        }
    }

    @Override
    public FileObject[] getChildren() throws IOException {
        if (!this.isFolder) {
            throw new IllegalArgumentException(this.toString() + "is not a folder");
        }
        String[] list = this.wfs.listDirectory(this.pathname);
        FileObject[] result = new FileObject[list.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new WebFileObject(this.wfs, list[i], new Date(System.currentTimeMillis()));
        }
        return result;
    }

    @Override
    public InputStream getInputStream(ProgressMonitor monitor) throws FileNotFoundException, IOException {
        if (this.wfs.protocol != null && !this.wfs.offline) {
            logger.log(Level.FINE, "get inputstream from {0}", this.wfs.protocol);
            return this.wfs.protocol.getInputStream(this, monitor);
        }
        if (this.isFolder) {
            throw new IllegalArgumentException("is a folder");
        }
        if (this.modifiedDate.getTime() == 0L) {
            this.lastModified();
        }
        if (!this.localFile.exists() || this.modifiedDate.getTime() - this.localFile.lastModified() > 10L && !this.wfs.isOffline()) {
            File partFile = new File(this.localFile.toString() + ".part");
            this.wfs.downloadFile(this.pathname, this.localFile, partFile, monitor);
        }
        logger.log(Level.FINE, "read local file {0}", this.localFile);
        return new FileInputStream(this.localFile);
    }

    @Override
    public FileObject getParent() {
        return new WebFileObject(this.wfs, this.wfs.getLocalName(this.localFile.getParentFile()), new Date(System.currentTimeMillis()));
    }

    @Override
    public boolean isData() {
        return !this.isFolder;
    }

    @Override
    public boolean isFolder() {
        if (this.isFolderResolved) {
            return this.isFolder;
        }
        try {
            this.isFolder = this.wfs.isDirectory(this.pathname);
            this.isFolderResolved = true;
            return this.isFolder;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean isRoot() {
        return this.isRoot;
    }

    @Override
    public Date lastModified() {
        if (System.currentTimeMillis() - this.metaFresh > (long)this.METADATA_FRESH_TIMEOUT_MS) {
            this.metadata = null;
            this.modifiedDate = new Date(Long.MAX_VALUE);
        }
        if (this.modifiedDate.getTime() == Long.MAX_VALUE) {
            try {
                this.maybeLoadMetadata();
            }
            catch (IOException ex) {
                logger.log(Level.FINE, "unable to load metadata: {0}", ex);
                this.modifiedDate = new Date(this.localFile.lastModified());
            }
            if (this.metadata != null && this.metadata.containsKey("Last-Modified")) {
                long date = Date.parse(this.metadata.get("Last-Modified"));
                this.modifiedDate = new Date(date);
            } else {
                logger.fine("metadata doesn't contain Last-Modified, using localFile");
                this.modifiedDate = new Date(this.localFile.lastModified());
            }
        }
        return new Date(this.modifiedDate.getTime());
    }

    @Override
    public long getSize() {
        if (this.isFolder) {
            throw new IllegalArgumentException("is a folder");
        }
        if (this.size == -1L) {
            try {
                this.maybeLoadMetadata();
            }
            catch (IOException ex) {
                logger.log(Level.FINE, "unable to load metadata: {0}", ex);
                this.size = this.localFile.length();
            }
            if (this.metadata.containsKey("Content-Length")) {
                this.size = Long.parseLong(this.metadata.get("Content-Length"));
            } else {
                logger.fine("remote length is not known");
                this.size = this.localFile.length();
            }
        }
        return this.size;
    }

    protected void setLastModified(Date d) {
        if (this.modifiedDate.getTime() == 0L || this.modifiedDate.getTime() == Long.MAX_VALUE) {
            this.modifiedDate = d;
        } else if (!d.equals(this.modifiedDate)) {
            throw new IllegalArgumentException("valid date cannot be modified");
        }
    }

    protected void setSize(long size) {
        if (this.size == -1L) {
            this.size = size;
        } else if (size != this.size) {
            throw new IllegalArgumentException("valid size cannot be modified");
        }
    }

    protected File getLocalFile() {
        return this.localFile;
    }

    @Override
    public boolean removeLocalFile() {
        if (this.localFile == null) {
            logger.fine("failed to removeLocalFile, it is null.  Applet mode");
            return true;
        }
        if (!this.localFile.exists()) {
            logger.fine("localfile does not exist.");
            return true;
        }
        if (this.localFile.canWrite()) {
            if (!this.localFile.delete()) {
                logger.log(Level.FINE, "failed to removeLocalFile: {0}", this.localFile);
                return false;
            }
            logger.log(Level.FINER, "local file was removed: {0}", this.localFile);
            return true;
        }
        logger.log(Level.FINE, "user does not have access to delete the local file: {0}", this.localFile);
        return true;
    }

    @Override
    public boolean exists() {
        File f;
        File ff;
        if (this.wfs.getReadOnlyCache() != null && (ff = new File(f = this.wfs.getReadOnlyCache(), this.pathname)).exists()) {
            return true;
        }
        if (this.localFile != null && this.localFile.exists() && this.wfs.isAppletMode()) {
            return true;
        }
        try {
            if (this.wfs.protocol != null) {
                this.maybeLoadMetadata();
                return "true".equals(this.metadata.get("exist"));
            }
            logger.fine("This implementation of WebFileObject.exists() is not optimal");
            File partFile = new File(this.localFile.toString() + ".part");
            this.wfs.downloadFile(this.pathname, this.localFile, partFile, new NullProgressMonitor());
            return this.localFile.exists();
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    protected WebFileObject(WebFileSystem wfs, String pathname, Date modifiedDate) {
        this.modifiedDate = modifiedDate;
        this.wfs = wfs;
        this.pathname = pathname;
        this.isFolderResolved = false;
        if (!wfs.isAppletMode()) {
            this.localFile = new File(wfs.getLocalRoot(), pathname);
            if (FileSystem.settings().getPersistence() == FileSystemSettings.Persistence.SESSION) {
                this.localFile.deleteOnExit();
            }
            try {
                if (!this.localFile.canRead()) {
                    if (pathname.equals("") || pathname.endsWith("/")) {
                        FileSystemUtil.maybeMkdirs(this.localFile);
                        this.isFolder = true;
                        if ("".equals(pathname)) {
                            this.isRoot = true;
                        }
                        this.isFolderResolved = true;
                    } else {
                        this.isFolderResolved = false;
                    }
                } else {
                    this.isFolder = this.localFile.isDirectory();
                    this.isFolderResolved = true;
                }
            }
            catch (ConnectException ex) {
                ex.printStackTrace();
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "unable to construct web file object", ex);
                this.isFolderResolved = false;
            }
        }
    }

    public String toString() {
        return "[" + this.wfs + "]" + this.getNameExt();
    }

    @Override
    public String getNameExt() {
        return this.pathname;
    }

    @Override
    public ReadableByteChannel getChannel(ProgressMonitor monitor) throws FileNotFoundException, IOException {
        InputStream in = this.getInputStream(monitor);
        return Channels.newChannel(in);
    }

    @Override
    public File getFile(ProgressMonitor monitor) throws FileNotFoundException, IOException {
        Date remoteDate;
        File cacheFile;
        if (this.wfs.isAppletMode()) {
            throw new SecurityException("getFile cannot be used with applets.");
        }
        boolean download = false;
        if (monitor == null) {
            throw new NullPointerException("monitor may not be null");
        }
        long remoteLength = 0L;
        if (this.wfs.getReadOnlyCache() != null && (cacheFile = new File(this.wfs.getReadOnlyCache(), this.getNameExt())).exists()) {
            logger.log(Level.FINE, "using file from ro_cache: {0}", this.getNameExt());
            return cacheFile;
        }
        if (this.isLocal()) {
            remoteDate = new Date(this.localFile.lastModified());
            remoteLength = this.localFile.length();
        } else if (this.wfs instanceof HttpFileSystem && !this.wfs.isOffline()) {
            String contentLocation;
            String cookie;
            URL url = this.wfs.getURL(this.getNameExt());
            String userInfo = null;
            try {
                userInfo = KeyChain.getDefault().getUserInfo(url);
            }
            catch (CancelledOperationException ex) {
                throw new FileSystem.FileSystemOfflineException("user cancelled credentials");
            }
            HashMap<String, String> requestProperties = new HashMap<String, String>();
            if (userInfo != null) {
                String encode = Base64.encodeBytes(userInfo.getBytes());
                requestProperties.put("Authorization", "Basic " + encode);
            }
            if ((cookie = ((HttpFileSystem)this.wfs).getCookie()) != null) {
                requestProperties.put("Cookie", cookie);
            }
            Map<String, String> meta = HttpUtil.getMetadata(url, requestProperties);
            long lastModified = Long.parseLong(meta.get("LastModified"));
            remoteDate = new Date(lastModified);
            logger.log(Level.FINE, "HEAD request reports connection.getLastModified()={0}", remoteDate);
            long contentLength = Long.parseLong(meta.get("ContentLength"));
            if (contentLength > -1L) {
                remoteLength = contentLength;
            }
            if ("application/x-gzip".equals(meta.get("ContentType")) && (contentLocation = meta.get("Content-Location")) != null && contentLocation.endsWith(".gz")) {
                remoteLength = -1L;
            }
        } else {
            if (this.lastModified().getTime() == 0L || this.lastModified().getTime() == Long.MAX_VALUE) {
                FileSystem.DirectoryEntry result = this.wfs.maybeUpdateDirectoryEntry(this.getNameExt(), true);
                if (result == null) {
                    logger.fine("file does not exist on remote filesystem");
                } else {
                    result = this.wfs.maybeUpdateDirectoryEntry(this.getNameExt(), true);
                    remoteDate = new Date(result.modified);
                    remoteLength = result.size;
                    this.setLastModified(remoteDate);
                    this.setSize(remoteLength);
                }
                if (!(this.wfs instanceof HttpFileSystem)) {
                    download = true;
                }
            }
            remoteDate = this.lastModified();
            remoteLength = this.getSize();
        }
        if (this.localFile.exists()) {
            Date localFileLastModified = new Date(this.localFile.lastModified());
            if (remoteDate.after(localFileLastModified) || remoteLength > -1L && remoteLength != this.localFile.length()) {
                logger.log(Level.FINE, "remote file length is different or is newer than local copy of {0}, download.", this.getNameExt());
                download = true;
            }
        } else {
            download = true;
        }
        if (download && this.wfs.getReadOnlyCache() != null && (cacheFile = new File(this.wfs.getReadOnlyCache(), this.getNameExt())).exists()) {
            logger.log(Level.FINE, "using file from ro_cache: {0}", this.getNameExt());
            return cacheFile;
        }
        if (download) {
            try {
                logger.log(Level.FINE, "downloading file {0}", this.getNameExt());
                if (!this.localFile.getParentFile().exists()) {
                    FileSystemUtil.maybeMkdirs(this.localFile.getParentFile());
                }
                File partFile = this.wfs.getPartFile(this.localFile);
                this.wfs.downloadFile(this.pathname, this.localFile, partFile, monitor.getSubtaskMonitor("download file"));
                if (!this.localFile.setLastModified(remoteDate.getTime())) {
                    logger.log(Level.FINE, "unable to modify date of {0}", this.localFile);
                }
                logger.log(Level.FINE, "downloaded local file has date {0}", new Date(this.localFile.lastModified()));
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException ex) {
                if (ex.getMessage() != null && ex.getMessage().contains("Forbidden")) {
                    throw ex;
                }
                if (this.wfs instanceof HttpFileSystem && !(ex instanceof InterruptedIOException) && this.wfs.isOffline()) {
                    logger.log(Level.SEVERE, "unable getFile", ex);
                    throw new FileSystem.FileSystemOfflineException("not found in local cache: " + this.getNameExt());
                }
                throw ex;
            }
            finally {
                monitor.finished();
            }
        }
        return this.localFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLocal() {
        boolean download;
        block11: {
            Object cacheFile;
            if (this.wfs.isAppletMode()) {
                return false;
            }
            if (this.wfs.getReadOnlyCache() != null && ((File)(cacheFile = new File(this.wfs.getReadOnlyCache(), this.getNameExt()))).exists()) {
                logger.log(Level.FINE, "file exists in ro_cache, so trivially local: {0}", this.getNameExt());
                return true;
            }
            if (this.localFile.exists()) {
                if (!this.wfs.isOffline()) {
                    try {
                        cacheFile = this.wfs;
                        synchronized (cacheFile) {
                            FileSystem.DirectoryEntry remoteDate = (FileSystem.DirectoryEntry)this.wfs.accessCache.doOp(this.getNameExt());
                            long localFileLastModified = this.localFile.lastModified();
                            this.setLastModified(new Date(remoteDate.modified));
                            this.setSize(remoteDate.size);
                            if (remoteDate.modified > localFileLastModified) {
                                logger.log(Level.FINE, "remote file is newer than local copy of {0}, download.", this.getNameExt());
                                download = true;
                            } else {
                                download = remoteDate.size != this.localFile.length();
                            }
                            break block11;
                        }
                    }
                    catch (Exception ex) {
                        logger.log(Level.WARNING, ex.getMessage(), ex);
                        return false;
                    }
                }
                logger.log(Level.FINE, "wfs is offline, and local file exists: {0}", this.getNameExt());
                return true;
            }
            download = true;
        }
        return !download;
    }
}

