/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.FileSystemUtil;
import org.das2.util.filesystem.VFSFileSystem;
import org.das2.util.monitor.ProgressMonitor;

public class VFSFileObject
extends FileObject {
    private static final Logger logger = LoggerManager.getLogger("das2.filesystem.vfs");
    private org.apache.commons.vfs.FileObject vfsob;
    private VFSFileSystem vfsfs;
    private boolean local = false;
    private File localFile = null;
    private String localName = null;

    private static String relativeName(org.apache.commons.vfs.FileObject root, org.apache.commons.vfs.FileObject f) throws FileSystemException {
        String roots = root.getName().toString();
        String fs = f.getName().toString();
        if (fs.startsWith(roots)) {
            return fs.substring(roots.length());
        }
        throw new IllegalArgumentException("not a child:" + f);
    }

    protected VFSFileObject(VFSFileSystem fs, org.apache.commons.vfs.FileObject f) {
        this.vfsfs = fs;
        this.vfsob = f;
        if (this.vfsfs.isLocal()) {
            this.local = true;
        }
        try {
            this.localName = VFSFileObject.relativeName(fs.getVFSFileObject(), f);
            this.localFile = new File(this.vfsfs.getLocalRoot(), this.localName);
        }
        catch (FileSystemException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    @Override
    public boolean canRead() {
        boolean r;
        try {
            r = this.vfsob.isReadable();
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e);
        }
        return r;
    }

    @Override
    public FileObject[] getChildren() throws IOException {
        org.apache.commons.vfs.FileObject[] vfsKids = this.vfsob.getChildren();
        FileObject[] kids = new FileObject[vfsKids.length];
        for (int i = 0; i < vfsKids.length; ++i) {
            kids[i] = new VFSFileObject(this.vfsfs, vfsKids[i]);
        }
        return kids;
    }

    @Override
    public InputStream getInputStream(ProgressMonitor monitor) throws FileNotFoundException, IOException {
        InputStream r;
        try {
            r = this.vfsob.getContent().getInputStream();
        }
        catch (FileSystemException e) {
            throw new IOException(e.getMessage());
        }
        return r;
    }

    @Override
    public ReadableByteChannel getChannel(ProgressMonitor monitor) throws FileNotFoundException, IOException {
        InputStream in = this.getInputStream(monitor);
        return Channels.newChannel(in);
    }

    @Override
    public File getFile(ProgressMonitor monitor) throws FileNotFoundException, IOException {
        boolean download;
        if (this.localFile.exists()) {
            Date localFileLastModified = new Date(this.localFile.lastModified());
            Date remoteDate = new Date(this.vfsob.getContent().getLastModifiedTime());
            if (remoteDate.after(localFileLastModified)) {
                FileSystem.logger.info("remote file is newer than local copy of " + this.getNameExt() + ", download.");
                download = true;
            } else {
                download = false;
            }
        } else {
            download = true;
        }
        if (download) {
            if (this.vfsob.getType() == FileType.FOLDER) {
                if (!this.localFile.exists()) {
                    FileSystemUtil.maybeMkdirs(this.localFile);
                }
            } else {
                if (!this.localFile.getParentFile().exists()) {
                    FileSystemUtil.maybeMkdirs(this.localFile.getParentFile());
                    File p = this.localFile.getParentFile();
                    File stopAt = new File(new File(FileSystem.settings().getLocalCacheDir(), "vfsCache"), "sftp");
                    for (int i = 10; i > 0 && !p.equals(stopAt); --i) {
                        p.setReadable(false, false);
                        p.setReadable(true, true);
                        p.setExecutable(false, false);
                        p.setExecutable(true, true);
                        p = p.getParentFile();
                    }
                }
                File partfile = new File(this.localFile.toString() + ".part");
                this.vfsfs.downloadFile(this.localName, this.localFile, partfile, monitor);
            }
            this.local = true;
        }
        return this.localFile;
    }

    @Override
    public FileObject getParent() {
        org.apache.commons.vfs.FileObject vfsParent;
        try {
            vfsParent = this.vfsob.getParent();
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e);
        }
        return new VFSFileObject(this.vfsfs, vfsParent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize() {
        long size = -1L;
        try {
            size = this.vfsob.getContent().getSize();
            return size;
        }
        catch (FileSystemException e) {
            logger.log(Level.SEVERE, "unable to getSize", e);
        }
        finally {
            return size;
        }
    }

    @Override
    public boolean isData() {
        return !this.isFolder();
    }

    @Override
    public boolean isFolder() {
        boolean r;
        try {
            r = this.vfsob.getType() == FileType.FOLDER;
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e);
        }
        return r;
    }

    @Override
    public boolean isReadOnly() {
        boolean r;
        try {
            r = !this.vfsob.isWriteable();
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e);
        }
        return r;
    }

    @Override
    public boolean isRoot() {
        boolean r;
        try {
            r = this.vfsob.getParent() == null;
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e);
        }
        return r;
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    @Override
    public boolean exists() {
        boolean r;
        try {
            r = this.vfsob.exists();
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e);
        }
        return r;
    }

    @Override
    public String getNameExt() {
        FileName fname = this.vfsob.getName();
        return fname.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date lastModified() {
        long when = 0L;
        try {
            when = this.vfsob.getContent().getLastModifiedTime();
            return when;
        }
        catch (FileSystemException e) {
            logger.log(Level.SEVERE, "unable get last modified", e);
        }
        finally {
            return new Date(when);
        }
    }

    public boolean canWrite() throws IOException {
        return this.vfsob.isWriteable();
    }

    public void createFolder() throws IOException {
        this.vfsob.createFolder();
    }

    public void createFile() throws IOException {
        this.vfsob.createFile();
    }

    public void delete() throws IOException {
        this.vfsob.delete();
    }

    public OutputStream getOutputStream(boolean append) throws IOException {
        return this.vfsob.getContent().getOutputStream(append);
    }

    public void close() throws IOException {
        this.vfsob.close();
    }
}

