/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.util.Base64;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.HttpUtil;
import org.das2.util.filesystem.KeyChain;
import org.das2.util.monitor.CancelledOperationException;

public class HtmlUtil {
    private static final Logger logger = LoggerManager.getLogger("das2.filesystem");
    protected static final Logger loggerUrl = LoggerManager.getLogger("das2.url");

    public static boolean isDirectory(URL url) {
        String file = url.getFile();
        return file.charAt(file.length() - 1) != '/';
    }

    @Deprecated
    public static void consumeStream(InputStream err) throws IOException {
        HttpUtil.consumeStream(err);
    }

    public static URL[] getDirectoryListing(URL url, InputStream urlStream) throws IOException, CancelledOperationException {
        return HtmlUtil.getDirectoryListing(url, urlStream, true);
    }

    public static URL[] getDirectoryListing(URL url, InputStream urlStream, boolean childCheck) throws IOException, CancelledOperationException {
        long t0 = System.currentTimeMillis();
        byte[] b = new byte[10000];
        int numRead = urlStream.read(b);
        StringBuilder contentBuffer = new StringBuilder(10000);
        if (numRead != -1) {
            contentBuffer.append(new String(b, 0, numRead, "UTF-8"));
        }
        while (numRead != -1) {
            FileSystem.logger.finest("download listing");
            numRead = urlStream.read(b);
            if (numRead == -1) continue;
            String newContent = new String(b, 0, numRead, "UTF-8");
            contentBuffer.append(newContent);
        }
        urlStream.close();
        logger.log(Level.FINER, "read listing data in {0} millis", System.currentTimeMillis() - t0);
        String content = contentBuffer.toString();
        String hrefRegex = "(?i)href\\s*=\\s*([\"'])(.+?)\\1";
        Pattern hrefPattern = Pattern.compile(hrefRegex);
        Matcher matcher = hrefPattern.matcher(content);
        ArrayList<URL> urlList = new ArrayList<URL>();
        String surl = url.toString();
        while (matcher.find()) {
            URL urlLink;
            FileSystem.logger.finest("parse listing");
            String strLink = matcher.group(2);
            try {
                urlLink = new URL(url, URLDecoder.decode(strLink, "UTF-8"));
                strLink = urlLink.toString();
            }
            catch (MalformedURLException e) {
                logger.log(Level.SEVERE, "bad URL: {0} {1}", new Object[]{url, strLink});
                continue;
            }
            if (childCheck) {
                String file;
                if (!strLink.startsWith(surl) || strLink.length() <= surl.length() || null != urlLink.getQuery() || (file = strLink.substring(surl.length())).startsWith("../")) continue;
                urlList.add(urlLink);
                continue;
            }
            urlList.add(urlLink);
        }
        return urlList.toArray(new URL[urlList.size()]);
    }

    public static URL[] getDirectoryListing(URL url) throws IOException, CancelledOperationException {
        FileSystem.logger.log(Level.FINER, "listing {0}", url);
        String file = url.getFile();
        if (file.charAt(file.length() - 1) != '/') {
            url = new URL(url.toString() + '/');
        }
        InputStream urlStream = HtmlUtil.getInputStream(url);
        return HtmlUtil.getDirectoryListing(url, urlStream);
    }

    public static InputStream getInputStream(URL url) throws IOException, CancelledOperationException {
        loggerUrl.log(Level.FINE, "getInputStream {0}", new Object[]{url});
        long t0 = System.currentTimeMillis();
        String userInfo = KeyChain.getDefault().getUserInfo(url);
        loggerUrl.log(Level.FINE, "openConnect {0}", new Object[]{url});
        URLConnection urlConnection = url.openConnection();
        urlConnection.setAllowUserInteraction(false);
        urlConnection.setConnectTimeout(FileSystem.settings().getConnectTimeoutMs());
        logger.log(Level.FINER, "connected in {0} millis", System.currentTimeMillis() - t0);
        if (userInfo != null) {
            String encode = Base64.encodeBytes(userInfo.getBytes());
            urlConnection.setRequestProperty("Authorization", "Basic " + encode);
        }
        urlConnection = HttpUtil.checkRedirect(urlConnection);
        return urlConnection.getInputStream();
    }

    @Deprecated
    public static Map<String, String> getMetadata(URL url, Map<String, String> props) throws IOException {
        return HttpUtil.getMetadata(url, props);
    }

    @Deprecated
    public static URLConnection checkRedirect(URLConnection urlConnection) throws IOException {
        return HttpUtil.checkRedirect(urlConnection);
    }
}

