/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.security.AllPermission;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.util.LoggerManager;

public class FileSystemSettings {
    private static final Logger logger = LoggerManager.getLogger("org.das2.util.filesystem");
    private static boolean restrictPermission = false;
    protected File localCacheDir = null;
    public static final String PROP_LOCALCACHEDIR = "localCacheDir";
    protected Persistence persistence = Persistence.SESSION;
    public static final String PROP_PERSISTENCE = "persistence";
    protected boolean allowOffline = true;
    public static final String PROP_ALLOWOFFLINE = "allowOffline";
    public static final String PROP_OFFLINE = "offline";
    private boolean offline = false;
    protected static final long allowableExternalIdleMs = 60000L;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public static boolean hasAllPermission() {
        try {
            if (restrictPermission) {
                return false;
            }
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(new AllPermission());
            }
            return true;
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    public static void setRestrictPermission(boolean v) {
        restrictPermission = v;
    }

    protected FileSystemSettings() {
        File local;
        if (!FileSystemSettings.hasAllPermission()) {
            local = new File("applet_mode");
        } else {
            local = System.getProperty("user.name").equals("Web") ? new File("/tmp") : new File(System.getProperty("user.home"));
            local = new File(local, ".das2/fsCache/wfs/");
        }
        this.localCacheDir = local;
    }

    public int getConnectTimeoutMs() {
        return 5000;
    }

    public int getReadTimeoutMs() {
        return 60000;
    }

    public int getTemporaryFileTimeoutSeconds() {
        return 3600;
    }

    public File getLocalCacheDir() {
        return this.localCacheDir;
    }

    public void setLocalCacheDir(File localCacheDir) {
        File oldLocalCacheDir = this.localCacheDir;
        this.localCacheDir = localCacheDir;
        logger.log(Level.FINE, "setLocalCacheDir({0})", localCacheDir);
        this.propertyChangeSupport.firePropertyChange(PROP_LOCALCACHEDIR, oldLocalCacheDir, localCacheDir);
    }

    public Persistence getPersistence() {
        return this.persistence;
    }

    public void setPersistence(Persistence persistence) {
        Persistence oldPersistence = this.persistence;
        this.persistence = persistence;
        this.propertyChangeSupport.firePropertyChange(PROP_PERSISTENCE, (Object)oldPersistence, (Object)persistence);
    }

    public boolean isAllowOffline() {
        return this.allowOffline;
    }

    public void setAllowOffline(boolean allowOffline) {
        boolean oldAllowOffline = allowOffline;
        this.allowOffline = allowOffline;
        this.propertyChangeSupport.firePropertyChange(PROP_ALLOWOFFLINE, oldAllowOffline, allowOffline);
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean offline) {
        boolean v = this.offline;
        this.offline = offline;
        this.propertyChangeSupport.firePropertyChange(PROP_OFFLINE, v, offline);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public static enum Persistence {
        NONE,
        SESSION,
        EXPIRES,
        ALWAYS;

    }
}

