/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.HttpUtil;
import org.das2.util.filesystem.WebFileObject;
import org.das2.util.filesystem.WebProtocol;
import org.das2.util.monitor.ProgressMonitor;

public class DefaultHttpProtocol
implements WebProtocol {
    private static final Logger logger = LoggerManager.getLogger("das2.filesystem");

    @Override
    public InputStream getInputStream(WebFileObject fo, ProgressMonitor mon) throws IOException {
        if (fo.isFolder) {
            throw new IllegalArgumentException("is a folder");
        }
        File ff = fo.getFile(mon);
        return new FileInputStream(ff);
    }

    private static String urlEncodeSansSlash(String realName) {
        int i;
        String[] ss = realName.split("/", -2);
        for (int i2 = 0; i2 < ss.length; ++i2) {
            try {
                ss[i2] = URLEncoder.encode(ss[i2], "UTF-8");
                continue;
            }
            catch (UnsupportedEncodingException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        StringBuilder builder = new StringBuilder();
        for (i = 0; ss[i].length() == 0 && i < ss.length; ++i) {
        }
        builder.append(ss[i]);
        ++i;
        while (i < ss.length) {
            if (ss[i].length() > 0) {
                builder.append("/").append(ss[i]);
            }
            ++i;
        }
        return builder.toString();
    }

    @Override
    public Map<String, String> getMetadata(WebFileObject fo) throws IOException {
        URL ur = new URL(fo.wfs.getRootURL(), DefaultHttpProtocol.urlEncodeSansSlash(fo.pathname).replaceAll("\\+", "%20"));
        return HttpUtil.getMetadata(ur, null);
    }
}

