/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import org.das2.util.DasProgressMonitorInputStream;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.HttpUtil;
import org.das2.util.filesystem.WebFileObject;
import org.das2.util.filesystem.WebProtocol;
import org.das2.util.monitor.ProgressMonitor;

public class AppletHttpProtocol
implements WebProtocol {
    @Override
    public InputStream getInputStream(WebFileObject fo, ProgressMonitor mon) throws IOException {
        HttpURLConnection connect = (HttpURLConnection)fo.wfs.getURL(fo.pathname).openConnection();
        connect.connect();
        int len = connect.getContentLength();
        FileSystem.loggerUrl.log(Level.FINE, "getInputStream {0}", new Object[]{connect.getURL()});
        DasProgressMonitorInputStream in = new DasProgressMonitorInputStream(connect.getInputStream(), mon);
        if (len != -1) {
            in.setStreamLength(len);
        }
        return in;
    }

    @Override
    public Map<String, String> getMetadata(WebFileObject fo) throws IOException {
        URL ur = new URL(fo.wfs.getRootURL(), fo.pathname);
        Map<String, String> result = HttpUtil.getMetadata(ur, null);
        return result;
    }
}

