/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.das2.util.LoggerManager;

public class WindowManager {
    private static final Logger logger = LoggerManager.getLogger("das2.windowmanager");
    private static final WindowManager instance = new WindowManager();

    public static WindowManager getInstance() {
        return instance;
    }

    public static int showConfirmDialog(Component parent, JPanel omessage, String title, int optionType, int messageType, Icon icon) {
        return WindowManager.showConfirmDialog(parent, omessage, title, optionType);
    }

    public void recallWindowSizePosition(Window window) {
        Container parent = window.getParent();
        String name = window.getName();
        logger.log(Level.FINE, "looking up position for {0}", name);
        if (name == null) {
            return;
        }
        Preferences prefs = Preferences.userNodeForPackage(WindowManager.class);
        int grab = 4 * window.getFont().getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (prefs.getInt("window." + name + ".screenwidth", 0) == screenSize.width) {
            int w = prefs.getInt("window." + name + ".width", -9999);
            int h = prefs.getInt("window." + name + ".height", -9999);
            if (w > 10 && h > 10 && w < screenSize.width && h < screenSize.height) {
                window.setSize(w, h);
            }
            if (parent != null) {
                int x = prefs.getInt("window." + name + ".rlocationx", -9999);
                int y = prefs.getInt("window." + name + ".rlocationy", -9999);
                if (x > -9999 && y > -9999) {
                    int newx = parent.getX() + x;
                    int newy = parent.getY() + y;
                    if (newx < 0) {
                        newx = 0;
                    }
                    if (newy < 0) {
                        newy = 0;
                    }
                    if (newx > screenSize.width - grab) {
                        newx = screenSize.width - grab;
                    }
                    if (newy > screenSize.height - grab) {
                        newy = screenSize.height - grab;
                    }
                    window.setLocation(newx, newy);
                }
            } else {
                int x = prefs.getInt("window." + name + ".locationx", -9999);
                int y = prefs.getInt("window." + name + ".locationy", -9999);
                if (x > -9999 && y > -9999) {
                    int newx = x;
                    int newy = y;
                    if (newx < 0) {
                        newx = 0;
                    }
                    if (newy < 0) {
                        newy = 0;
                    }
                    if (newx > screenSize.width - grab) {
                        newx = screenSize.width - grab;
                    }
                    if (newy > screenSize.height - grab) {
                        newy = screenSize.height - h;
                    }
                    window.setLocation(newx, newy);
                }
            }
        }
    }

    public void recordWindowSizePosition(Window window) {
        int x = window.getLocation().x;
        int y = window.getLocation().y;
        int w = window.getWidth();
        int h = window.getHeight();
        Container c = window.getParent();
        String name = window.getName();
        logger.log(Level.FINE, "storing position for {0}", name);
        if (name == null) {
            return;
        }
        Preferences prefs = Preferences.userNodeForPackage(WindowManager.class);
        logger.log(Level.FINE, "saving last location {0} {1} {2} {3}", new Object[]{x, y, h, w});
        prefs.putInt("window." + name + ".screenwidth", Toolkit.getDefaultToolkit().getScreenSize().width);
        if (c != null) {
            prefs.putInt("window." + name + ".rlocationx", x - c.getX());
            prefs.putInt("window." + name + ".rlocationy", y - c.getY());
        } else {
            prefs.putInt("window." + name + ".locationx", x);
            prefs.putInt("window." + name + ".locationy", y);
        }
        prefs.putInt("window." + name + ".width", w);
        prefs.putInt("window." + name + ".height", h);
    }

    public void showModalDialog(Dialog dia) {
        if (!dia.isModal()) {
            throw new IllegalArgumentException("dialog should be modal");
        }
        WindowManager.getInstance().recallWindowSizePosition(dia);
        dia.setVisible(true);
        WindowManager.getInstance().recordWindowSizePosition(dia);
    }

    public static int showConfirmDialog(Component parent, Object omessage, final String title, int optionType) {
        String name;
        if (optionType != 2 && optionType != 1) {
            throw new IllegalArgumentException("must be OK_CANCEL_OPTION or YES_NO_CANCEL_OPTION");
        }
        final Component message = !(omessage instanceof Component) ? new JLabel(omessage.toString()) : (Component)omessage;
        final Window p = parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
        final JDialog dia = new JDialog(p, Dialog.ModalityType.APPLICATION_MODAL);
        if (title.startsWith("Run Script ")) {
            String hash = String.format("%09d", title.substring(11).hashCode());
            name = "RunScript" + hash;
        } else {
            name = title.replaceAll("\\s", "");
        }
        dia.setName(name);
        dia.setLayout(new BorderLayout());
        final JPanel pc = new JPanel();
        final ArrayList<Integer> result = new ArrayList<Integer>(1);
        result.add(2);
        BoxLayout b = new BoxLayout(pc, 0);
        pc.setLayout(b);
        pc.add(Box.createGlue());
        if (optionType == 2) {
            pc.add(new JButton(new AbstractAction("Cancel"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent(e);
                    result.set(0, 2);
                    dia.setVisible(false);
                }
            }));
            pc.add(Box.createHorizontalStrut(7));
            pc.add(new JButton(new AbstractAction("Okay"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent(e);
                    result.set(0, 0);
                    dia.setVisible(false);
                }
            }));
        } else if (optionType == 1) {
            pc.add(new JButton(new AbstractAction("Yes"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent(e);
                    result.set(0, 0);
                    dia.setVisible(false);
                }
            }));
            pc.add(Box.createHorizontalStrut(7));
            pc.add(new JButton(new AbstractAction("No"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent(e);
                    result.set(0, 1);
                    dia.setVisible(false);
                }
            }));
            pc.add(Box.createHorizontalStrut(7));
            pc.add(new JButton(new AbstractAction("Cancel"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent(e);
                    result.set(0, 2);
                    dia.setVisible(false);
                }
            }));
        }
        pc.add(Box.createHorizontalStrut(7));
        Runnable run = new Runnable(){

            @Override
            public void run() {
                dia.setResizable(true);
                dia.add(message);
                dia.add((Component)pc, "South");
                dia.setTitle(title);
                dia.pack();
                dia.setLocationRelativeTo(p);
                WindowManager.getInstance().recallWindowSizePosition(dia);
                dia.setVisible(true);
                WindowManager.getInstance().recordWindowSizePosition(dia);
            }
        };
        if (EventQueue.isDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InterruptedException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            catch (InvocationTargetException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        return (Integer)result.get(0);
    }
}

