/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URLBuddy {
    private static final String ALPHA = "[A-Za-z]";
    private static final String DIGIT = "[0-9]";
    private static final String HEX = "[[0-9]A-F]";
    public static final Pattern VALID_QUERY_NAME = Pattern.compile("[A-Za-z][[A-Za-z][0-9]-_:.]*");
    public static final Pattern VALID_QUERY_VALUE = Pattern.compile("(?:[[A-Za-z][0-9]\\.\\-\\*\\_\\+]|\\%([[0-9]A-F][[0-9]A-F]))*");

    private URLBuddy() {
    }

    public static String encodeUTF8(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    public static String decodeUTF8(String str) {
        try {
            return URLDecoder.decode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    public static Map parseQueryString(String str) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] tokens = str.split("\\&");
        for (int i = 0; i < tokens.length; ++i) {
            int eqIndex = tokens[i].indexOf(61);
            if (eqIndex == -1) {
                URLBuddy.throwUnexpectedToken(tokens[i], str, "name/value pair");
            }
            String name = tokens[i].substring(0, eqIndex);
            String value = tokens[i].substring(eqIndex + 1);
            if (!URLBuddy.validName(name)) {
                URLBuddy.throwUnexpectedToken(name, str, "valid name");
            }
            if (!URLBuddy.validValue(value)) {
                URLBuddy.throwUnexpectedToken(name, str, "url encoded value");
            }
            value = URLBuddy.decodeUTF8(value);
            map.put(name, value);
        }
        return Collections.unmodifiableMap(map);
    }

    private static void throwUnexpectedToken(String token, String input, String expecting) {
        int index = input.indexOf(token);
        StringBuilder messageBuffer = new StringBuilder();
        messageBuffer.append("Error parsing query string: Expecting ");
        messageBuffer.append(expecting).append(", found '");
        messageBuffer.append(token).append("'\n");
        messageBuffer.append("Input: ").append(input).append('\n');
        messageBuffer.append("       ");
        for (int i = 0; i < index; ++i) {
            messageBuffer.append('.');
        }
        messageBuffer.append('^');
        throw new IllegalArgumentException(messageBuffer.toString());
    }

    public static String formatQueryString(Map m) {
        StringBuilder query = new StringBuilder();
        for (Map.Entry entry : m.entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!URLBuddy.validName(name)) {
                throw new IllegalArgumentException("'" + name + "' is not a valid query name.");
            }
            value = URLBuddy.encodeUTF8(value);
            query.append(name).append('=').append(value).append('&');
        }
        if (query.charAt(query.length() - 1) == '&') {
            query.deleteCharAt(query.length() - 1);
        }
        return query.toString();
    }

    private static boolean validName(String name) {
        Matcher m = VALID_QUERY_NAME.matcher(name);
        return m.matches();
    }

    private static boolean validValue(String value) {
        Matcher m = VALID_QUERY_VALUE.matcher(value);
        return m.matches();
    }
}

