/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.util.StringTokenizer;

public class LatexToGranny {
    private static final String STATE_OPEN = "open";
    private static final String STATE_CAROT = "carot";
    private static final String STATE_UNDERSCORE = "underscore";
    private static final String STATE_EXP = "exp";
    private static final String STATE_SUBSCRIPT = "subscript";
    private static final String STATE_BACKSLASH = "backslash";

    public static String latexToGranny(String latex) {
        String state = STATE_OPEN;
        StringTokenizer st = new StringTokenizer(latex, "^_\\{}+ ", true);
        StringBuilder build = new StringBuilder();
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (t.equals("^")) {
                state = STATE_CAROT;
                continue;
            }
            if (t.equals("_")) {
                state = STATE_UNDERSCORE;
                continue;
            }
            if (t.equals("\\")) {
                state = STATE_BACKSLASH;
                continue;
            }
            if (t.equals("{")) {
                if (state == STATE_CAROT) {
                    build.append("!U");
                    state = STATE_EXP;
                    continue;
                }
                if (state == STATE_UNDERSCORE) {
                    build.append("!D");
                    state = STATE_EXP;
                    continue;
                }
                build.append("{");
                state = STATE_OPEN;
                continue;
            }
            if (t.equals("}")) {
                if (state == STATE_EXP) {
                    build.append("!N");
                    state = STATE_OPEN;
                    continue;
                }
                if (state == STATE_SUBSCRIPT) {
                    build.append("!N");
                    state = STATE_OPEN;
                    continue;
                }
                build.append("}");
                state = STATE_OPEN;
                continue;
            }
            if (state == STATE_BACKSLASH) {
                build.append("&").append(LatexToGranny.lookupEntity(t)).append(";");
                state = STATE_OPEN;
                continue;
            }
            if (state == STATE_CAROT) {
                build.append("!U");
                build.append(t);
                build.append("!N");
                state = STATE_OPEN;
                continue;
            }
            build.append(t);
        }
        return build.toString();
    }

    public static boolean isLatex(String s) {
        return s.contains("^{") || s.contains("_{");
    }

    private static String lookupEntity(String ent) {
        return ent;
    }

    public static void main(String[] args) {
        String[] tests;
        for (String t : tests = new String[]{"\\rho^2 + 2\\Gamma_{ij}        ", "cm^{-3}", "nA/m^{2}", "\\rho^2 + 2\\Gamma_{ij}        ", "A^{B+C}", "\\sqrt{a + b}"}) {
            System.err.println(t);
            System.err.println(LatexToGranny.latexToGranny(t));
        }
    }
}

