/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import org.das2.util.LoggerManager;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ImageUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getJSONMetadata(File file) throws IOException {
        Logger logger = LoggerManager.getLogger("das2.util");
        try (ImageInputStream iis = ImageIO.createImageInputStream(file);){
            Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
            if (!readers.hasNext()) return null;
            ImageReader reader = readers.next();
            reader.setInput(iis, true);
            IIOMetadata metadata = reader.getImageMetadata(0);
            try {
                IIOMetadataNode n = (IIOMetadataNode)metadata.getAsTree("javax_imageio_png_1.0");
                NodeList nl = n.getElementsByTagName("tEXtEntry");
                int i = 0;
                while (i < nl.getLength()) {
                    Element e = (Element)nl.item(i);
                    String n3 = e.getAttribute("keyword");
                    if (n3.equals("plotInfo")) {
                        String string = e.getAttribute("value");
                        return string;
                    }
                    ++i;
                }
                return null;
            }
            catch (IllegalArgumentException ex) {
                logger.log(Level.FINE, ex.getMessage());
                String string = null;
                if (iis == null) return string;
                if (var3_4 != null) {
                    try {
                        iis.close();
                        return string;
                    }
                    catch (Throwable throwable) {
                        var3_4.addSuppressed(throwable);
                        return string;
                    }
                }
                iis.close();
                return string;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }
}

