/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EtchedBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;

public class DesktopColorChooserPanel
extends AbstractColorChooserPanel {
    JToggleButton b = new JToggleButton("Pick From Desktop");
    JLabel p = new JLabel("");
    JLabel l = new JLabel("");
    JLabel icon = new JLabel("");
    Color proposedColor = null;
    Palette palette = new Palette();
    boolean updating;
    Timer t = new Timer(100, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DesktopColorChooserPanel.this.updating) {
                DesktopColorChooserPanel.this.update();
            }
        }
    });
    private final WindowFocusListener windowFocusListener = new WindowFocusListener(){

        @Override
        public void windowGainedFocus(WindowEvent e) {
            DesktopColorChooserPanel.this.l.setText(DesktopColorChooserPanel.MSG_GRABBING);
            DesktopColorChooserPanel.this.l.setEnabled(true);
        }

        @Override
        public void windowLostFocus(WindowEvent e) {
            DesktopColorChooserPanel.this.l.setText("Focus lost, click here to resume selection with keyboard.");
            DesktopColorChooserPanel.this.l.setEnabled(false);
        }
    };
    protected static final String MSG_GRABBING = "<html>Grab colors from the desktop with the mouse.<br>S to select color, X to exit collection.";

    private void update() {
        try {
            PointerInfo info = MouseInfo.getPointerInfo();
            Point point = info.getLocation();
            this.l.setEnabled(true);
            Robot r = new Robot();
            BufferedImage im = r.createScreenCapture(new Rectangle(point.x - 20, point.y - 20, 40, 40));
            if (point.x < 20) {
                im.getGraphics().clipRect(0, 0, 20 - point.x, 40);
            }
            if (point.y < 20) {
                im.getGraphics().clipRect(0, 0, 40, 20 - point.y);
            }
            this.p.setIcon(new ImageIcon(im.getScaledInstance(80, 80, 2)));
            this.setProposedColor(new Color(im.getRGB(20, 20)));
            this.repaint();
        }
        catch (AWTException ex) {
            this.l.setText("Exception: " + ex.getMessage());
        }
    }

    private void setProposedColor(Color c) {
        this.proposedColor = c;
        this.icon.setIcon(DesktopColorChooserPanel.colorIcon(this.proposedColor, 32, 32));
    }

    private void stopPicking() {
        this.b.setSelected(false);
        this.b.setText("Pick From Desktop");
        this.updating = false;
    }

    @Override
    public void updateChooser() {
        this.t.setRepeats(true);
        this.t.start();
    }

    @Override
    protected void buildChooser() {
        this.setLayout(new BorderLayout());
        this.l.setText(MSG_GRABBING);
        this.l.setEnabled(false);
        this.add((Component)this.l, "North");
        this.p.setIcon(DesktopColorChooserPanel.colorIcon(Color.white, 80, 80));
        this.add((Component)this.p, "Center");
        this.icon.setIcon(DesktopColorChooserPanel.colorIcon(Color.white, 32, 32));
        this.add((Component)this.icon, "West");
        this.icon.setBorder(new EtchedBorder());
        this.b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DesktopColorChooserPanel.this.b.isSelected()) {
                    DesktopColorChooserPanel.this.b.setText("S to Select color, click here to Stop picking");
                    DesktopColorChooserPanel.this.updating = true;
                } else {
                    DesktopColorChooserPanel.this.stopPicking();
                }
            }
        });
        this.add((Component)this.b, "South");
        this.b.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if ((e.getKeyChar() == 's' || e.getKeyChar() == 'S') && DesktopColorChooserPanel.this.proposedColor != null) {
                    DesktopColorChooserPanel.this.getColorSelectionModel().setSelectedColor(DesktopColorChooserPanel.this.proposedColor);
                    DesktopColorChooserPanel.this.palette.addToPalette(DesktopColorChooserPanel.this.proposedColor);
                } else if (e.getKeyChar() == 'x' || e.getKeyChar() == 'X') {
                    DesktopColorChooserPanel.this.stopPicking();
                }
                super.keyPressed(e);
            }
        });
        this.add((Component)this.palette, "East");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Window w = SwingUtilities.getWindowAncestor(DesktopColorChooserPanel.this.b);
                if (w != null) {
                    w.addWindowFocusListener(DesktopColorChooserPanel.this.windowFocusListener);
                }
            }
        });
    }

    @Override
    public String getDisplayName() {
        return "Desktop Sampler";
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    public static Icon colorIcon(Color iconColor, int w, int h) {
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics g = image.getGraphics();
        if (iconColor.getAlpha() != 255) {
            for (int j = 0; j < 4; ++j) {
                for (int i = 0; i < 4; ++i) {
                    g.setColor((i - j) % 2 == 0 ? Color.GRAY : Color.WHITE);
                    g.fillRect(0 + i * 4, 0 + j * 4, 4, 4);
                }
            }
        }
        g.setColor(iconColor);
        g.fillRect(0, 0, w, h);
        return new ImageIcon(image);
    }

    public static String toHexString(Color c) {
        return "0x" + Integer.toHexString(c.getRGB()).substring(2).toUpperCase();
    }

    public static void main(String[] args) {
        JColorChooser custom = new JColorChooser();
        custom.addChooserPanel(new DesktopColorChooserPanel());
        if (0 == JOptionPane.showConfirmDialog(null, custom)) {
            System.err.println("c: " + custom.getColor());
        }
    }

    private class Palette
    extends JComponent {
        List<Color> palette = new ArrayList<Color>();
        private int PSIZE = 20;
        private int POFFX = 3;
        private int POFFY = 3;

        private Palette() {
            StringBuilder dp = new StringBuilder();
            dp.append(DesktopColorChooserPanel.toHexString(Color.WHITE)).append(",");
            dp.append(DesktopColorChooserPanel.toHexString(Color.RED.brighter())).append(",");
            dp.append(DesktopColorChooserPanel.toHexString(Color.GREEN.brighter())).append(",");
            dp.append(DesktopColorChooserPanel.toHexString(Color.BLUE.brighter())).append(",");
            dp.append(DesktopColorChooserPanel.toHexString(Color.GRAY)).append(",");
            dp.append(DesktopColorChooserPanel.toHexString(Color.RED)).append(",");
            dp.append(DesktopColorChooserPanel.toHexString(Color.GREEN)).append(",");
            dp.append(DesktopColorChooserPanel.toHexString(Color.BLUE)).append(",");
            dp.append(DesktopColorChooserPanel.toHexString(Color.BLACK)).append(",");
            dp.append(DesktopColorChooserPanel.toHexString(Color.RED.darker())).append(",");
            dp.append(DesktopColorChooserPanel.toHexString(Color.GREEN.darker())).append(",");
            dp.append(DesktopColorChooserPanel.toHexString(Color.BLUE.darker())).append(",");
            String ps = Preferences.userNodeForPackage(this.getClass()).get("palette", dp.toString());
            this.setPalette(ps);
            this.setBounds(0, 0, 2 * this.POFFX + 4 * this.PSIZE, 2 * this.POFFY + 3 * this.PSIZE);
            this.setMinimumSize(new Dimension(2 * this.POFFX + 4 * this.PSIZE, 2 * this.POFFY + 3 * this.PSIZE));
            this.setMaximumSize(this.getMinimumSize());
            this.setPreferredSize(this.getMinimumSize());
            this.setSize(this.getMinimumSize());
            this.setBorder(new EtchedBorder());
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int index = (e.getY() - Palette.this.POFFY) / Palette.this.PSIZE * 4 + (e.getX() - Palette.this.POFFX) / Palette.this.PSIZE;
                    if (index < Palette.this.palette.size()) {
                        Color c = Palette.this.palette.get(index);
                        DesktopColorChooserPanel.this.getColorSelectionModel().setSelectedColor(c);
                        DesktopColorChooserPanel.this.setProposedColor(c);
                    }
                }
            });
        }

        private void setPalette(String s) {
            String[] ss = s.split(",");
            for (int i = 0; i < 12; ++i) {
                this.palette.add(Color.decode(ss[i]));
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            for (int j = 0; j < 3; ++j) {
                for (int i = 0; i < 4; ++i) {
                    if (this.palette.size() <= j * 4 + i) continue;
                    g.setColor(this.palette.get(j * 4 + i));
                    Rectangle r = new Rectangle(this.POFFX + i * this.PSIZE, this.POFFY + j * this.PSIZE, this.PSIZE - 1, this.PSIZE - 1);
                    g.fillRect(r.x, r.y, r.width, r.height);
                }
            }
            super.paintComponent(g);
        }

        public void addToPalette(Color c) {
            this.palette.add(0, c);
            while (this.palette.size() > 12) {
                this.palette.remove(12);
            }
            StringBuilder dp = new StringBuilder();
            for (Color color : this.palette) {
                dp.append(DesktopColorChooserPanel.toHexString(color)).append(",");
            }
            Preferences.userNodeForPackage(this.getClass()).put("palette", dp.toString());
        }
    }
}

