/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class ArgumentList {
    private int nposition;
    private final String programName;
    private final String[] positionKeys;
    private final Map<String, String> values;
    private final Map<String, String> descriptions;
    private final Map<String, String> names;
    private final Map<String, String> reverseNames;
    private final Map<String, String> formUsed;
    private final Map<String, String> abbrevs;
    private final ArrayList<String[]> requireOneOfList;
    boolean allowUndefinedSwitch = false;
    private final String UNSPECIFIED = "__unspecified__";
    private final String REFERENCEWITHOUTVALUE = "__referencewithoutvalue__";
    private final String UNDEFINED_SWITCH = "__undefinedSwitch__";
    public final String FALSE = "__false__";
    public final String TRUE = "__true__";
    private static final Logger logger = Logger.getLogger("das2.util");

    public ArgumentList(String programName) {
        this.programName = programName;
        this.positionKeys = new String[10];
        this.values = new HashMap<String, String>();
        this.descriptions = new HashMap<String, String>();
        this.names = new LinkedHashMap<String, String>();
        this.reverseNames = new HashMap<String, String>();
        this.abbrevs = new HashMap<String, String>();
        this.formUsed = new HashMap<String, String>();
        this.requireOneOfList = new ArrayList();
    }

    public String getValue(String key) {
        if (this.values.containsKey(key)) {
            return this.values.get(key);
        }
        throw new IllegalArgumentException("No such key: " + key);
    }

    public static String makeFileReferenceAbsolute(String ref) {
        if (ref.startsWith("file://")) {
            ref = ref.substring(7);
        }
        if (ref.startsWith("file:")) {
            ref = ref.substring(5);
        }
        if (ref.startsWith("http://") || ref.startsWith("https://") || ref.startsWith("sftp://") || ref.startsWith("ftp://")) {
            throw new IllegalArgumentException("local file reference expected");
        }
        File ff = new File(ref);
        if (!ff.isAbsolute()) {
            return ff.getAbsolutePath();
        }
        return ref;
    }

    public Preferences getPreferences() {
        return new AbstractPreferences(null, ""){

            @Override
            protected void putSpi(String key, String value) {
                ArgumentList.this.formUsed.put(key, value);
                ArgumentList.this.values.put(key, value);
            }

            @Override
            protected String getSpi(String key) {
                if (ArgumentList.this.formUsed.containsKey(key)) {
                    return (String)ArgumentList.this.values.get(key);
                }
                return null;
            }

            @Override
            protected void removeSpi(String key) {
            }

            @Override
            protected void removeNodeSpi() throws BackingStoreException {
            }

            @Override
            protected String[] keysSpi() throws BackingStoreException {
                return ArgumentList.this.values.keySet().toArray(new String[ArgumentList.this.values.size()]);
            }

            @Override
            protected String[] childrenNamesSpi() throws BackingStoreException {
                return new String[0];
            }

            @Override
            protected AbstractPreferences childSpi(String name) {
                return null;
            }

            @Override
            protected void syncSpi() throws BackingStoreException {
            }

            @Override
            protected void flushSpi() throws BackingStoreException {
            }
        };
    }

    public boolean getBooleanValue(String key) {
        return this.values.get(key).equals(this.TRUE);
    }

    public void addPositionArgument(int position, String key, String description) {
        if (position > this.nposition) {
            throw new IllegalArgumentException("Position arguments must be specified 0,1,2,3: position=" + position);
        }
        if (position > this.positionKeys.length) {
            throw new IllegalArgumentException("Position too big: position=" + position);
        }
        this.nposition = position + 1;
        this.positionKeys[position] = key;
        this.descriptions.put(key, description);
        this.values.put(key, "__unspecified__");
    }

    public void requireOneOf(String[] keyNames) {
        this.requireOneOfList.add(keyNames);
    }

    public void addOptionalPositionArgument(int position, String key, String defaultValue, String description) {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        this.addPositionArgument(position, key, description);
        this.values.put(key, defaultValue);
        if (defaultValue == null) {
            // empty if block
        }
    }

    public void addSwitchArgument(String name, String abbrev, String key, String description) {
        if (abbrev == null && name == null) {
            throw new IllegalArgumentException("both abbrev and name are null, one must be specified");
        }
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        this.descriptions.put(key, description);
        if (abbrev != null) {
            if (this.abbrevs.containsKey(abbrev)) {
                throw new IllegalArgumentException("abbrev already used: " + abbrev);
            }
            this.abbrevs.put(abbrev, key);
        }
        if (name != null) {
            this.names.put(name, key);
            this.reverseNames.put(key, name);
        }
        this.values.put(key, "__unspecified__");
    }

    public void addOptionalSwitchArgument(String name, String abbrev, String key, String defaultValue, String description) {
        this.addSwitchArgument(name, abbrev, key, description);
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        this.values.put(key, defaultValue);
        if (defaultValue == null) {
            // empty if block
        }
    }

    public void addBooleanSwitchArgument(String name, String abbrev, String key, String description) {
        if (key.equals("commandLinePrefs")) {
            this.allowUndefinedSwitch = true;
        }
        this.addOptionalSwitchArgument(name, abbrev, key, "__false__", description);
    }

    public void printUsage() {
        String key;
        StringBuilder s = new StringBuilder("Usage: ");
        s.append(this.programName).append(" ");
        for (int i = 0; i < this.nposition; ++i) {
            String key2 = this.positionKeys[i];
            if (!this.UNSPECIFIED.equals(this.values.get(key2))) {
                s.append("[").append(this.descriptions.get(key2)).append("] ");
                continue;
            }
            s.append("<").append(this.descriptions.get(key2)).append("> ");
        }
        System.err.println(s.toString());
        Set<String> set = this.names.keySet();
        Iterator<String> i = set.iterator();
        HashMap<String, String> abbrevsCopy = new HashMap<String, String>(this.abbrevs);
        while (i.hasNext()) {
            String name = i.next();
            key = this.names.get(name);
            String abbrev = null;
            for (Map.Entry se : abbrevsCopy.entrySet()) {
                if (!((String)se.getValue()).equals(name)) continue;
                abbrev = (String)se.getKey();
                break;
            }
            if (abbrev != null) {
                abbrevsCopy.remove(abbrev);
            }
            s = new StringBuilder("  ");
            String description = this.descriptions.get(key);
            String value = this.values.get(key);
            if (abbrev == null) {
                if (!this.UNSPECIFIED.equals(value)) {
                    if (this.FALSE.equals(value) || this.TRUE.equals(value)) {
                        s.append(String.format("--%s  \t%s", name, description));
                    } else {
                        s.append(String.format("--%s= \t%s ", name, description));
                    }
                } else {
                    s.append(String.format("--%s= \t%s (required)", name, description));
                }
            } else if (!this.UNSPECIFIED.equals(value)) {
                if (this.FALSE.equals(value) || this.TRUE.equals(value)) {
                    s.append(String.format("-%s, --%s  \t%s", abbrev, name, description));
                } else {
                    s.append(String.format("-%s, --%s= \t%s ", abbrev, name, description));
                }
            } else {
                s.append(String.format("-%s, --%s= \t%s (required)", abbrev, name, description));
            }
            System.err.println(s.toString());
        }
        set = abbrevsCopy.keySet();
        for (String abbrev : set) {
            key = this.abbrevs.get(abbrev);
            s = new StringBuilder("  ");
            String description = this.descriptions.get(key);
            if (!this.UNSPECIFIED.equals(this.values.get(key))) {
                if (this.FALSE.equals(this.values.get(key)) || this.TRUE.equals(this.values.get(key))) {
                    s.append(String.format("-%s   \t%s", abbrev, description));
                } else {
                    s.append(String.format("-%s=%s ", abbrev, description));
                }
            } else {
                s.append(String.format("-%s=%s (required)", abbrev, description));
            }
            System.err.println(s);
        }
    }

    private void checkArgs() {
        boolean error = false;
        ArrayList<String> errorList = new ArrayList<String>();
        int i = 0;
        while (!error & i < this.nposition) {
            if (this.values.get(this.positionKeys[i]) == this.UNSPECIFIED) {
                errorList.add("Expected more positional arguments, only got " + i);
                error = true;
            }
            ++i;
        }
        if (!error) {
            for (Map.Entry<String, String> e : this.values.entrySet()) {
                String key = e.getKey();
                if (key == null) {
                    System.err.println("TODO: handle this case whereever it's coming from: key==null");
                    continue;
                }
                if (key.equals("help") || key.equals("--help")) {
                    this.printUsage();
                    System.exit(-1);
                }
                if (e.getValue() == this.UNSPECIFIED) {
                    errorList.add("Argument needed: --" + this.reverseNames.get(key));
                }
                if (e.getValue() == this.REFERENCEWITHOUTVALUE) {
                    errorList.add("Switch requires argument: " + this.formUsed.get(key));
                }
                if (e.getValue() != this.UNDEFINED_SWITCH || this.allowUndefinedSwitch) continue;
                errorList.add("Not a valid switch: " + this.formUsed.get(key));
            }
        }
        if (!error) {
            for (i = 0; i < this.requireOneOfList.size(); ++i) {
                String[] keys = this.requireOneOfList.get(i);
                boolean haveValue = false;
                for (int j = 0; j < keys.length; ++j) {
                    if (this.values.get(keys[j]).equals("__unspecified__") || this.values.get(keys[j]).equals("__undefinedSwitch__") || this.values.get(keys[j]).equals("__referencewithoutvalue__")) continue;
                    haveValue = true;
                }
                if (haveValue) continue;
                StringBuilder list = new StringBuilder(this.reverseNames.get(keys[0]));
                for (int j = 1; j < keys.length; ++j) {
                    list.append(", ").append(this.reverseNames.get(keys[j]));
                }
                errorList.add("One of the following needs to be specified: " + list.toString());
            }
        }
        if (errorList.size() > 0) {
            this.printUsage();
            System.err.println("");
            for (int ii = 0; ii < errorList.size(); ++ii) {
                System.err.println((String)errorList.get(ii));
            }
            System.exit(-1);
        }
    }

    public Map<String, String> getMap() {
        return new HashMap<String, String>(this.values);
    }

    public Map<String, String> getOptions() {
        HashMap<String, String> result = new HashMap<String, String>();
        List<String> exclude = Arrays.asList(this.positionKeys);
        for (Map.Entry<String, String> e : this.values.entrySet()) {
            String key = e.getKey();
            if (exclude.contains(key) || !this.formUsed.containsKey(key)) continue;
            result.put(key, e.getValue());
        }
        return result;
    }

    private int processSwitch(String[] args, int i) {
        String key;
        if (args[i].startsWith("--")) {
            String name = args[i].substring(2);
            if (name.indexOf(61) != -1) {
                name = name.substring(0, name.indexOf(61));
            }
            key = this.names.get(name);
        } else {
            String abbrev = args[i].substring(1);
            if (abbrev.indexOf(61) != -1) {
                abbrev = abbrev.substring(0, abbrev.indexOf(61));
            }
            key = this.abbrevs.get(abbrev);
        }
        if (key == null) {
            key = args[i];
            this.values.put(key, this.UNDEFINED_SWITCH);
            this.formUsed.put(key, args[i]);
            logger.log(Level.FINER, "undefined switch: {0}", key);
        } else {
            String value;
            this.formUsed.put(key, args[i]);
            if (this.values.get(key) == this.FALSE || this.values.get(key) == this.TRUE) {
                value = "__true__";
                if (args[i].indexOf(61) != -1) {
                    value = args[i].substring(args[i].indexOf(61) + 1);
                    if (value.equals("t") || value.equals("true") || value.equals("y") || value.equals("yes")) {
                        value = "__true__";
                    } else if (value.equals("f") || value.equals("false") || value.equals("n") || value.equals("no")) {
                        value = "__false__";
                    }
                }
                this.values.put(key, value);
            } else {
                if (args[i].indexOf(61) != -1) {
                    value = args[i].substring(args[i].indexOf(61) + 1);
                } else if (i + 1 < args.length && (args[i + 1].equals("-") || !args[i + 1].startsWith("-"))) {
                    value = args[i + 1];
                    ++i;
                } else {
                    value = this.REFERENCEWITHOUTVALUE;
                }
                if (value.startsWith("\"")) {
                    value = value.substring(1, value.length() - 2);
                }
                logger.log(Level.FINER, "switch key: {0}={1}", new Object[]{key, value});
                this.values.put(key, value);
            }
        }
        return i;
    }

    public void process(String[] args) {
        int i;
        StringBuilder sb = new StringBuilder();
        for (String arg : args) {
            sb.append(arg);
            sb.append(" ");
        }
        logger.log(Level.FINER, "args: {0}", sb.toString());
        int iposition = 0;
        for (i = 0; i < this.positionKeys.length; ++i) {
        }
        for (i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                i = this.processSwitch(args, i);
                continue;
            }
            String key = this.positionKeys[iposition];
            if (key == null) {
                System.err.println("\nWarning: position value found when position value was not expected: " + args[i] + "\n");
            }
            logger.log(Level.FINER, "position key: {0}={1}", new Object[]{key, args[i]});
            String vv = args[i];
            if (vv.startsWith("\"")) {
                vv = vv.substring(1, vv.length() - 2);
            }
            this.values.put(key, args[i]);
            ++iposition;
            this.formUsed.put(key, args[i]);
        }
        this.checkArgs();
    }

    public void printPrefsSettings() {
        String s = this.getPrefsSettings();
        System.err.println(s);
    }

    private String getPrefsSettings() {
        StringBuilder s = new StringBuilder("");
        s.append(this.programName).append(" ");
        for (int i = 0; i < this.nposition; ++i) {
            String key = this.positionKeys[i];
            if (this.formUsed.get(key) == null) continue;
            s.append(this.formUsed.get(key));
        }
        Set<Map.Entry<String, String>> entries = this.names.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String name = entry.getKey();
            String key = entry.getValue();
            String value = this.formUsed.get(key);
            if (value == null) continue;
            if (value.equals(this.TRUE)) {
                s.append("--").append(name);
            }
            if (value.equals(this.FALSE)) continue;
            s.append(value).append(" ");
        }
        return s.toString();
    }

    public void logPrefsSettings(Logger logger) {
        String s = this.getPrefsSettings();
        logger.log(Level.CONFIG, s);
    }
}

