/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.util.LoggerManager;
import org.das2.util.Splash;

public class AboutUtil {
    private static final Logger logger = LoggerManager.getLogger("das2");

    public static String getAboutHtml() {
        String dasVersion = Splash.getVersion();
        String javaVersion = System.getProperty("java.version");
        String buildTime = "???";
        URL buildURL = AboutUtil.class.getResource("/buildTime.txt");
        if (buildURL != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(buildURL.openStream()));){
                buildTime = reader.readLine();
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        String arch = System.getProperty("os.arch");
        DecimalFormat nf = new DecimalFormat("0.0");
        String mem = nf.format(Runtime.getRuntime().maxMemory() / 0x100000L);
        StringBuilder aboutContent = new StringBuilder("<html>release version: " + dasVersion + "\n<br>build time: " + buildTime + "\n<br>java version: " + javaVersion + "\n<br>max memory (Mb): " + mem + "\n<br>arch: " + arch + "\n<br>\n");
        try {
            List<String> bis = AboutUtil.getBuildInfos();
            for (String bi : bis) {
                aboutContent.append("<br> ").append(bi).append("\n");
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
        }
        aboutContent.append("</html>");
        return aboutContent.toString();
    }

    public static List<String> getBuildInfos() throws IOException {
        ClassLoader loader = AboutUtil.class.getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        Enumeration<URL> urls = loader.getResources("META-INF/build.txt");
        ArrayList<String> result = new ArrayList<String>();
        while (urls.hasMoreElements()) {
            String ch;
            URL url = urls.nextElement();
            String jar = url.toString();
            int i = jar.indexOf(".jar");
            int i0 = jar.lastIndexOf("/", i - 1);
            String name = i != -1 ? jar.substring(i0 + 1, i + 4) : jar.substring(6);
            Properties props = new Properties();
            props.load(url.openStream());
            String cvsTagName = props.getProperty("build.tag");
            String version = cvsTagName == null || cvsTagName.length() <= 9 ? "untagged_version" : cvsTagName.substring(6, cvsTagName.length() - 2);
            String userName = " " + props.getProperty("build.user.name");
            if (userName.trim().length() == 0) {
                userName = "";
            }
            if (result.contains(ch = name + ": " + version + "(" + props.getProperty("build.timestamp") + userName + ")")) continue;
            result.add(ch);
        }
        return result;
    }

    public static String getReleaseTag(Class clas) throws IOException {
        Properties props = new Properties();
        String clasFile = clas.getName().replaceAll("\\.", "/") + ".class";
        URL url = clas.getClassLoader().getResource(clasFile);
        if (url != null) {
            String surl = url.toString();
            url = new URL(new URL(surl.substring(0, surl.length() - clasFile.length())), "META-INF/build.txt");
            props.load(url.openStream());
            String tagName = props.getProperty("build.tag");
            if (tagName != null && tagName.trim().length() > 0) {
                return tagName;
            }
        }
        return "(dev)";
    }

    public static boolean isJreVersionAtLeast(String neededVersion) throws ParseException {
        String javaVersion = System.getProperty("java.version");
        Pattern p = Pattern.compile("(\\d+)\\.(\\d+)\\.\\d+\\_(\\d+)");
        Matcher mneeded = p.matcher(neededVersion);
        if (!mneeded.matches()) {
            throw new IllegalArgumentException("requested jre version must be of the form like 1.8.0_102 to match " + p.pattern());
        }
        Matcher mhave = p.matcher(javaVersion);
        if (mhave.matches()) {
            for (int i = 1; i < 4; ++i) {
                if (mneeded.group(i).compareTo(mhave.group(i)) > 0) {
                    return false;
                }
                if (mneeded.group(i).compareTo(mhave.group(i)) >= 0) continue;
                return true;
            }
        } else {
            throw new ParseException("JRE version is not identified properly: " + javaVersion, 0);
        }
        return neededVersion.equals(javaVersion);
    }

    public static String getReleaseTag() throws IOException {
        Enumeration<URL> urls = AboutUtil.class.getClassLoader().getResources("META-INF/build.txt");
        Properties props = new Properties();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            props.load(url.openStream());
            String tagName = props.getProperty("build.tag");
            if (tagName == null || tagName.trim().length() <= 0) continue;
            return tagName;
        }
        return "(dev)";
    }

    public static String getJenkinsURL() throws IOException {
        Enumeration<URL> urls = AboutUtil.class.getClassLoader().getResources("META-INF/build.txt");
        Properties props = new Properties();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            props.load(url.openStream());
            String tagName = props.getProperty("build.jenkinsURL");
            if (tagName == null || tagName.trim().length() <= 0) continue;
            return tagName;
        }
        return "";
    }
}

