/*
 * Decompiled with CFR 0.152.
 */
package org.das2.system;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedList;
import org.das2.components.DasProgressPanel;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.system.MonitorFactory;
import org.das2.util.monitor.ProgressMonitor;

public class DefaultMonitorFactory
implements MonitorFactory {
    private LinkedList<WeakReference<MonitorEntry>> monitors = new LinkedList();
    protected int size = 10;

    public synchronized int getSize() {
        return this.size;
    }

    public synchronized void setSize(int size) {
        this.size = size;
        while (this.monitors.size() > size) {
            this.monitors.remove(0);
        }
    }

    @Override
    public ProgressMonitor getMonitor(DasCanvas canvas, String label, String description) {
        DasProgressPanel result = DasProgressPanel.createComponentPanel(canvas, label);
        this.putMonitor(result, label, description);
        return result;
    }

    @Override
    public ProgressMonitor getMonitor(DasCanvasComponent context, String label, String description) {
        DasProgressPanel result = DasProgressPanel.createComponentPanel(context, label);
        this.putMonitor(result, label, description);
        return result;
    }

    @Override
    public ProgressMonitor getMonitor(String label, String description) {
        DasProgressPanel result = DasProgressPanel.createFramed(label);
        this.putMonitor(result, label, description);
        return result;
    }

    private synchronized void putMonitor(ProgressMonitor monitor, String label, String description) {
        this.monitors.add(new WeakReference<MonitorEntry>(new MonitorEntry(monitor, description)));
        while (this.monitors.size() > this.size) {
            this.monitors.remove(0);
        }
    }

    public synchronized MonitorEntry[] getMonitors() {
        ArrayList<MonitorEntry> result = new ArrayList<MonitorEntry>();
        for (WeakReference weakReference : this.monitors) {
            MonitorEntry e = (MonitorEntry)weakReference.get();
            if (e == null) continue;
            result.add(e);
        }
        return result.toArray(new MonitorEntry[result.size()]);
    }

    public MonitorEntry getMonitors(int i) {
        return this.getMonitors()[i];
    }

    public synchronized void setClear(boolean clear) {
        if (clear) {
            this.monitors.clear();
        }
    }

    public boolean isClear() {
        return false;
    }

    public static class MonitorEntry {
        ProgressMonitor monitor;
        String description;

        MonitorEntry(ProgressMonitor monitor, String description) {
            this.monitor = monitor;
            this.description = description;
        }

        public String toString() {
            String desc = this.description;
            if (desc.length() > 50) {
                desc = "..." + this.description.substring(this.description.length() - 50);
            }
            return String.valueOf(this.monitor) + " " + desc;
        }

        public ProgressMonitor getMonitor() {
            return this.monitor;
        }
    }
}

