/*
 * Decompiled with CFR 0.152.
 */
package org.das2.stream;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;

public enum PropertyType {
    DOUBLE("double"),
    BOOLEAN("boolean"),
    DOUBLE_ARRAY("doubleArray"),
    DATUM("Datum"),
    DATUM_RANGE("DatumRange"),
    INTEGER("int"),
    STRING("String"),
    TIME("Time"),
    TIME_RANGE("TimeRange");

    private static final Map map;
    private final String name;

    public static PropertyType getByName(String name) {
        PropertyType result = (PropertyType)((Object)map.get(name));
        if (result == null) {
            throw new IllegalArgumentException("Unrecognized property type: " + name);
        }
        return result;
    }

    private PropertyType(String name) {
        this.name = name;
    }

    public Object parse(String s) throws ParseException {
        switch (this) {
            case STRING: {
                return s;
            }
            case DOUBLE: {
                try {
                    return new Double(s);
                }
                catch (NumberFormatException nfe) {
                    throw new ParseException(nfe.getMessage(), 0);
                }
            }
            case BOOLEAN: {
                return Boolean.valueOf(s);
            }
            case INTEGER: {
                try {
                    return new Integer(s);
                }
                catch (NumberFormatException nfe) {
                    throw new ParseException(nfe.getMessage(), 0);
                }
            }
            case DOUBLE_ARRAY: {
                try {
                    String[] strings = s.split(",");
                    double[] doubles = new double[strings.length];
                    for (int i = 0; i < strings.length; ++i) {
                        doubles[i] = Double.parseDouble(strings[i]);
                    }
                    return doubles;
                }
                catch (NumberFormatException nfe) {
                    throw new ParseException(nfe.getMessage(), 0);
                }
            }
            case DATUM: {
                String[] split = s.split("\\s+");
                if (split.length == 1) {
                    return Units.dimensionless.parse(split[0]);
                }
                if (split.length == 2) {
                    Units units = Units.lookupUnits(split[1]);
                    return units.parse(split[0]);
                }
                StringBuilder bldr = new StringBuilder();
                for (int i = 1; i < split.length; ++i) {
                    if (i > 1) {
                        bldr.append(" ");
                    }
                    bldr.append(split[i]);
                }
                Units units = Units.lookupUnits(bldr.toString());
                return units.parse(split[0]);
            }
            case DATUM_RANGE: {
                String[] split = s.split("\\s+");
                if (split.length < 3) {
                    throw new IllegalArgumentException("Too few tokens in range: '" + s + "'");
                }
                if (!split[1].toLowerCase().equals("to")) {
                    throw new ParseException("Range '" + s + "' is missing the word 'to'", 0);
                }
                if (split.length == 3) {
                    Datum begin = Units.dimensionless.parse(split[0]);
                    Datum end = Units.dimensionless.parse(split[2]);
                    return new DatumRange(begin, end);
                }
                StringBuilder bldr = new StringBuilder();
                for (int i = 3; i < split.length; ++i) {
                    if (i > 3) {
                        bldr.append(" ");
                    }
                    bldr.append(split[i]);
                }
                Units units = Units.lookupUnits(bldr.toString());
                Datum begin = units.parse(split[0]);
                Datum end = units.parse(split[2]);
                return new DatumRange(begin, end);
            }
            case TIME: {
                return Units.us2000.parse(s);
            }
            case TIME_RANGE: {
                return DatumRangeUtil.parseTimeRange(s);
            }
        }
        throw new IllegalStateException("unrecognized name: " + this.name);
    }

    public String toString() {
        return this.name;
    }

    static {
        map = new HashMap();
        for (PropertyType t : PropertyType.values()) {
            map.put(t.name, t);
        }
    }
}

