/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qstream.filter;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.text.ParseException;
import org.das2.qstream.FormatStreamHandler;
import org.das2.qstream.PacketDescriptor;
import org.das2.qstream.StreamComment;
import org.das2.qstream.StreamDescriptor;
import org.das2.qstream.StreamException;
import org.das2.qstream.StreamHandler;
import org.das2.qstream.StreamTool;

public class StripDescriptors
implements StreamHandler {
    StreamHandler sink;
    int[] count = new int[100];

    @Override
    public void streamDescriptor(StreamDescriptor sd) throws StreamException {
        this.sink.streamDescriptor(sd);
    }

    @Override
    public void packetDescriptor(PacketDescriptor pd) throws StreamException {
        for (int i = 0; i < 100; ++i) {
            if (this.count[i] <= 0) continue;
            StreamComment sc = new StreamComment("log:INFO", String.format("%d type [%02d] packet%s", this.count[i], i, this.count[i] == 1 ? "s" : ""));
            this.sink.streamComment(sc);
            this.count[i] = 0;
        }
        this.sink.packetDescriptor(pd);
    }

    @Override
    public void packet(PacketDescriptor pd, ByteBuffer data) throws StreamException {
        int n = pd.getPacketId();
        this.count[n] = this.count[n] + 1;
    }

    @Override
    public void streamClosed(StreamDescriptor sd) throws StreamException {
        for (int i = 0; i < 100; ++i) {
            if (this.count[i] <= 0) continue;
            StreamComment sc = new StreamComment("log:INFO", String.format("%d type [%02d] packet%s", this.count[i], i, this.count[i] == 1 ? "s" : ""));
            this.sink.streamComment(sc);
            this.count[i] = 0;
        }
        this.sink.streamClosed(sd);
    }

    @Override
    public void streamException(StreamException se) throws StreamException {
        this.sink.streamException(se);
    }

    @Override
    public void streamComment(StreamComment sd) throws StreamException {
        this.sink.streamComment(sd);
    }

    public static void main(String[] args) throws StreamException, MalformedURLException, IOException, ParseException {
        InputStream in = System.in;
        FormatStreamHandler fsh = new FormatStreamHandler();
        fsh.setOutputStream(System.out);
        StripDescriptors filter = new StripDescriptors();
        filter.sink = fsh;
        StreamTool.readStream(Channels.newChannel(in), filter);
    }
}

