/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qstream.filter;

import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qstream.PacketDescriptor;
import org.das2.qstream.PlaneDescriptor;
import org.das2.qstream.SerializeDelegate;
import org.das2.qstream.SerializeRegistry;
import org.das2.qstream.StreamComment;
import org.das2.qstream.StreamDescriptor;
import org.das2.qstream.StreamException;
import org.das2.qstream.StreamHandler;
import org.das2.qstream.TransferType;
import org.das2.qstream.Util;
import org.das2.qstream.XMLSerializeDelegate;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class QDataSetsFilter
implements StreamHandler {
    protected static final Logger logger = Logger.getLogger("qstream");
    QDataSetSink sink;
    Map<String, Map<String, Object>> propsn = new HashMap<String, Map<String, Object>>();

    private static Map<String, Object> doProps(Node n, Map<String, Object> props) {
        if (props == null) {
            props = new LinkedHashMap<String, Object>();
        }
        if (n == null) {
            return props;
        }
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        try {
            NodeList odims = (NodeList)xpath.evaluate("property", n, XPathConstants.NODESET);
            for (int j = 0; j < odims.getLength(); ++j) {
                String stype;
                Element n2 = (Element)odims.item(j);
                String pname = n2.getAttribute("name");
                if (pname.equals("USER_PROPERTIES")) {
                    // empty if block
                }
                String svalue = n2.hasAttribute("value") ? n2.getAttribute("value") : n2.getTextContent();
                Element evalue = null;
                if (n2.hasAttribute("type")) {
                    stype = n2.getAttribute("type");
                } else {
                    evalue = Util.singletonChildElement(n2);
                    stype = evalue.getTagName();
                }
                if (stype.equals("qdataset")) {
                    if (!pname.equals("DEPEND_0")) continue;
                    props.put("DEPENDNAME_0", svalue);
                    continue;
                }
                SerializeDelegate delegate = SerializeRegistry.getByName(stype);
                if (delegate == null) {
                    logger.log(Level.SEVERE, "!!! No delegate found for \"{0}\"", stype);
                    continue;
                }
                try {
                    Object oval = evalue != null && delegate instanceof XMLSerializeDelegate ? ((XMLSerializeDelegate)((Object)delegate)).xmlParse(evalue) : delegate.parse(stype, svalue);
                    props.put(pname, oval);
                    continue;
                }
                catch (ParseException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        }
        catch (XPathExpressionException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return props;
    }

    @Override
    public void streamDescriptor(StreamDescriptor sd) throws StreamException {
        this.sink.streamDescriptor(sd);
    }

    @Override
    public void packetDescriptor(PacketDescriptor pd) throws StreamException {
        this.sink.packetDescriptor(pd);
        Element ele = pd.getDomElement();
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        try {
            NodeList odims = (NodeList)xpath.evaluate("/packet/qdataset", ele, XPathConstants.NODESET);
            List<PlaneDescriptor> pds = pd.getPlanes();
            for (int j = 0; j < odims.getLength(); ++j) {
                Element ds = (Element)odims.item(j);
                XPathExpression exprp = xpath.compile("properties");
                Node nprops = (Node)exprp.evaluate(ds, XPathConstants.NODE);
                Map<String, Object> props = QDataSetsFilter.doProps(nprops, null);
                String id = ds.getAttribute("id");
                this.propsn.put(id, props);
                XPathExpression exprv = xpath.compile("values/@values");
                Node values = (Node)exprv.evaluate(ds, XPathConstants.NODE);
                if (values == null) continue;
                PlaneDescriptor planed = pds.get(j);
                String svalues = values.getTextContent();
                String[] ss = svalues.split(",");
                double[] dd = new double[ss.length];
                for (int i = 0; i < ss.length; ++i) {
                    dd[i] = Double.parseDouble(ss[i]);
                }
                DDataSet mds = planed.getQube().length == 0 ? DDataSet.wrap(dd) : DDataSet.wrap(dd, planed.getQube());
                DataSetUtil.putProperties(props, mds);
                this.sink.packetData(pd, planed, mds);
            }
        }
        catch (XPathExpressionException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void packet(PacketDescriptor pd, ByteBuffer data) throws StreamException {
        this.sink.packet(pd, data);
        for (PlaneDescriptor planed : pd.getPlanes()) {
            TransferType tt = planed.getType();
            int len = pd.sizeBytes();
            double[] dd = new double[len];
            for (int i = 0; i < planed.getElements(); ++i) {
                double bb;
                dd[i] = bb = tt.read(data);
            }
            DDataSet ds = DDataSet.wrap(dd, planed.getQube());
            Map<String, Object> props = this.propsn.get(planed.getName());
            if (props != null) {
                DataSetUtil.putProperties(props, ds);
            }
            this.sink.packetData(pd, planed, ds);
        }
    }

    @Override
    public void streamClosed(StreamDescriptor sd) throws StreamException {
        this.sink.streamClosed(sd);
    }

    @Override
    public void streamException(StreamException se) throws StreamException {
        this.sink.streamException(se);
    }

    @Override
    public void streamComment(StreamComment se) throws StreamException {
        this.sink.streamComment(se);
    }

    public void setSink(QDataSetSink sink) {
        this.sink = sink;
    }

    public static class QDataSetSink
    implements StreamHandler {
        @Override
        public void streamDescriptor(StreamDescriptor sd) throws StreamException {
        }

        @Override
        public void packetDescriptor(PacketDescriptor pd) throws StreamException {
        }

        @Override
        public void packet(PacketDescriptor pd, ByteBuffer data) throws StreamException {
        }

        @Override
        public void streamClosed(StreamDescriptor sd) throws StreamException {
        }

        @Override
        public void streamException(StreamException se) throws StreamException {
        }

        @Override
        public void streamComment(StreamComment se) throws StreamException {
        }

        public void packetData(PacketDescriptor pd, PlaneDescriptor pld, QDataSet ds) {
        }
    }
}

