/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qstream;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.das2.qstream.Descriptor;
import org.das2.qstream.PacketDescriptor;
import org.das2.qstream.PlaneDescriptor;
import org.das2.qstream.StreamException;
import org.das2.qstream.StreamTool;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StreamDescriptor
implements Descriptor {
    Map<Integer, Descriptor> descriptors;
    Map<Descriptor, Integer> invPackets;
    Map<Descriptor, Document> documents;
    DocumentBuilderFactory factory;
    private Element element;
    int sizeBytes;
    protected ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    protected boolean asciiTypes = false;

    public StreamDescriptor(DocumentBuilderFactory factory) {
        this();
        this.factory = factory;
    }

    StreamDescriptor(Element element) {
        this();
    }

    private StreamDescriptor() {
        this.descriptors = new HashMap<Integer, Descriptor>();
        this.invPackets = new HashMap<Descriptor, Integer>();
        this.documents = new HashMap<Descriptor, Document>();
    }

    public synchronized void addDescriptor(Descriptor pd) {
        int found = -1;
        if (this.invPackets.get(pd) != null) {
            return;
        }
        for (int i = 0; i < 100; ++i) {
            if (this.descriptors.get(i) != null) continue;
            found = i;
            break;
        }
        if (found == -1) {
            throw new IllegalArgumentException("ran out of numbers, use retire to free");
        }
        this.addDescriptor(pd, found);
    }

    public synchronized boolean hasDescriptor(Descriptor pd0, int descriptorId) {
        if (pd0 instanceof PacketDescriptor) {
            PacketDescriptor ppd0 = (PacketDescriptor)pd0;
            Descriptor o = this.descriptors.get(descriptorId);
            if (o instanceof PacketDescriptor) {
                PacketDescriptor ppd1 = (PacketDescriptor)o;
                List<PlaneDescriptor> planed0 = ppd0.getPlanes();
                List<PlaneDescriptor> planed1 = ppd1.getPlanes();
                if (planed0.size() == planed1.size()) {
                    boolean same = true;
                    for (int i = 0; i < planed1.size(); ++i) {
                        if (planed0.get(i).getName().equals(planed1.get(i).getName())) continue;
                        same = false;
                    }
                    if (same) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public synchronized void addDescriptor(Descriptor pd, int descriptorId) {
        this.descriptors.put(descriptorId, pd);
        this.invPackets.put(pd, descriptorId);
    }

    public synchronized int descriptorId(Descriptor pd) {
        if (pd == this) {
            return 0;
        }
        Integer i = this.invPackets.get(pd);
        if (i == null) {
            throw new IllegalArgumentException("no descriptor ID found for descriptor: " + pd);
        }
        return i;
    }

    public synchronized void retireDescriptor(Descriptor pd) {
        int i = this.invPackets.get(pd);
        this.invPackets.remove(pd);
        this.descriptors.remove(i);
    }

    public void send(Descriptor pd, WritableByteChannel out) throws StreamException, IOException {
        Document document = this.documents.get(pd);
        Element ele = pd.getDomElement();
        if (ele == null) {
            throw new IllegalArgumentException("Descriptor contains no domElement, cannot be sent");
        }
        document.appendChild(document.importNode(ele, true));
        ByteArrayOutputStream pdout = new ByteArrayOutputStream(1000);
        OutputStreamWriter writer = new OutputStreamWriter(pdout);
        StreamTool.formatHeader(document, writer);
        String packetTag = String.format("[%02d]", this.descriptorId(pd));
        out.write(ByteBuffer.wrap(packetTag.getBytes()));
        if (pdout.size() > 999999) {
            throw new IllegalArgumentException("packet header is longer than can be formatted to a packet header (longer than 999999 bytes).");
        }
        out.write(ByteBuffer.wrap(String.format("%06d", pdout.size()).getBytes()));
        out.write(ByteBuffer.wrap(pdout.toByteArray()));
    }

    public Document newDocument(Descriptor descriptor) throws ParserConfigurationException {
        Document document = this.factory.newDocumentBuilder().newDocument();
        this.documents.put(descriptor, document);
        return document;
    }

    String getCompression() {
        return "none";
    }

    public void setDomElement(Element element) {
        this.element = element;
    }

    @Override
    public Element getDomElement() {
        return this.element;
    }

    int sizeBytes() {
        return this.sizeBytes;
    }

    void setSizeBytes(int size) {
        this.sizeBytes = size;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public boolean isAsciiTypes() {
        return this.asciiTypes;
    }

    public void setAsciiTypes(boolean asciiTypes) {
        this.asciiTypes = asciiTypes;
    }

    void setFactory(DocumentBuilderFactory newInstance) {
        this.factory = newInstance;
    }
}

