/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qstream;

import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.qds.DRank0DataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.RankZeroDataSet;
import org.das2.qstream.SerializeDelegate;
import org.das2.qstream.SerializeRegistry;

public class Rank0DataSetSerializeDelegate
implements SerializeDelegate {
    @Override
    public String format(Object o) {
        Datum d;
        String svalue;
        QDataSet ds = (QDataSet)o;
        if (ds.rank() > 0) {
            throw new IllegalArgumentException("rank>0 in Rank0DataSetSerializeDelegate");
        }
        Map<String, Object> props = DataSetUtil.getProperties(ds);
        Units u = (Units)ds.property("UNITS");
        if (u == null) {
            u = Units.dimensionless;
        }
        if ((svalue = (d = DataSetUtil.asDatum(ds)).getFormatter().format(d, u)).contains(" ")) {
            throw new RuntimeException("formatted value contains string");
        }
        StringBuilder sb = new StringBuilder(d.getFormatter().format(d, d.getUnits()));
        for (Map.Entry<String, Object> e : props.entrySet()) {
            Object value = e.getValue();
            SerializeDelegate sd = SerializeRegistry.getDelegate(value.getClass());
            if (sd == null || value instanceof RankZeroDataSet) continue;
            sb.append(" ").append(sd.typeId(value.getClass())).append(":").append(e.getKey()).append("=").append(sd.format(value));
        }
        return sb.toString();
    }

    @Override
    public Object parse(String typeId, String s) throws ParseException {
        int i = (s = s.trim()).indexOf(" ");
        if (i == -1) {
            return DataSetUtil.asDataSet(Double.parseDouble(s));
        }
        String svalue = s.substring(0, i);
        String smeta = s.substring(i + 1);
        Pattern p = Pattern.compile("\\s*(\\S+)\\:([A-Z]+)=(\\S+)");
        Matcher m = p.matcher(smeta);
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        while (m.find()) {
            String proptype = m.group(1);
            String propname = m.group(2);
            String propsvalue = m.group(3);
            SerializeDelegate sd = SerializeRegistry.getByName(proptype);
            Object value = sd.parse(proptype, propsvalue);
            props.put(propname, value);
        }
        Units u = (Units)props.get("UNITS");
        if (u == null) {
            u = Units.dimensionless;
        }
        DRank0DataSet result = u == Units.dimensionless ? DRank0DataSet.create(u.parse(svalue)) : DRank0DataSet.create(u.parse(svalue).doubleValue(u), u);
        for (Map.Entry e : props.entrySet()) {
            if (!((String)e.getKey()).equals("UNITS")) continue;
            result.putProperty((String)e.getKey(), e.getValue());
        }
        return result;
    }

    @Override
    public String typeId(Class clas) {
        return "rank0dataset";
    }
}

