/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qstream;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.LoggerManager;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.TimeDatumFormatter;
import org.das2.qds.DataSetOps;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qstream.DoubleTransferType;
import org.das2.qstream.FloatTransferType;
import org.das2.qstream.TransferType;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

public class QdsToD2sStream {
    public static final String FORMAT_2_2 = "2.2";
    public static final String FORMAT_2_3_BASIC = "2.3-basic";
    public static final String FORMAT_2_3_GENERAL = "2.3-general";
    public static final String[] formats = new String[]{"2.2", "2.3-basic"};
    public static final int DEFAUT_FRAC_SEC = 3;
    public static final int DEFAUT_SIG_DIGIT = 5;
    private boolean bDas23;
    private String VERSION;
    private String FORMAT;
    private String DATASET;
    private String SHAPE;
    private String JOINID;
    private String X;
    private String Y;
    private String Y_SCAN;
    private String Z;
    private String Z_SCAN;
    private String W;
    private String W_SCAN;
    private String X_REF;
    private String Y_REF;
    private String Z_REF;
    private String Xoffsets;
    private String Yoffsets;
    private String Zoffsets;
    private String Offset0;
    private String Delta;
    private static final Logger log = LoggerManager.getLogger("qstream");
    int nSigDigit = 5;
    int nSecDigit = 3;
    boolean bBinary;
    private List<String> lHdrsSent = new ArrayList<String>();
    private static final int MAX_HDRS = 100;
    private static final int X_EL = 1;
    private static final int XREF_EL = 2;
    private static final int YREF_EL = 3;
    private static final int Y_EL = 4;
    private static final int Z_EL = 5;
    private static final int YSCAN_EL = 6;
    private static final String[] aStdPlaneProps = new String[]{"BIN_MIN", "BIN_MAX", "BIN_MINUS", "BIN_PLUS"};

    public QdsToD2sStream(String version) {
        this.bDas23 = version.equals(FORMAT_2_3_BASIC);
        this.bBinary = true;
        this._setNames(this.bDas23);
    }

    public QdsToD2sStream(String version, int genSigDigits, int fracSecDigits) {
        this.bBinary = false;
        this.bDas23 = version.equals(FORMAT_2_3_BASIC);
        this._setNames(this.bDas23);
        if (genSigDigits > 1) {
            if (genSigDigits > 16) {
                throw new IllegalArgumentException(String.format("Number of significant digits in the output must be between 2 and 17, received %d", genSigDigits));
            }
            this.nSigDigit = genSigDigits;
        }
        if (fracSecDigits >= 0) {
            if (fracSecDigits < 0 || fracSecDigits > 12) {
                throw new IllegalArgumentException(String.format("Number of fractional seconds digits in the output must be between 0 and 12 inclusive, received %d", fracSecDigits));
            }
            this.nSecDigit = fracSecDigits;
        }
    }

    final void _setNames(boolean _bDas23) {
        if (_bDas23) {
            this.VERSION = FORMAT_2_3_BASIC;
            this.FORMAT = "format";
            this.DATASET = "dataset";
            this.SHAPE = "shape";
            this.JOINID = "group";
            this.X_REF = "Xref";
            this.Xoffsets = "xOffsets";
            this.Y_REF = "Yref";
            this.Yoffsets = "yOffsets";
            this.Z_REF = "Zref";
            this.Zoffsets = "zOffsets";
            this.Delta = "delta";
            this.Offset0 = "offset0";
            this.X = "X";
            this.Y = "Y_of_X";
            this.Y_SCAN = "multiY_of_X";
            this.Z = "Z_of_XY";
            this.Z_SCAN = "multiZ_of_XY";
            this.W = "W_of_XYZ";
            this.W_SCAN = "multiW_of_XYZ";
        } else {
            this.VERSION = FORMAT_2_2;
            this.FORMAT = "type";
            this.DATASET = "packet";
            this.SHAPE = "nitems";
            this.JOINID = "name";
            this.X_REF = "x";
            this.Xoffsets = "yTags";
            this.Y_REF = "y";
            this.Yoffsets = "yTags";
            this.Delta = "yTagInterval";
            this.Offset0 = "yTagMin";
            this.X = "X";
            this.Y = "y";
            this.Y_SCAN = "yscan";
            this.Z = "z";
            this.Z_SCAN = "yscan";
            this.W = null;
            this.W_SCAN = null;
        }
    }

    public boolean canWrite(QDataSet qds) {
        int nTypes = 0;
        if (SemanticOps.isJoin(qds)) {
            for (int i = 0; i < qds.length(); ++i) {
                if (!this.canWriteNonJoin(DataSetOps.slice0(qds, i))) {
                    return false;
                }
                if (nTypes++ <= 99) continue;
                return false;
            }
            return true;
        }
        return this.canWriteNonJoin(qds);
    }

    public boolean write(QDataSet qds, OutputStream os) throws IOException {
        String sPktHdr;
        PacketXferInfo pi;
        int i;
        if (!this.canWrite(qds)) {
            return false;
        }
        ArrayList<String> lHdrsToSend = new ArrayList<String>();
        if (this.lHdrsSent.isEmpty()) {
            Document doc = this.makeStreamHdr(qds);
            if (doc == null) {
                return false;
            }
            lHdrsToSend.add(this.xmlDocToStr(doc));
        }
        ArrayList<PacketXferInfo> lPi = new ArrayList<PacketXferInfo>();
        if (SemanticOps.isJoin(qds)) {
            for (i = 0; i < qds.length(); ++i) {
                MutablePropertyDataSet ds = DataSetOps.slice0(qds, i);
                pi = this.makePktHdr(ds);
                if (pi == null) {
                    return false;
                }
                lPi.add(pi);
                sPktHdr = this.xmlDocToStr(pi.doc);
                if (this.lHdrsSent.contains(sPktHdr)) continue;
                lHdrsToSend.add(sPktHdr);
            }
        } else {
            pi = this.makePktHdr(qds);
            if (pi == null) {
                return false;
            }
            lPi.add(pi);
            sPktHdr = this.xmlDocToStr(pi.doc);
            if (!this.lHdrsSent.contains(sPktHdr)) {
                lHdrsToSend.add(sPktHdr);
            }
        }
        for (i = 0; i < lHdrsToSend.size(); ++i) {
            int iPktId = this.lHdrsSent.size();
            if (iPktId >= 100) {
                return false;
            }
            this.writeHeader(os, iPktId, (String)lHdrsToSend.get(i));
            this.lHdrsSent.add((String)lHdrsToSend.get(i));
        }
        for (PacketXferInfo pktinfo : lPi) {
            sPktHdr = this.xmlDocToStr(pktinfo.doc);
            int iPktId = this.lHdrsSent.indexOf(sPktHdr);
            this.writeData(iPktId, pktinfo, os);
        }
        return true;
    }

    protected boolean canWriteNonJoin(QDataSet qds) {
        String[] lTmp;
        int i;
        QDataSet dsDep0 = null;
        QDataSet dsDep1 = null;
        if (qds.property("BUNDLE_1") != null && (i = 0) < qds.length()) {
            QDataSet dsDep;
            MutablePropertyDataSet ds = DataSetOps.slice0(qds, i);
            if (ds.property("BUNDLE_1") != null) {
                return false;
            }
            if (ds.rank() > 2) {
                return false;
            }
            if (ds.rank() > 1) {
                dsDep = (QDataSet)ds.property("DEPEND_1");
                if (dsDep != null) {
                    if (dsDep1 == null) {
                        dsDep1 = dsDep;
                    } else if (dsDep != dsDep1) {
                        return false;
                    }
                }
                if (dsDep.rank() > 1) {
                    return false;
                }
            }
            if ((dsDep = (QDataSet)ds.property("DEPEND_0")) != null) {
                if (dsDep0 == null) {
                    dsDep0 = dsDep;
                } else if (dsDep != dsDep0) {
                    return false;
                }
            }
            return true;
        }
        if (qds.rank() > 2) {
            return false;
        }
        QDataSet dsDep = (QDataSet)qds.property("DEPEND_1");
        if (dsDep != null && dsDep.rank() > 1) {
            return false;
        }
        for (String s : lTmp = new String[]{"BUNDLE_0", "BUNDLE_2", "BUNDLE_3"}) {
            if (qds.property(s) == null) continue;
            return false;
        }
        return true;
    }

    private boolean _stripDotProps(QDataSet qds) {
        if (qds.property("BUNDLE_1") != null) {
            for (int i = 0; i < qds.length(0); ++i) {
                MutablePropertyDataSet ds = DataSetOps.slice1(qds, i);
                if (ds.rank() == 1) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private Document makeStreamHdr(QDataSet qds) {
        Document doc = this.newXmlDoc();
        Element stream = doc.createElement("stream");
        stream.setAttribute("version", this.VERSION);
        Element props = doc.createElement("properties");
        int nProps = 0;
        nProps += this.addStrProp(props, qds, "TITLE", "title");
        nProps += this.addStrProp(props, qds, "DESCRIPTION", "summary");
        nProps += this.addStrProp(props, qds, "RENDER_TYPE", "renderer");
        String sAxis = QdsToD2sStream.qd2DataAxis(qds);
        if (sAxis == null) {
            return null;
        }
        nProps += this.addSimpleProps(props, qds, sAxis);
        Map dUser = (Map)qds.property("USER_PROPERTIES");
        boolean bStripDot = this._stripDotProps(qds);
        if (dUser != null) {
            nProps += this.addPropsFromMap(props, dUser, bStripDot);
        }
        if (nProps > 0) {
            stream.appendChild(props);
        }
        doc.appendChild(stream);
        return doc;
    }

    private PacketXferInfo makePktHdr(QDataSet qds) {
        String sFallBackSrcName;
        QDataSet dep0;
        ArrayList<QdsXferInfo> lDsXfer = new ArrayList<QdsXferInfo>();
        assert (!SemanticOps.isJoin(qds));
        ArrayList<QDataSet> lDsIn = new ArrayList<QDataSet>();
        ArrayList<QDataSet> lDsOut = new ArrayList<QDataSet>();
        if (SemanticOps.isBundle(qds)) {
            dep0 = (QDataSet)qds.property("DEPEND_0");
            if (dep0 != null) {
                lDsXfer.add(new QdsXferInfo(dep0, this.bBinary, this.nSigDigit, this.nSecDigit, 2));
            }
            for (int i = 0; i < qds.length(0); ++i) {
                lDsIn.add(DataSetOps.slice1(qds, i));
            }
        } else {
            lDsIn.add(qds);
        }
        for (QDataSet ds : lDsIn) {
            dep0 = (QDataSet)ds.property("DEPEND_0");
            if (dep0 != null) {
                if (lDsXfer.isEmpty()) {
                    lDsXfer.add(new QdsXferInfo(dep0, this.bBinary, this.nSigDigit, this.nSecDigit, 2));
                } else if (dep0 != ((QdsXferInfo)lDsXfer.get((int)0)).qds) {
                    log.warning("Multiple independent depend_0 datasets in bundle");
                    return null;
                }
                lDsOut.add(ds);
                continue;
            }
            if (!lDsXfer.isEmpty() || ds.rank() != 1) continue;
            lDsXfer.add(new QdsXferInfo(ds, this.bBinary, this.nSigDigit, this.nSecDigit, 1));
        }
        lDsIn = lDsOut;
        lDsOut = new ArrayList();
        QDataSet dsZ = null;
        MutablePropertyDataSet dsSubZ = null;
        int nYs = 0;
        int nZs = 0;
        for (QDataSet ds : lDsIn) {
            if (ds.rank() > 1) {
                lDsOut.add(ds);
                continue;
            }
            assert (ds.property("DEPEND_0") != null);
            if (dsZ != null) {
                log.warning("Multiple Y planes encountered in X,Y,Z dataset");
                return null;
            }
            sFallBackSrcName = String.format("Y_%d", nYs);
            int nNewPlanes = this._addPlaneWithStats(lDsXfer, ds, this.nSigDigit, this.nSecDigit, 4, sFallBackSrcName);
            if (nNewPlanes == 0) {
                return null;
            }
            nYs += nNewPlanes;
            dsZ = (QDataSet)ds.property("PLANE_0");
            if (dsZ == null) continue;
            if (SemanticOps.isBundle(dsZ)) {
                for (int i = 0; i < dsZ.length(); ++i) {
                    dsSubZ = DataSetOps.slice0(dsZ, i);
                    nNewPlanes = this._addPlaneWithStats(lDsXfer, dsSubZ, this.nSigDigit, this.nSecDigit, 5, sFallBackSrcName = String.format("Z_%d", nZs));
                    if (nNewPlanes == 0) {
                        return null;
                    }
                    nZs += nNewPlanes;
                }
                continue;
            }
            sFallBackSrcName = String.format("Z_%d", nZs);
            nNewPlanes = this._addPlaneWithStats(lDsXfer, dsZ, this.nSigDigit, this.nSecDigit, 5, sFallBackSrcName);
            if (nNewPlanes == 0) {
                return null;
            }
            nZs += nNewPlanes;
        }
        lDsIn = lDsOut;
        QDataSet dsYTags = null;
        int nYScans = 0;
        for (QDataSet ds : lDsIn) {
            int nNewPlanes;
            if (ds.rank() > 2) {
                assert (false);
                return null;
            }
            if (dsZ != null) {
                log.warning("YScan planes not allowed in the same packets as Z planes");
                return null;
            }
            QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
            if (dep1 != null) {
                if (dsYTags == null) {
                    dsYTags = dep1;
                } else if (dsYTags != dep1) {
                    log.warning("Independent Y values for different rank-2  datasets in the same bundle");
                    return null;
                }
            }
            if ((nNewPlanes = this._addPlaneWithStats(lDsXfer, ds, this.nSigDigit, this.nSecDigit, 6, sFallBackSrcName = String.format("%s_%d", this.bDas23 ? "multiZ" : "YScan", nYScans))) < 1) {
                return null;
            }
            nYScans += nNewPlanes;
        }
        Document doc = this._makePktHdrFromXfer(lDsXfer, dsYTags);
        if (doc == null) {
            return null;
        }
        return new PacketXferInfo(doc, lDsXfer);
    }

    int _addPlaneWithStats(List<QdsXferInfo> lDsXfer, QDataSet dsPrimary, int nSigDigit, int nSecDigit, int nPlane, String sFallBackSrc) {
        QdsXferInfo xferPrimary = new QdsXferInfo(dsPrimary, this.bBinary, nSigDigit, nSecDigit, nPlane);
        lDsXfer.add(xferPrimary);
        Map dUserProps = (Map)dsPrimary.property("USER_PROPERTIES");
        String sSource = null;
        if (!this.bDas23) {
            if (dUserProps != null) {
                if (dUserProps.containsKey("source")) {
                    sSource = (String)dUserProps.get("source");
                }
            } else {
                sSource = (String)dsPrimary.property("NAME");
                if (sSource == null) {
                    sSource = sFallBackSrc;
                }
            }
        }
        String sErr = "Statistics dataset is a different rank than the average dataset";
        int nStatsPlanes = 0;
        for (String sProp : aStdPlaneProps) {
            QDataSet dsStats = (QDataSet)dsPrimary.property(sProp);
            if (dsStats == null) continue;
            if (dsStats.rank() != dsPrimary.rank()) {
                log.warning(sErr);
                return 0;
            }
            if (this.bDas23) {
                xferPrimary.dCoSets.put(sProp, dsStats);
                continue;
            }
            lDsXfer.add(new QdsXferInfo(dsStats, this.bBinary, nSigDigit, nSecDigit, nPlane, sSource, sProp));
            ++nStatsPlanes;
        }
        if (!this.bDas23 && nStatsPlanes > 0) {
            xferPrimary.sSource = sSource;
        }
        return 1 + nStatsPlanes;
    }

    Document _makePktHdrFromXfer(List<QdsXferInfo> lDsXfer, QDataSet dsYTags) {
        Document doc = this.newXmlDoc();
        Element elPkt = doc.createElement(this.DATASET);
        if (this.bDas23) {
            elPkt.setAttribute("streamBy", "Xslice");
        }
        int nYs = 0;
        int nYscans = 0;
        int nZs = 0;
        YTagStrings yts = null;
        if (dsYTags != null) {
            yts = this._getYTagStrings(dsYTags, this.nSigDigit);
        }
        for (QdsXferInfo xfer : lDsXfer) {
            int nProps;
            Element elComp;
            Element elProps = doc.createElement("properties");
            String sName = (String)xfer.qds.property("NAME");
            Units units = (Units)xfer.qds.property("UNITS");
            String sUnits = "";
            if (units != null) {
                sUnits = units.toString();
            }
            switch (xfer.nComponent) {
                case 2: {
                    elComp = doc.createElement(this.X_REF);
                    elComp.setAttribute("units", sUnits);
                    if (sName != null) {
                        elComp.setAttribute(this.JOINID, sName);
                    }
                    nProps = this.addSimpleProps(elProps, xfer.qds, "x");
                    break;
                }
                case 4: {
                    elComp = doc.createElement(this.Y);
                    elComp.setAttribute("units", sUnits);
                    if (sName == null) {
                        sName = String.format("Y_%d", nYs);
                    }
                    elComp.setAttribute(this.JOINID, sName);
                    if (this.bDas23) {
                        this._addCoSets(elComp, xfer, sName);
                    }
                    nProps = this.addSimpleProps(elProps, xfer.qds, "y");
                    ++nYs;
                    break;
                }
                case 5: {
                    elComp = doc.createElement(this.Z);
                    elComp.setAttribute("units", sUnits);
                    if (sName == null) {
                        sName = String.format("Z_%d", nZs);
                    }
                    elComp.setAttribute(this.JOINID, sName);
                    if (this.bDas23) {
                        this._addCoSets(elComp, xfer, sName);
                    }
                    nProps = this.addSimpleProps(elProps, xfer.qds, "z");
                    ++nZs;
                    break;
                }
                case 6: {
                    elComp = doc.createElement(this.Z_SCAN);
                    if (this.bDas23) {
                        elComp.setAttribute("units", sUnits);
                    } else {
                        elComp.setAttribute("zUnits", sUnits);
                    }
                    if (sName == null) {
                        sName = String.format("%s_%d", this.bDas23 ? "multiZ" : "YScan", nYscans);
                    }
                    elComp.setAttribute(this.JOINID, sName);
                    if (this.bDas23) {
                        this._addCoSets(elComp, xfer, sName);
                    }
                    if (dsYTags == null) {
                        log.warning("Missing yTags dataset for yScan dataset");
                        return null;
                    }
                    if (this.bDas23) {
                        elComp.setAttribute(this.SHAPE, String.format("*;%d", dsYTags.length()));
                    } else {
                        elComp.setAttribute(this.SHAPE, String.format("%d", dsYTags.length()));
                    }
                    units = (Units)dsYTags.property("UNITS");
                    sUnits = "";
                    if (units != null) {
                        sUnits = units.toString();
                    }
                    if (yts == null) {
                        assert (false);
                        log.warning("No YTags, for output yscans");
                        return null;
                    }
                    if (this.bDas23) {
                        if (yts.sYTags != null) {
                            this.valueListChild(elComp, this.Yoffsets, sUnits, yts.sYTags);
                        } else {
                            Element elOffsets = elComp.getOwnerDocument().createElement(this.Yoffsets);
                            elOffsets.setAttribute("units", sUnits);
                            elOffsets.setAttribute(this.Offset0, yts.sYTagMin);
                            elOffsets.setAttribute(this.Delta, yts.sYTagInterval);
                            elComp.appendChild(elOffsets);
                        }
                    } else {
                        elComp.setAttribute("yUnits", sUnits);
                        if (yts.sYTags != null) {
                            elComp.setAttribute(this.Yoffsets, yts.sYTags);
                        } else {
                            elComp.setAttribute(this.Delta, yts.sYTagInterval);
                            elComp.setAttribute(this.Offset0, yts.sYTagMin);
                        }
                    }
                    nProps = this.addSimpleProps(elProps, dsYTags, "y");
                    nProps += this.addSimpleProps(elProps, xfer.qds, "z");
                    ++nYscans;
                    break;
                }
                default: {
                    assert (false);
                    return null;
                }
            }
            elComp.setAttribute(this.FORMAT, xfer.sType);
            if (xfer.sSource != null) {
                elProps.setAttribute("source", xfer.sSource);
                ++nProps;
                if (xfer.sOperation != null) {
                    elProps.setAttribute("operation", xfer.sOperation);
                    ++nProps;
                }
            }
            if (nProps > 0) {
                elComp.appendChild(elProps);
            }
            elPkt.appendChild(elComp);
        }
        doc.appendChild(elPkt);
        return doc;
    }

    YTagStrings _getYTagStrings(QDataSet qds, int nFracDigits) {
        YTagStrings strs = new YTagStrings();
        if (qds.rank() != 1) {
            log.warning("YTags must have rank 1 for now.");
            return null;
        }
        String sFmt = String.format("%%.%de", 4);
        double rMin = qds.value(0);
        if (qds.length() == 0) {
            strs.sYTags = String.format(sFmt, rMin);
            return strs;
        }
        boolean bUseInterval = true;
        double rInterval = qds.value(1) - rMin;
        for (int i = 2; i < qds.length(); ++i) {
            double rNextInterval = qds.value(i) - qds.value(i - 1);
            double rAvg = Math.abs(rNextInterval + rInterval) / 2.0;
            double rJitter = Math.abs(rNextInterval - rInterval) / rAvg;
            if (!(rJitter > 1.0E-5)) continue;
            bUseInterval = false;
            break;
        }
        if (bUseInterval) {
            strs.sYTagMin = String.format(sFmt, rMin);
            strs.sYTagInterval = String.format(sFmt, rInterval);
        } else {
            StringBuilder sb = new StringBuilder();
            String sNL = "\n            ";
            if (this.bDas23) {
                sb.append(sNL);
                sb.append(String.format(sFmt, rMin));
                for (int i = 1; i < qds.length(); ++i) {
                    sb.append(",");
                    if (i % 8 == 0) {
                        sb.append(sNL);
                    } else {
                        sb.append(" ");
                    }
                    sb.append(String.format(sFmt, qds.value(i)));
                }
                sb.append("\n        ");
            } else {
                sb.append(String.format(sFmt, rMin));
                for (int i = 1; i < qds.length(); ++i) {
                    sb.append(",").append(String.format(sFmt, qds.value(i)));
                }
            }
            strs.sYTags = sb.toString();
        }
        return strs;
    }

    void valueListChild(Element elPlane, String sElement, String sUnits, String sValues) {
        Document doc = elPlane.getOwnerDocument();
        Element el = doc.createElement(sElement);
        el.setAttribute("units", sUnits);
        Text text = doc.createTextNode(sValues);
        el.appendChild(text);
        elPlane.appendChild(el);
    }

    int _addCoSets(Element elComp, QdsXferInfo xfer, String sPrimaryName) {
        int nPlanes = 0;
        for (String sProp : aStdPlaneProps) {
            if (!xfer.dCoSets.containsKey(sProp)) continue;
            QDataSet ds = xfer.dCoSets.get(sProp);
            Element elPlane = elComp.getOwnerDocument().createElement("coset");
            elPlane.setAttribute("purpose", sProp);
            String sName = (String)ds.property("NAME");
            if (sName == null) {
                sName = sPrimaryName + "_" + sProp;
            }
            elPlane.setAttribute(this.JOINID, sName);
            Units units = (Units)xfer.qds.property("UNITS");
            String sUnits = "";
            if (units != null) {
                sUnits = units.toString();
            }
            elPlane.setAttribute("units", sUnits);
            elComp.appendChild(elPlane);
            ++nPlanes;
        }
        if (nPlanes > 0) {
            elComp.setAttribute("cosets", Integer.toString(nPlanes));
        }
        return nPlanes;
    }

    private void writeData(int iPktId, PacketXferInfo pktXfer, OutputStream out) throws IOException {
        String sRecTag;
        WritableByteChannel channel = Channels.newChannel(out);
        if (this.bDas23) {
            QdsXferInfo qi = null;
            int nWidth = 0;
            for (int iDs = 0; iDs < pktXfer.datasets(); ++iDs) {
                qi = pktXfer.lDsXfer.get(iDs);
                int nSzEa = qi.transtype.sizeBytes();
                if (qi.qds.rank() == 1) {
                    nWidth += nSzEa;
                    continue;
                }
                nWidth += qi.qds.length(0) * nSzEa;
            }
            sRecTag = String.format("[XS|%d|%d]", iPktId, nWidth);
        } else {
            sRecTag = String.format(":%02d:", iPktId);
        }
        byte[] aRecTag = sRecTag.getBytes(StandardCharsets.US_ASCII);
        int nBufLen = pktXfer.slice0Length() + aRecTag.length;
        byte[] aBuf = new byte[nBufLen];
        ByteBuffer buffer = ByteBuffer.wrap(aBuf);
        buffer.order(ByteOrder.nativeOrder());
        buffer.put(aRecTag);
        int nPkts = pktXfer.lDsXfer.get((int)0).qds.length();
        for (int iPkt = 0; iPkt < nPkts; ++iPkt) {
            QdsXferInfo qi = null;
            block6: for (int iDs = 0; iDs < pktXfer.datasets(); ++iDs) {
                qi = pktXfer.lDsXfer.get(iDs);
                switch (qi.qds.rank()) {
                    case 1: {
                        QDataSet coset;
                        qi.transtype.write(qi.qds.value(iPkt), buffer);
                        for (String sProp : aStdPlaneProps) {
                            if (!qi.dCoSets.containsKey(sProp)) continue;
                            coset = qi.dCoSets.get(sProp);
                            qi.transtype.write(coset.value(iPkt), buffer);
                        }
                        continue block6;
                    }
                    case 2: {
                        QDataSet coset;
                        for (int iVal = 0; iVal < qi.qds.length(0); ++iVal) {
                            qi.transtype.write(qi.qds.value(iPkt, iVal), buffer);
                        }
                        for (String sProp : aStdPlaneProps) {
                            if (!qi.dCoSets.containsKey(sProp)) continue;
                            coset = qi.dCoSets.get(sProp);
                            for (int iVal = 0; iVal < coset.length(0); ++iVal) {
                                qi.transtype.write(coset.value(iPkt, iVal), buffer);
                            }
                        }
                        continue block6;
                    }
                    default: {
                        assert (false);
                        continue block6;
                    }
                }
            }
            if (qi != null && qi.transtype.isAscii()) {
                buffer.put(nBufLen - 1, (byte)10);
            }
            buffer.flip();
            channel.write(buffer);
            buffer.position(aRecTag.length);
        }
    }

    private String xmlDocToStr(Document doc) {
        DOMImplementation imp = doc.getImplementation();
        DOMImplementationLS ls = (DOMImplementationLS)imp.getFeature("LS", "3.0");
        LSSerializer serializer = ls.createLSSerializer();
        serializer.getDomConfig().setParameter("format-pretty-print", true);
        serializer.getDomConfig().setParameter("xml-declaration", false);
        String sDoc = serializer.writeToString(doc);
        return sDoc;
    }

    private void writeHeader(OutputStream os, int nPktId, String sHdr) throws UnsupportedEncodingException, IOException {
        byte[] aHdr = sHdr.getBytes(StandardCharsets.UTF_8);
        String sTag = this.bDas23 ? (nPktId == 0 ? String.format("[SH||%d]", aHdr.length) : String.format("[DS|%d|%d]", nPktId, aHdr.length)) : String.format("[%02d]%06d", nPktId, aHdr.length);
        byte[] aTag = sTag.getBytes(StandardCharsets.US_ASCII);
        os.write(aTag);
        os.write(aHdr);
    }

    private Document newXmlDoc() {
        try {
            DocumentBuilder bldr = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return bldr.newDocument();
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce);
        }
    }

    int addBoolProp(Element props, String sName, Object oValue) {
        String sValue;
        String string = sValue = (Boolean)oValue != false ? "true" : "false";
        if (this.bDas23) {
            this._addChildProp(props, sName, "boolean", sValue);
        } else {
            props.setAttribute(sName, sValue);
        }
        return 1;
    }

    int addStrProp(Element props, QDataSet qds, String qkey, String d2key) {
        Object oProp = qds.property(qkey);
        if (oProp != null) {
            return this.addStrProp(props, d2key, oProp);
        }
        return 0;
    }

    int addStrProp(Element props, String sName, Object oValue) {
        String sInput = (String)oValue;
        Pattern p = Pattern.compile("%\\{ *USER_PROPERTIES\\.");
        Matcher m = p.matcher(sInput);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "%{");
        }
        m.appendTail(sb);
        String sOutput = sb.toString();
        if (this.bDas23) {
            this._addChildProp(props, sName, null, sOutput);
        } else {
            props.setAttribute(sName, sOutput);
        }
        return 1;
    }

    int addRealProp(Element props, QDataSet qds, String qkey, String d2key) {
        Object oProp = qds.property(qkey);
        if (oProp != null) {
            return this.addRealProp(props, d2key, oProp);
        }
        return 0;
    }

    int addRealProp(Element props, String sName, Object oValue) {
        Number num = (Number)oValue;
        String sVal = String.format("%.6e", num.doubleValue());
        if (this.bDas23) {
            this._addChildProp(props, sName, "double", sVal);
        } else {
            props.setAttribute("double:" + sName, sVal);
        }
        return 1;
    }

    int addDatumProp(Element props, QDataSet qds, String qkey, String d2key) {
        Object oProp = qds.property(qkey);
        if (oProp != null) {
            return this.addDatumProp(props, d2key, oProp);
        }
        return 0;
    }

    int addDatumProp(Element props, String sName, Object oValue) {
        Datum datum = (Datum)oValue;
        if (this.bDas23) {
            this._addChildProp(props, sName, "Datum", datum.toString());
        } else {
            props.setAttribute("Datum:" + sName, datum.toString());
        }
        return 1;
    }

    int addRngProp(Element props, QDataSet qds, String sMinKey, String sMaxKey, String sUnitsKey, String d2key) {
        String sValue;
        Object oMin = qds.property(sMinKey);
        Object oMax = qds.property(sMaxKey);
        Object oUnits = qds.property(sUnitsKey);
        if (oMin == null || oMax == null) {
            return 0;
        }
        Number rMin = (Number)oMin;
        Number rMax = (Number)oMax;
        if (oUnits != null) {
            String sUnits = ((Units)oUnits).toString();
            sValue = String.format("%.6e to %.6e %s", rMin.doubleValue(), rMax.doubleValue(), sUnits);
        } else {
            sValue = String.format("%.6e to %.6e", rMin.doubleValue(), rMax.doubleValue());
        }
        if (this.bDas23) {
            this._addChildProp(props, d2key, "DatumRange", sValue);
        } else {
            props.setAttribute("DatumRange:" + d2key, sValue);
        }
        return 1;
    }

    int addRngProp(Element props, String sName, Object oValue) {
        String sOutput;
        DatumRange rng = (DatumRange)oValue;
        Units units = rng.getUnits();
        if (units instanceof TimeLocationUnits) {
            Datum dmMin = rng.min();
            Datum dmMax = rng.max();
            sOutput = String.format("%s to %s UTC", dmMin.toString().replaceAll("Z", ""), dmMax.toString().replaceAll("Z", ""));
        } else {
            sOutput = rng.toString();
        }
        if (this.bDas23) {
            this._addChildProp(props, sName, "DatumRange", sOutput);
        } else {
            props.setAttribute("DatumRange:" + sName, sOutput);
        }
        return 1;
    }

    void _addChildProp(Element props, String sName, String sType, String sVal) {
        Document doc = props.getOwnerDocument();
        Element prop = doc.createElement("prop");
        prop.setAttribute("name", sName);
        if (sType != null) {
            prop.setAttribute("type", sType);
        }
        Text text = doc.createTextNode(sVal);
        prop.appendChild(text);
        props.appendChild(prop);
    }

    int addSimpleProps(Element props, QDataSet qds, String sAxis) {
        int nProps = 0;
        nProps += this.addStrProp(props, qds, "FORMAT", sAxis + "Format");
        nProps += this.addStrProp(props, qds, "SCALE_TYPE", sAxis + "ScaleType");
        nProps += this.addStrProp(props, qds, "LABEL", sAxis + "Label");
        nProps += this.addStrProp(props, qds, "DESCRIPTION", sAxis + "Summary");
        nProps += this.addRealProp(props, qds, "FILL_VALUE", sAxis + "Fill");
        nProps += this.addRealProp(props, qds, "VALID_MIN", sAxis + "ValidMin");
        nProps += this.addRealProp(props, qds, "VALID_MAX", sAxis + "ValidMax");
        nProps += this.addRngProp(props, qds, "TYPICAL_MIN", "TYPICAL_MAX", "UNITS", sAxis + "Range");
        Object obj = qds.property("CADENCE");
        if (obj != null) {
            QDataSet dsTmp = (QDataSet)obj;
            Units units = (Units)dsTmp.property("UNITS");
            if (units == null) {
                units = Units.dimensionless;
            }
            Datum dtm = Datum.create(dsTmp.value(), units);
            if (this.bDas23) {
                this._addChildProp(props, sAxis + "TagWidth", "Datum", dtm.toString());
            } else {
                props.setAttribute("Datum:" + sAxis + "TagWidth", dtm.toString());
            }
            ++nProps;
        }
        return nProps;
    }

    int addPropsFromMap(Element props, Map<String, Object> dMap, boolean bStripDot) {
        if (dMap == null) {
            return 0;
        }
        int nAdded = 0;
        for (Map.Entry<String, Object> ent : dMap.entrySet()) {
            Object oVal;
            String sKey = ent.getKey();
            if (bStripDot && sKey.contains(".")) continue;
            if (this.bDas23) {
                NodeList nl = props.getElementsByTagName("prop");
                boolean bHasItAlready = false;
                for (int i = 0; i < nl.getLength(); ++i) {
                    Element el = (Element)nl.item(i);
                    if (!el.hasAttribute(sKey)) continue;
                    bHasItAlready = true;
                    break;
                }
                if (bHasItAlready) {
                    continue;
                }
            } else if (props.hasAttribute(sKey)) continue;
            if ((oVal = ent.getValue()) instanceof Boolean) {
                nAdded += this.addBoolProp(props, sKey, oVal);
                continue;
            }
            if (oVal instanceof String) {
                nAdded += this.addStrProp(props, sKey, oVal);
                continue;
            }
            if (oVal instanceof Number) {
                nAdded += this.addRealProp(props, sKey, oVal);
                continue;
            }
            if (oVal instanceof Datum) {
                nAdded += this.addDatumProp(props, sKey, oVal);
                continue;
            }
            if (!(oVal instanceof DatumRange)) continue;
            nAdded += this.addRngProp(props, sKey, oVal);
        }
        return nAdded;
    }

    public static String qd2DataAxis(QDataSet qds) {
        if (SemanticOps.isJoin(qds)) {
            qds = DataSetOps.slice0(qds, 0);
        }
        if (SemanticOps.isBundle(qds)) {
            if (qds.rank() == 1) {
                qds = DataSetOps.slice0(qds, 0);
            } else {
                int nMaxRank = 0;
                for (int i = 0; i < qds.length(); ++i) {
                    MutablePropertyDataSet ds = DataSetOps.slice0(qds, i);
                    int nRank = ds.rank();
                    if (ds.property("PLANE_0") != null) {
                        return null;
                    }
                    if (nRank <= nMaxRank) continue;
                    nMaxRank = ds.rank();
                }
                if (nMaxRank == 1) {
                    return "y";
                }
                if (nMaxRank == 2) {
                    return "z";
                }
                return null;
            }
        }
        switch (qds.rank()) {
            case 0: {
                return "x";
            }
            case 2: {
                return "z";
            }
            case 1: {
                if (qds.property("DEPEND_0") == null) {
                    return "x";
                }
                if (qds.property("PLANE_0") == null) {
                    return "y";
                }
                return "z";
            }
        }
        return null;
    }

    private class D2SciNoteTransfer
    extends TransferType {
        final int nLen;
        private String sFmt;

        public D2SciNoteTransfer(int nSigDigits) {
            if (nSigDigits < 2 || nSigDigits > 17) {
                throw new IllegalArgumentException(String.format("Significant digits for output must be between 2 and 17 inclusive, recieved %d", nSigDigits));
            }
            this.nLen = nSigDigits + 7;
            this.sFmt = String.format("%%.%de", nSigDigits - 1);
        }

        @Override
        public void write(double rVal, ByteBuffer buffer) {
            String sVal = String.format(this.sFmt, rVal);
            if (rVal >= 0.0) {
                buffer.put((byte)32);
            }
            buffer.put(sVal.getBytes(StandardCharsets.US_ASCII));
            buffer.put((byte)32);
        }

        @Override
        public double read(ByteBuffer buffer) {
            byte[] bytes = new byte[this.nLen];
            buffer.get(bytes);
            try {
                String str = new String(bytes, StandardCharsets.US_ASCII).trim();
                return Double.parseDouble(str);
            }
            catch (NumberFormatException ex) {
                return Double.NaN;
            }
        }

        @Override
        public int sizeBytes() {
            return this.nLen;
        }

        @Override
        public boolean isAscii() {
            return true;
        }

        @Override
        public String name() {
            return "ascii" + this.nLen;
        }
    }

    private class D2TextTimeTransfer
    extends TransferType {
        Units units;
        DatumFormatter formatter;
        byte[] aFill;
        int nSize;

        public D2TextTimeTransfer(Units units, int nFracSec) {
            this.units = units;
            this.nSize = 20;
            String sFmt = "yyyy-MM-dd'T'HH:mm:ss";
            String sFill = "                   ";
            if (nFracSec > 0) {
                sFmt = sFmt + ".";
                sFill = sFill + " ";
            }
            for (int i = 0; i < nFracSec; ++i) {
                sFmt = sFmt + "S";
                sFill = sFill + " ";
            }
            sFmt = sFmt + " ";
            sFill = sFill + " ";
            this.aFill = sFill.getBytes(StandardCharsets.US_ASCII);
            try {
                this.formatter = new TimeDatumFormatter(sFmt);
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
            if (nFracSec > 0) {
                ++this.nSize;
            }
            this.nSize += nFracSec;
        }

        @Override
        public void write(double rVal, ByteBuffer buffer) {
            if (this.units.isFill(rVal)) {
                buffer.put(this.aFill);
            } else {
                String sOut = this.formatter.format(this.units.createDatum(rVal));
                buffer.put(sOut.getBytes(StandardCharsets.US_ASCII));
            }
        }

        @Override
        public double read(ByteBuffer buffer) {
            try {
                byte[] aBuf = new byte[this.nSize];
                buffer.get(aBuf);
                String sTime = new String(aBuf, "US-ASCII").trim();
                double result = TimeUtil.create(sTime).doubleValue(this.units);
                return result;
            }
            catch (UnsupportedEncodingException | ParseException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public int sizeBytes() {
            return this.nSize;
        }

        @Override
        public boolean isAscii() {
            return true;
        }

        @Override
        public String name() {
            return String.format("time%d", this.nSize);
        }
    }

    private class PacketXferInfo {
        Document doc;
        List<QdsXferInfo> lDsXfer;

        PacketXferInfo(Document _doc, List<QdsXferInfo> _lDsXfer) {
            this.doc = _doc;
            this.lDsXfer = _lDsXfer;
        }

        int datasets() {
            return this.lDsXfer.size();
        }

        int slice0Length() {
            int nLen = 0;
            int nCoSets = 0;
            for (QdsXferInfo qi : this.lDsXfer) {
                int nItems = 1;
                if (qi.qds.rank() > 1) {
                    nItems = qi.qds.length(0);
                }
                if (qi.dCoSets.size() > 0) {
                    nCoSets = qi.dCoSets.size();
                }
                nLen += qi.transtype.sizeBytes() * nItems * (1 + nCoSets);
            }
            return nLen;
        }
    }

    private class QdsXferInfo {
        QDataSet qds;
        TransferType transtype;
        String sType;
        int nComponent;
        Map<String, QDataSet> dCoSets = new HashMap<String, QDataSet>();
        String sSource;
        String sOperation;

        QdsXferInfo(QDataSet _qds, boolean bBinary, int nGenDigits, int nFracSec, int _nComp) {
            this(_qds, bBinary, nGenDigits, nFracSec, _nComp, null, null);
        }

        QdsXferInfo(QDataSet _qds, boolean bBinary, int nGenSigDigit, int nFracSec, int _nComp, String _sSource, String sOp) {
            Units units;
            this.sSource = _sSource;
            this.sOperation = sOp;
            this.qds = _qds;
            this.nComponent = _nComp;
            if (bBinary) {
                nGenSigDigit = -1;
                nFracSec = -1;
            }
            if ((units = (Units)this.qds.property("UNITS")) != null && units instanceof TimeLocationUnits) {
                if (nFracSec < 0) {
                    this.transtype = new DoubleTransferType();
                    this.sType = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "little_endian_real8" : "sun_real8";
                } else {
                    this.transtype = new D2TextTimeTransfer(units, nFracSec);
                    this.sType = String.format("time%d", this.transtype.sizeBytes());
                }
            } else if (nGenSigDigit < 0) {
                this.transtype = new FloatTransferType();
                this.sType = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "little_endian_real4" : "sun_real4";
            } else {
                this.transtype = new D2SciNoteTransfer(nGenSigDigit);
                this.sType = String.format("ascii%d", this.transtype.sizeBytes());
            }
        }
    }

    private class YTagStrings {
        String sYTagInterval = null;
        String sYTagMin = null;
        String sYTags = null;

        private YTagStrings() {
        }
    }
}

