/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qstream;

import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.BundleDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.JoinDataSet;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.DataSetBuilder;
import org.das2.qstream.PacketDescriptor;
import org.das2.qstream.PlaneDescriptor;
import org.das2.qstream.SerializeDelegate;
import org.das2.qstream.SerializeRegistry;
import org.das2.qstream.StreamComment;
import org.das2.qstream.StreamDescriptor;
import org.das2.qstream.StreamException;
import org.das2.qstream.StreamHandler;
import org.das2.qstream.TransferType;
import org.das2.qstream.Util;
import org.das2.qstream.XMLSerializeDelegate;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class QDataSetStreamHandler
implements StreamHandler {
    private static final Logger logger = Logger.getLogger("qstream");
    public static final String BUILDER_JOIN_CHILDREN = "join";
    Map<String, DataSetBuilder> builders;
    Map<String, JoinDataSet> joinDataSets;
    Map<String, String[]> bundleDataSets;
    Map<String, Integer> ranks;
    XPathFactory factory = QDataSetStreamHandler.getXPathFactory();
    XPath xpath = this.factory.newXPath();
    String dsname;
    boolean readPackets = true;

    public QDataSetStreamHandler() {
        this.builders = new HashMap<String, DataSetBuilder>();
        this.joinDataSets = new HashMap<String, JoinDataSet>();
        this.bundleDataSets = new HashMap<String, String[]>();
        this.ranks = new HashMap<String, Integer>();
    }

    private static XPathFactory getXPathFactory() {
        XPathFactory xpf;
        try {
            xpf = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom", "com.sun.org.apache.xpath.internal.jaxp.XPathFactoryImpl", null);
        }
        catch (XPathFactoryConfigurationException ex) {
            xpf = XPathFactory.newInstance();
            logger.log(Level.INFO, "using default xpath implementation: {0}", xpf.getClass());
        }
        return xpf;
    }

    public List<String> getDataSetNames() {
        return new ArrayList<String>(this.builders.keySet());
    }

    public Map<String, String> getDataSetNamesAndDescriptions() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, DataSetBuilder> e : this.builders.entrySet()) {
            DataSetBuilder b = e.getValue();
            String name = null;
            String n = (String)b.getProperties().get("NAME");
            if (n != null) {
                name = n;
            }
            if ((n = (String)b.getProperties().get("LABEL")) != null) {
                name = n;
            }
            result.put(e.getKey(), name);
        }
        return result;
    }

    DataSetBuilder createBuilder(int rank, int[] qube) {
        DataSetBuilder result;
        block18: {
            block20: {
                block19: {
                    block17: {
                        if (rank != qube.length) break block17;
                        switch (rank) {
                            case 1: {
                                result = new DataSetBuilder(rank, qube[0]);
                                break block18;
                            }
                            case 2: {
                                result = new DataSetBuilder(rank, qube[0], qube[1]);
                                break block18;
                            }
                            case 3: {
                                result = new DataSetBuilder(rank, qube[0], qube[1], qube[2]);
                                break block18;
                            }
                            case 4: {
                                result = new DataSetBuilder(rank, qube[0], qube[1], qube[2], qube[3]);
                                break block18;
                            }
                            default: {
                                throw new IllegalArgumentException("rank limit");
                            }
                        }
                    }
                    if (rank != qube.length + 1) break block19;
                    switch (rank) {
                        case 1: {
                            result = new DataSetBuilder(rank, 100);
                            break block18;
                        }
                        case 2: {
                            result = new DataSetBuilder(rank, 100, qube[0]);
                            break block18;
                        }
                        case 3: {
                            result = new DataSetBuilder(rank, 100, qube[0], qube[1]);
                            break block18;
                        }
                        case 4: {
                            result = new DataSetBuilder(rank, 100, qube[0], qube[1], qube[2]);
                            break block18;
                        }
                        default: {
                            throw new IllegalArgumentException("rank limit");
                        }
                    }
                }
                if (rank != qube.length + 2) break block20;
                switch (rank) {
                    case 2: {
                        result = new DataSetBuilder(rank - 1, 100);
                        break block18;
                    }
                    case 3: {
                        result = new DataSetBuilder(rank - 1, 100, qube[0]);
                        break block18;
                    }
                    case 4: {
                        result = new DataSetBuilder(rank - 1, 100, qube[0], qube[1]);
                        break block18;
                    }
                    default: {
                        throw new IllegalArgumentException("rank limit");
                    }
                }
            }
            throw new IllegalArgumentException("rank and qube don't reconcile");
        }
        return result;
    }

    @Override
    public void streamDescriptor(StreamDescriptor sd) throws StreamException {
        try {
            Element e = sd.getDomElement();
            this.dsname = this.xpath.evaluate("//stream/@dataset_id", e);
            if (this.dsname.length() == 0) {
                Node stream = (Node)this.xpath.evaluate("//stream", e, XPathConstants.NODE);
                if (stream != null) {
                    throw new StreamException("dataset_id attribute expected in the stream descriptor.  Is this a qstream?");
                }
                throw new StreamException("dataset_id attribute expected in the stream descriptor.  Expected to find stream.");
            }
            logger.log(Level.FINE, "got streamDescriptor with default dataset {0}", this.dsname);
        }
        catch (XPathExpressionException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private DDataSet doInLine(Element vn) throws XPathExpressionException {
        double[] data;
        String svals = this.xpath.evaluate("@values", vn).trim();
        if (svals.equals("")) {
            svals = this.xpath.evaluate("@inline", vn).trim();
        }
        String sdims = this.xpath.evaluate("@length", vn);
        String[] ss = svals.split(",");
        int[] dims = sdims == null || sdims.length() == 0 ? (svals.length() == 0 ? new int[]{} : new int[]{ss.length}) : Util.decodeArray(sdims);
        int total = dims[0];
        for (int i = 1; i < dims.length; ++i) {
            total *= dims[i];
        }
        if (!svals.trim().equals("")) {
            data = new double[total];
            if (total != ss.length) {
                throw new IllegalArgumentException("number of elements inline doesn't match length");
            }
            for (int j = 0; j < total; ++j) {
                data[j] = Double.parseDouble(ss[j]);
            }
        } else {
            if (total > 0) {
                throw new IllegalArgumentException("nonzero length but no inline elements");
            }
            data = new double[]{};
        }
        DDataSet result = DDataSet.wrap(data, dims);
        return result;
    }

    @Override
    public void packetDescriptor(PacketDescriptor pd) throws StreamException {
        try {
            Element e = pd.getDomElement();
            XPathExpression expr = this.xpath.compile("/packet/qdataset");
            Object o = expr.evaluate(e, XPathConstants.NODESET);
            NodeList nodes = (NodeList)o;
            List<PlaneDescriptor> planes = pd.getPlanes();
            if (planes.size() != nodes.getLength()) {
                logger.log(Level.WARNING, "planes.size and nodes.getLength should be the same length, QDataSetStreamHandler line 254");
            }
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element n = (Element)nodes.item(i);
                String name = n.getAttribute("id");
                logger.log(Level.FINER, "got packetDescriptor for {0}", name);
                int rank = Integer.parseInt(n.getAttribute("rank"));
                this.ranks.put(name, rank);
                DataSetBuilder builder = null;
                boolean isInline = false;
                String joinParent = n.getAttribute("joinId");
                NodeList values = (NodeList)this.xpath.evaluate("values", n, XPathConstants.NODESET);
                NodeList bundles = null;
                if (values.getLength() == 0) {
                    bundles = (NodeList)this.xpath.evaluate("bundle", n, XPathConstants.NODESET);
                    if (bundles.getLength() == 0) {
                        throw new IllegalArgumentException("no values node in " + n.getNodeName() + " " + n.getAttribute("id"));
                    }
                    logger.log(Level.FINER, "newBundle");
                }
                if (bundles != null) {
                    builder = new DataSetBuilder(0, 0);
                    this.builders.put(name, builder);
                    String[] ss = planes.get(i).getBundles();
                    this.bundleDataSets.put(name, ss);
                } else {
                    for (int iv = 0; iv < values.getLength(); ++iv) {
                        JoinDataSet join;
                        Element vn = (Element)values.item(iv);
                        DDataSet inlineDs = null;
                        int index = -1;
                        if (vn.hasAttribute("values")) {
                            inlineDs = this.doInLine(vn);
                            isInline = true;
                            if (vn.hasAttribute("index")) {
                                index = Integer.parseInt(vn.getAttribute("index"));
                            }
                        } else if (vn.hasAttribute("inline")) {
                            inlineDs = this.doInLine(vn);
                            isInline = true;
                            if (vn.hasAttribute("index")) {
                                index = Integer.parseInt(vn.getAttribute("index"));
                            }
                        } else if (vn.hasAttribute("bundle")) {
                            builder = new DataSetBuilder(1, 0);
                            this.builders.put(name, builder);
                            String[] ss = planes.get(i).getBundles();
                            this.bundleDataSets.put(name, ss);
                        }
                        String sdims = this.xpath.evaluate("@length", vn);
                        String joinChildren = this.xpath.evaluate("@join", vn);
                        int[] dims = sdims == null ? new int[]{} : Util.decodeArray(sdims);
                        if (isInline && inlineDs != null && inlineDs.rank() < rank) {
                            if (iv == 0 && this.joinDataSets.containsKey(name)) {
                                logger.log(Level.FINE, "resetting join dataset for name {0}", name);
                                this.joinDataSets.remove(name);
                            }
                            join = this.getJoinDataSet(name, rank);
                            if (index >= 0) {
                                join.join(index, inlineDs);
                            } else {
                                join.join(inlineDs);
                            }
                            builder = new DataSetBuilder(0);
                            this.builders.put(name, builder);
                            continue;
                        }
                        if (isInline && inlineDs != null && inlineDs.rank() == rank) {
                            builder = new DataSetBuilder(rank, inlineDs.length());
                            for (int j = 0; j < inlineDs.length(); ++j) {
                                DDataSet slice = (DDataSet)inlineDs.slice(j);
                                builder.putValues(-1, slice, DataSetUtil.totalLength(slice));
                                builder.nextRecord();
                            }
                            this.builders.put(name, builder);
                            continue;
                        }
                        if (joinChildren.length() > 0) {
                            this.getJoinDataSet(name, rank);
                            builder = new DataSetBuilder(1, 10);
                            builder.putProperty(BUILDER_JOIN_CHILDREN, joinChildren);
                            this.builders.put(name, builder);
                            continue;
                        }
                        builder = this.builders.get(name);
                        if (builder == null) {
                            builder = this.createBuilder(rank, dims);
                            this.builders.put(name, builder);
                            if (joinParent.equals("")) continue;
                            JoinDataSet parent = this.joinDataSets.get(joinParent);
                            String children = (String)parent.property(BUILDER_JOIN_CHILDREN);
                            children = children == null || children.length() == 0 ? name : children + "," + name;
                            parent.putProperty(BUILDER_JOIN_CHILDREN, children);
                            continue;
                        }
                        join = joinParent.equals("") ? this.joinDataSets.get(name) : this.joinDataSets.get(joinParent);
                        if (join == null) {
                            logger.log(Level.FINE, "repeat of packet type for {0}, increasing rank.", name);
                            join = new JoinDataSet(rank + 1);
                            this.joinDataSets.put(name, join);
                        }
                        if (this.bundleDataSets.containsKey(name)) continue;
                        builder.setDataSetResolver(this.getResolver());
                        MutablePropertyDataSet mds = this.resolveProps(name, builder.getDataSet());
                        join.join(mds);
                        builder = this.createBuilder(rank, dims);
                        this.builders.put(name, builder);
                    }
                }
                NodeList odims = (NodeList)this.xpath.evaluate("properties[not(@index)]/property", n, XPathConstants.NODESET);
                QDataSetStreamHandler.doProps(odims, builder);
                odims = (NodeList)this.xpath.evaluate("properties[@index]/property", n, XPathConstants.NODESET);
                QDataSetStreamHandler.doPropsIndex(odims, this.joinDataSets.get(name));
                PlaneDescriptor planeDescriptor = planes.get(i);
                planeDescriptor.setBuilder(builder);
            }
        }
        catch (XPathExpressionException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            throw new RuntimeException(ex);
        }
    }

    private MutablePropertyDataSet resolveProps(String name, MutablePropertyDataSet result) {
        String[] propertyNames;
        String s;
        Object o;
        int i;
        for (i = 0; i < 4; ++i) {
            String s2 = (String)result.property("DEPENDNAME_" + i);
            if (s2 == null || s2.equals(name)) continue;
            QDataSet dep0ds = this.getDataSetInternal(s2);
            if (dep0ds == null) {
                logger.log(Level.WARNING, "unable to resolve property DEPENDNAME_{0}=\"{1}\"", new Object[]{i, s2});
                continue;
            }
            if (dep0ds.rank() == 1) {
                result.putProperty("DEPEND_" + i, dep0ds);
                continue;
            }
            if (i <= 0 || dep0ds.rank() != 2) continue;
            result.putProperty("DEPEND_" + i, dep0ds);
        }
        for (i = 0; i < 4; ++i) {
            o = result.property("DEPEND_" + i);
            if (o == null || !(o instanceof String)) continue;
            s = (String)o;
            logger.log(Level.WARNING, "QDataSetStreamHandler: still strings in DEPEND_{0}", i);
            result.putProperty("DEPEND_" + i, this.getDataSetInternal(s));
        }
        for (i = 0; i < 4; ++i) {
            o = result.property("BUNDLE_" + i);
            if (!(o instanceof String)) continue;
            s = (String)o;
            result.putProperty("BUNDLE_" + i, this.getDataSetInternal(s));
        }
        for (i = 0; i < 50; ++i) {
            String propertyName = "PLANE_" + i;
            Object o2 = result.property(propertyName);
            if (o2 instanceof String) {
                String s3 = (String)o2;
                result.putProperty(propertyName, this.getDataSetInternal(s3));
                continue;
            }
            if (o2 == null) break;
        }
        for (String propertyName : propertyNames = new String[]{"DELTA_MINUS", "DELTA_PLUS", "BIN_MINUS", "BIN_PLUS", "BIN_MIN", "BIN_MAX", "WEIGHTS"}) {
            Object o3 = result.property(propertyName);
            if (!(o3 instanceof String)) continue;
            String s4 = (String)o3;
            result.putProperty(propertyName, this.getDataSetInternal(s4));
        }
        return result;
    }

    @Override
    public void packet(PacketDescriptor pd, ByteBuffer data) throws StreamException {
        if (this.readPackets) {
            for (PlaneDescriptor planeDescriptor : pd.planes) {
                DataSetBuilder builder = planeDescriptor.getBuilder();
                if (planeDescriptor.getElements() > 1) {
                    DDataSet rec = DDataSet.createRank1(planeDescriptor.getElements());
                    for (int ii = 0; ii < planeDescriptor.getElements(); ++ii) {
                        rec.putValue(ii, planeDescriptor.getType().read(data));
                    }
                    if (!pd.isStream()) {
                        if (planeDescriptor.getRank() > 1) {
                            throw new IllegalArgumentException("non-streaming and rank>1 not supported");
                        }
                        for (int i = 0; i < rec.length(); ++i) {
                            builder.putValue(-1, rec.value(i));
                            builder.nextRecord();
                        }
                        continue;
                    }
                    builder.putValues(-1, rec, planeDescriptor.getElements());
                    builder.nextRecord();
                    continue;
                }
                TransferType tt = planeDescriptor.getType();
                if (tt == null) {
                    logger.severe("here planeDescriptor.getType() is null");
                }
                builder.putValue(-1, planeDescriptor.getType().read(data));
                builder.nextRecord();
            }
        }
    }

    @Override
    public void streamClosed(StreamDescriptor sd) throws StreamException {
    }

    @Override
    public void streamComment(StreamComment se) throws StreamException {
    }

    @Override
    public void streamException(StreamException se) throws StreamException {
    }

    private DataSetBuilder.DataSetResolver getResolver() {
        return new DataSetBuilder.DataSetResolver(){

            @Override
            public QDataSet resolve(String name) {
                DataSetBuilder builder;
                QDataSet result = QDataSetStreamHandler.this.joinDataSets.get(name);
                if (result == null && (builder = QDataSetStreamHandler.this.builders.get(name)) != null) {
                    result = builder.getDataSet();
                }
                return result;
            }
        };
    }

    private JoinDataSet getJoinDataSet(String name, int rank) {
        JoinDataSet join = this.joinDataSets.get(name);
        if (join == null) {
            join = new JoinDataSet(rank);
            this.joinDataSets.put(name, join);
        } else if (join.rank() != rank) {
            throw new IllegalArgumentException("rank mismatch");
        }
        return join;
    }

    public QDataSet getDataSet(String name) {
        QDataSet result = this.getDataSetInternal(name);
        if (result == null) {
            throw new IllegalArgumentException("No such dataset \"" + name + "\"");
        }
        Integer rank = this.ranks.get(name);
        if (rank.intValue() != result.rank() && QDataSetStreamHandler.isFlattenableJoin(result)) {
            logger.log(Level.FINE, "flattening join for {0}: {1}", new Object[]{name, result});
            result = this.flattenJoin(result);
        }
        return result;
    }

    public QDataSet getDataSet() {
        return this.getDataSet(this.dsname);
    }

    /*
     * WARNING - void declaration
     */
    private QDataSet getDataSetInternal(String name) {
        AbstractDataSet result;
        logger.log(Level.FINE, "getDataSet({0})", name);
        DataSetBuilder builder = this.builders.get(name);
        String[] sbds = this.bundleDataSets.get(name);
        JoinDataSet join = this.joinDataSets.get(name);
        if (builder == null && sbds == null) {
            logger.log(Level.INFO, "no such dataset: {0}", name);
            return null;
        }
        MutablePropertyDataSet sliceDs = null;
        if (join != null && sbds == null) {
            String joinChild = (String)join.property(BUILDER_JOIN_CHILDREN);
            join = JoinDataSet.copy(join);
            if (builder != null && builder.rank() > 0) {
                builder.setDataSetResolver(this.getResolver());
                sliceDs = builder.getDataSet();
                ArrayList<DDataSet> childDataSets = null;
                if (sliceDs.property(BUILDER_JOIN_CHILDREN) != null) {
                    if (joinChild == null) {
                        joinChild = (String)sliceDs.property(BUILDER_JOIN_CHILDREN);
                    }
                    String[] children = joinChild.split(",");
                    childDataSets = new ArrayList<DDataSet>();
                    for (String children1 : children) {
                        DataSetBuilder childBuilder = this.builders.get(children1);
                        if (childBuilder != null) {
                            childBuilder.setDataSetResolver(this.getResolver());
                            DDataSet sliceDs1 = childBuilder.getDataSet();
                            this.resolveProps(null, sliceDs1);
                            childDataSets.add(sliceDs1);
                            logger.log(Level.FINER, "child: {0}", ((Object)sliceDs1).toString());
                            continue;
                        }
                        logger.log(Level.WARNING, "missing child: {0}", children1);
                    }
                }
                if (childDataSets != null) {
                    for (QDataSet qDataSet : childDataSets) {
                        join.join(qDataSet);
                    }
                }
                DataSetUtil.putProperties(builder.getProperties(), join);
                if (sliceDs.length() > 0) {
                    this.resolveProps(null, sliceDs);
                    logger.fine("aggregation has one last dataset to append");
                    join.join(sliceDs);
                }
            } else {
                assert (builder != null);
                DataSetUtil.putProperties(builder.getProperties(), join);
                sliceDs = (MutablePropertyDataSet)join.slice(join.length() - 1);
            }
            result = join;
        } else if (sbds != null) {
            void var10_16;
            BundleDataSet bds = new BundleDataSet();
            String[] stringArray = sbds;
            int n = stringArray.length;
            boolean bl = false;
            while (var10_16 < n) {
                String sbd = stringArray[var10_16];
                bds.bundle(this.getDataSet(sbd));
                ++var10_16;
            }
            result = bds;
        } else {
            assert (builder != null);
            builder.setDataSetResolver(this.getResolver());
            result = builder.getDataSet();
        }
        if (join != null) {
            if (sliceDs != null) {
                this.resolveProps(name, sliceDs);
            }
        } else {
            this.resolveProps(name, result);
        }
        return result;
    }

    public void setReadPackets(boolean val) {
        this.readPackets = val;
    }

    public boolean getReadPackets() {
        return this.readPackets;
    }

    private static void doProps(NodeList odims, DataSetBuilder builder) {
        for (int j = 0; j < odims.getLength(); ++j) {
            String stype;
            Element n2 = (Element)odims.item(j);
            String pname = n2.getAttribute("name");
            String svalue = n2.hasAttribute("value") ? n2.getAttribute("value") : n2.getTextContent();
            Element evalue = null;
            if (n2.hasAttribute("type")) {
                stype = n2.getAttribute("type");
            } else {
                evalue = Util.singletonChildElement(n2);
                stype = evalue.getTagName();
            }
            if (stype.equals("qdataset")) {
                if (pname.equals("DELTA_MINUS") || pname.equals("DELTA_PLUS")) {
                    logger.warning("skipping DELTA_MINUS and DELTA_PLUS because bug");
                    builder.putProperty(pname, svalue);
                    builder.putUnresolvedProperty("qdataset", pname, svalue);
                }
                if (pname.matches("DEPEND_\\d+")) {
                    String si = pname.substring(7);
                    builder.putProperty("DEPENDNAME_" + si, svalue);
                    continue;
                }
                builder.putProperty(pname, svalue);
                builder.putUnresolvedProperty("qdataset", pname, svalue);
                continue;
            }
            SerializeDelegate delegate = SerializeRegistry.getByName(stype);
            if (delegate == null) {
                logger.log(Level.SEVERE, "!!! No delegate found for \"{0}\"", stype);
                continue;
            }
            try {
                Object oval = evalue != null && delegate instanceof XMLSerializeDelegate ? ((XMLSerializeDelegate)((Object)delegate)).xmlParse(evalue) : delegate.parse(stype, svalue);
                builder.putProperty(pname, oval);
                continue;
            }
            catch (ParseException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    private static void doPropsIndex(NodeList odims, JoinDataSet join) {
        for (int j = 0; j < odims.getLength(); ++j) {
            String stype;
            Element n2 = (Element)odims.item(j);
            String sidx = ((Element)n2.getParentNode()).getAttribute("index");
            int index = Integer.parseInt(sidx);
            String pname = n2.getAttribute("name");
            String svalue = n2.hasAttribute("value") ? n2.getAttribute("value") : n2.getTextContent();
            Element evalue = null;
            if (n2.hasAttribute("type")) {
                stype = n2.getAttribute("type");
            } else {
                evalue = Util.singletonChildElement(n2);
                stype = evalue.getTagName();
            }
            if (stype.equals("qdataset")) {
                join.putProperty(pname, index, svalue);
                continue;
            }
            SerializeDelegate delegate = SerializeRegistry.getByName(stype);
            if (delegate == null) {
                logger.log(Level.SEVERE, "no delegate found for \"{0}\"", stype);
                continue;
            }
            try {
                Object oval = evalue != null && delegate instanceof XMLSerializeDelegate ? ((XMLSerializeDelegate)((Object)delegate)).xmlParse(evalue) : delegate.parse(stype, svalue);
                join.putProperty(pname, index, oval);
                continue;
            }
            catch (ParseException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    public static boolean isFlattenableJoin(QDataSet ds) {
        if (ds.rank() == 2 && ds.property("DEPEND_0") == null && ds.property("BUNDLE_1") == null && ds.property("BINS_1") == null) {
            return true;
        }
        if (ds.rank() == 3 && ds.length() > 0 && ds.property("DEPEND_0") == null && ds.property("DEPENDNAME_0") != null) {
            QDataSet dep1 = (QDataSet)ds.slice(0).property("DEPEND_1");
            for (int i = 1; i < ds.length(); ++i) {
                QDataSet dep1t;
                if (!(dep1 == null ? (ds.rank() == 3 ? ds.length(0, 0) != ds.length(i, 0) : ds.length(0) != ds.length(i)) : !Ops.equivalent(dep1, dep1t = (QDataSet)ds.slice(i).property("DEPEND_1")))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public MutablePropertyDataSet flattenJoin(QDataSet ds) {
        int len = 0;
        if (ds.rank() < 2) {
            throw new IllegalArgumentException("rank should be > 2");
        }
        for (int i = 0; i < ds.length(); ++i) {
            len += ds.length(i);
        }
        ArrayDataSet result = ArrayDataSet.maybeCopy(ds.slice(0));
        if (result.isImmutable()) {
            result = ArrayDataSet.copy(result);
        }
        result.grow(len);
        for (int i = 1; i < ds.length(); ++i) {
            result.append(ArrayDataSet.maybeCopy(ds.slice(i)));
        }
        String s = (String)ds.property("DEPENDNAME_0");
        if (s != null) {
            MutablePropertyDataSet dep0 = (MutablePropertyDataSet)this.getDataSet(s);
            dep0.putProperty("TYPICAL_MIN", null);
            dep0.putProperty("TYPICAL_MAX", null);
            result.putProperty("DEPEND_0", dep0);
            result.putProperty("DEPENDNAME_0", null);
        }
        return result;
    }
}

