/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qstream;

import java.util.Arrays;
import org.das2.qds.QDataSet;
import org.das2.qds.util.DataSetBuilder;
import org.das2.qstream.TransferType;
import org.w3c.dom.Element;

public class PlaneDescriptor
implements Cloneable {
    private TransferType type;
    private Element domElement;
    private int rank;
    private int[] qube;
    private int elements;
    private QDataSet ds;
    private DataSetBuilder builder;
    private String name;
    private String[] bundles = null;

    void setDomElement(Element packetElement) {
        this.domElement = packetElement;
    }

    Element getDomElement() {
        return this.domElement;
    }

    int sizeBytes() {
        return this.elements * this.type.sizeBytes();
    }

    public String toString() {
        return "plane " + this.getName();
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public int[] getQube() {
        return Arrays.copyOf(this.qube, this.qube.length);
    }

    public void setQube(int[] qube) {
        this.qube = Arrays.copyOf(qube, qube.length);
        int ele1 = 1;
        for (int i = 0; i < this.getQube().length; ++i) {
            ele1 *= this.getQube()[i];
        }
        this.elements = ele1;
    }

    public int getElements() {
        return this.elements;
    }

    public QDataSet getDs() {
        return this.ds;
    }

    public void setDs(QDataSet ds) {
        this.ds = ds;
    }

    public DataSetBuilder getBuilder() {
        return this.builder;
    }

    public void setBuilder(DataSetBuilder builder) {
        this.builder = builder;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TransferType getType() {
        return this.type;
    }

    public void setType(TransferType type) {
        this.type = type;
    }

    void setBundles(String[] sbundles) {
        this.bundles = Arrays.copyOf(sbundles, sbundles.length);
    }

    public String[] getBundles() {
        return Arrays.copyOf(this.bundles, this.bundles.length);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

