/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qstream;

import java.lang.reflect.Array;
import java.text.ParseException;
import org.das2.qstream.SerializeDelegate;

public class NumberArraySerializeDelegate
implements SerializeDelegate {
    protected static final String TYPE_NUMBER_ARRAY = "numberArray";

    @Override
    public String format(Object o) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < Array.getLength(o); ++i) {
            if (i > 0) {
                result.append(",");
            }
            result.append(Array.get(o, i));
        }
        return result.toString();
    }

    @Override
    public Object parse(String typeId, String s) throws ParseException {
        String[] ss = s.split(",");
        double[] result = new double[ss.length];
        for (int i = 0; i < result.length; ++i) {
            try {
                result[i] = Double.parseDouble(ss[i]);
                continue;
            }
            catch (NumberFormatException ex) {
                result[i] = 0.0;
            }
        }
        return result;
    }

    @Override
    public String typeId(Class clas) {
        return TYPE_NUMBER_ARRAY;
    }
}

