/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qstream;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.qstream.PacketDescriptor;
import org.das2.qstream.PlaneDescriptor;
import org.das2.qstream.StreamComment;
import org.das2.qstream.StreamDescriptor;
import org.das2.qstream.StreamException;
import org.das2.qstream.StreamHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FormatStreamHandler
implements StreamHandler {
    WritableByteChannel out;
    StreamDescriptor sd;

    public void setOutputStream(OutputStream outs) {
        this.out = Channels.newChannel(outs);
    }

    public void setWritableByteChannel(WritableByteChannel outs) {
        this.out = outs;
    }

    public StreamDescriptor createStreamDescriptor(String name, boolean asciiTypes, boolean isBigEndian) {
        try {
            StreamDescriptor lsd = new StreamDescriptor(DocumentBuilderFactory.newInstance());
            Document document = lsd.newDocument(lsd);
            Element streamElement = document.createElement("stream");
            streamElement.setAttribute("dataset_id", name);
            if (!asciiTypes) {
                streamElement.setAttribute("byte_order", isBigEndian ? "big_endian" : "little_endian");
            }
            return lsd;
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void streamDescriptor(StreamDescriptor sd) throws StreamException {
        this.sd = sd;
        this.sd.setFactory(DocumentBuilderFactory.newInstance());
        try {
            this.sd.addDescriptor(sd);
            this.sd.newDocument(sd);
            sd.send(sd, this.out);
        }
        catch (IOException ex) {
            throw new StreamException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new StreamException(ex);
        }
    }

    @Override
    public void packetDescriptor(PacketDescriptor pd) throws StreamException {
        this.sd.addDescriptor(pd);
        try {
            Document d = this.sd.newDocument(pd);
            if (pd.getDomElement() == null) {
                Element ele = d.createElement("packet");
                for (PlaneDescriptor pld : pd.getPlanes()) {
                    Element qdatasetElement = d.createElement("qdataset");
                    qdatasetElement.setAttribute("id", pld.getName());
                    qdatasetElement.setAttribute("rank", String.valueOf(pld.getRank()));
                    ele.appendChild(qdatasetElement);
                }
                pd.setDomElement(ele);
                throw new IllegalStateException("this implementation is not complete.  See SimpleStreamFormatter");
            }
            this.sd.send(pd, this.out);
        }
        catch (IOException ex) {
            throw new StreamException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new StreamException(ex);
        }
    }

    @Override
    public void packet(PacketDescriptor pd, ByteBuffer data) throws StreamException {
        try {
            this.out.write(ByteBuffer.wrap(String.format(":%02d:", this.sd.descriptorId(pd)).getBytes("US-ASCII")));
            this.out.write(data);
        }
        catch (IOException ex) {
            throw new StreamException(ex);
        }
    }

    @Override
    public void streamClosed(StreamDescriptor sd) throws StreamException {
    }

    private String xmlSafe(String s) {
        s = s.replaceAll("'", "");
        return s;
    }

    @Override
    public void streamException(StreamException se) throws StreamException {
        String type = "StreamException";
        if (se.getCause() instanceof NoDataInIntervalException) {
            type = "NoDataInInterval";
        }
        String msg = String.format("<exception type='%s' message='%s'/>\n", type, this.xmlSafe(se.getMessage()));
        try {
            this.out.write(ByteBuffer.wrap(String.format("[xx]%06d", msg.length()).getBytes("US-ASCII")));
            this.out.write(ByteBuffer.wrap(msg.getBytes("US-ASCII")));
        }
        catch (IOException ex) {
            throw new StreamException(ex);
        }
    }

    @Override
    public void streamComment(StreamComment se) throws StreamException {
        String msg = String.format("<comment type='%s' message='%s'/>\n", se.getType(), this.xmlSafe(se.getMessage()));
        try {
            this.out.write(ByteBuffer.wrap(String.format("[xx]%06d", msg.length()).getBytes("US-ASCII")));
            this.out.write(ByteBuffer.wrap(msg.getBytes("US-ASCII")));
        }
        catch (IOException ex) {
            throw new StreamException(ex);
        }
    }
}

