/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qstream;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.datum.Datum;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.qstream.SerializeDelegate;

public class EnumerationUnitsSerializeDelegate
implements SerializeDelegate {
    protected static final Logger logger = Logger.getLogger("qstream");

    @Override
    public String format(Object o) {
        String s;
        Integer i;
        EnumerationUnits eu = (EnumerationUnits)o;
        Map<Integer, Datum> values = eu.getValues();
        StringBuilder buf = new StringBuilder();
        buf.append("").append(eu.getId()).append("[");
        boolean useSemiSpaceDelimiters = false;
        for (Map.Entry<Integer, Datum> e : values.entrySet()) {
            i = e.getKey();
            s = e.getValue().toString();
            if (s.trim().length() != 0) continue;
            useSemiSpaceDelimiters = true;
        }
        for (Map.Entry<Integer, Datum> e : values.entrySet()) {
            i = e.getKey();
            s = e.getValue().toString();
            s = s.replaceAll("::", ":");
            if ((s = s.replaceAll("; ", ";")).length() <= 0) continue;
            buf.append("").append(i).append(":").append(s);
            if (i >= values.size()) continue;
            buf.append(useSemiSpaceDelimiters ? "; " : "::");
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public Object parse(String typeId, String s) {
        EnumerationUnits u;
        Pattern p = Pattern.compile("(.+?)(\\[(.*)\\])?");
        Matcher m = p.matcher(s);
        if (!m.matches()) {
            throw new IllegalArgumentException("bad format!");
        }
        String id = m.group(1);
        try {
            u = (EnumerationUnits)Units.getByName(s);
        }
        catch (IllegalArgumentException ex) {
            u = new EnumerationUnits(id);
        }
        String values = m.group(3);
        String[] ss = values == null ? new String[]{} : values.split("::", -2);
        if (ss.length == 1) {
            ss = values.split("; ", -2);
        }
        for (String nv : ss) {
            if (nv.trim().length() <= 0) continue;
            int idx = nv.indexOf(":");
            if (idx > -1) {
                try {
                    int ival = Integer.parseInt(nv.substring(0, idx));
                    String sval = nv.substring(idx + 1);
                    u.createDatum(ival, sval);
                }
                catch (NumberFormatException ex) {
                    logger.log(Level.WARNING, "NumberFormatException caught: {0}", nv);
                }
                continue;
            }
            logger.log(Level.WARNING, "Bad index caught: {0}", nv);
        }
        return u;
    }

    @Override
    public String typeId(Class clas) {
        return "enumerationUnit";
    }
}

