/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qstream;

import org.das2.qstream.SerializeDelegate;
import org.das2.qstream.SerializeRegistry;

public abstract class DefaultSerializeDelegate
implements SerializeDelegate {
    static void registerDelegates() {
        SerializeRegistry.register(java.lang.Boolean.class, new Boolean());
        SerializeRegistry.register(java.lang.Integer.class, new Integer());
        SerializeRegistry.register(java.lang.Long.class, new Long());
        SerializeRegistry.register(java.lang.Float.class, new Float());
        SerializeRegistry.register(java.lang.Double.class, new Double());
        SerializeRegistry.register(java.lang.Short.class, new Short());
        SerializeRegistry.register(java.lang.Byte.class, new Byte());
        SerializeRegistry.register(java.lang.Number.class, new Number());
        SerializeRegistry.register(java.lang.Boolean.TYPE, new Boolean());
        SerializeRegistry.register(java.lang.Integer.TYPE, new Integer());
        SerializeRegistry.register(java.lang.Long.TYPE, new Long());
        SerializeRegistry.register(java.lang.Float.TYPE, new Float());
        SerializeRegistry.register(java.lang.Double.TYPE, new Double());
        SerializeRegistry.register(java.lang.Short.TYPE, new Short());
        SerializeRegistry.register(java.lang.Byte.TYPE, new Byte());
    }

    @Override
    public String format(Object o) {
        return o.toString();
    }

    @Override
    public abstract Object parse(String var1, String var2);

    @Override
    public String typeId(Class clas) {
        String s = clas.getName();
        if (s.startsWith("java.lang.")) {
            s = s.substring(10);
        }
        return s;
    }

    public static class Boolean
    extends DefaultSerializeDelegate {
        @Override
        public Object parse(String typeId, String s) {
            return java.lang.Boolean.parseBoolean(s);
        }
    }

    public static class Byte
    extends DefaultSerializeDelegate {
        @Override
        public Object parse(String typeId, String s) {
            return java.lang.Byte.parseByte(s);
        }
    }

    public static class Double
    extends DefaultSerializeDelegate {
        @Override
        public Object parse(String typeId, String s) {
            return java.lang.Double.parseDouble(s);
        }
    }

    public static class Float
    extends DefaultSerializeDelegate {
        @Override
        public Object parse(String typeId, String s) {
            return java.lang.Float.valueOf(java.lang.Float.parseFloat(s));
        }
    }

    public static class Integer
    extends DefaultSerializeDelegate {
        @Override
        public Object parse(String typeId, String s) {
            return java.lang.Integer.parseInt(s);
        }
    }

    public static class Long
    extends DefaultSerializeDelegate {
        @Override
        public Object parse(String typeId, String s) {
            return java.lang.Long.parseLong(s);
        }
    }

    public static class Number
    extends DefaultSerializeDelegate {
        @Override
        public Object parse(String typeId, String s) {
            return java.lang.Double.parseDouble(s);
        }
    }

    public static class Short
    extends DefaultSerializeDelegate {
        @Override
        public Object parse(String typeId, String s) {
            return java.lang.Short.parseShort(s);
        }
    }
}

