/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qstream;

import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.SemanticOps;
import org.das2.qstream.SerializeDelegate;
import org.das2.qstream.XMLSerializeDelegate;
import org.das2.util.LoggerManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DatumRangeSerializeDelegate
implements SerializeDelegate,
XMLSerializeDelegate {
    private static final Logger logger = LoggerManager.getLogger("qstream");

    @Override
    public String format(Object o) {
        DatumRange dr = (DatumRange)o;
        Units u = dr.getUnits();
        if (UnitsUtil.isTimeLocation(u)) {
            return "time:" + o;
        }
        return o.toString();
    }

    @Override
    public Object parse(String typeId, String s) throws ParseException {
        if (s.startsWith("time:")) {
            return DatumRangeUtil.parseTimeRange(s.substring(5));
        }
        try {
            if (!(s.contains(" ") || s.contains("E+") || s.contains("e+"))) {
                s = s.replaceAll("\\+", " ");
            }
            return DatumRangeUtil.parseTimeRange(s);
        }
        catch (ParseException e) {
            int i = s.trim().lastIndexOf(" ");
            if (i == -1) {
                return DatumRangeUtil.parseDatumRange(s, Units.dimensionless);
            }
            String sunits = s.substring(i).trim();
            try {
                Double d = Double.parseDouble(sunits);
                return DatumRangeUtil.parseDatumRange(s, Units.dimensionless);
            }
            catch (NumberFormatException ex) {
                Units u = SemanticOps.lookupUnits(sunits);
                return DatumRangeUtil.parseDatumRange(s, u);
            }
        }
    }

    @Override
    public String typeId(Class clas) {
        return "datumRange";
    }

    @Override
    public Element xmlFormat(Document doc, Object o) {
        DatumRange dr = (DatumRange)o;
        Element result = doc.createElement(this.typeId(o.getClass()));
        result.setAttribute("units", dr.getUnits().toString());
        if (!UnitsUtil.isRatioMeasurement(dr.getUnits())) {
            result.setAttribute("value", dr.toString());
        } else {
            try {
                DatumRange test = DatumRangeUtil.parseDatumRange(dr.toString(), dr);
                if (test.equals(dr)) {
                    result.setAttribute("value", dr.toString());
                } else {
                    String svalue = String.format("%s to %s", dr.min().value(), dr.max().value());
                    result.setAttribute("value", svalue);
                }
            }
            catch (ParseException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
                result.setAttribute("value", dr.toString());
            }
        }
        return result;
    }

    @Override
    public Object xmlParse(Element e) throws ParseException {
        String sunits = e.getAttribute("units");
        Units u = SemanticOps.lookupUnits(sunits);
        String s = e.getAttribute("value");
        return DatumRangeUtil.parseDatumRange(s, u);
    }
}

