/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.util;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.IDataSet;
import org.das2.qds.IndexGenDataSet;
import org.das2.qds.JoinDataSet;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.DataSetBuilder;
import org.das2.util.LoggerManager;

public class Reduction {
    private static final Logger logger = LoggerManager.getLogger("qdataset.ops.reduction");

    private static UnitsConverter getDifferencesConverter(QDataSet src, QDataSet dst, Units dstUnits) {
        Units unitsOut;
        Units unitsIn = (Units)dst.property("UNITS");
        if (unitsIn == null) {
            unitsIn = Units.dimensionless;
        }
        if ((unitsOut = (Units)src.property("UNITS")) == null) {
            unitsOut = Units.dimensionless;
        }
        UnitsConverter xuc = dstUnits != null ? unitsOut.getConverter(dstUnits) : unitsOut.getConverter(unitsIn.getOffsetUnits());
        return xuc;
    }

    private static QDataSet reducexWaveform(QDataSet ds, QDataSet xLimit) {
        int icadence;
        DataSetBuilder xbuilder = new DataSetBuilder(1, 1000);
        DataSetBuilder ybuilder = new DataSetBuilder(1, 1000);
        DataSetBuilder yminbuilder = new DataSetBuilder(1, 1000);
        DataSetBuilder ymaxbuilder = new DataSetBuilder(1, 1000);
        Datum cadence = DataSetUtil.asDatum(xLimit);
        QDataSet _offsets = (QDataSet)ds.property("DEPEND_1");
        MutablePropertyDataSet offsets = DataSetOps.makePropertiesMutable(_offsets);
        offsets.putProperty("VALID_MIN", null);
        offsets.putProperty("VALID_MAX", null);
        if (offsets.rank() == 2) {
            offsets = (MutablePropertyDataSet)offsets.slice(0);
            logger.fine("slice(0) on rank 2 dataset because code doesn't support time-varying DEPEND_1");
        }
        for (icadence = 4; icadence < offsets.length() / 2 && cadence.gt(DataSetUtil.asDatum(offsets.slice(icadence)).subtract(DataSetUtil.asDatum(offsets.slice(0)))); icadence *= 2) {
        }
        if ((icadence /= 2) < 4) {
            return ds;
        }
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        xbuilder.putProperty("UNITS", dep0.property("UNITS"));
        if (icadence < offsets.length()) {
            xbuilder.putProperty("CADENCE", Ops.subtract(offsets.slice(icadence), offsets.slice(0)));
        } else {
            xbuilder.putProperty("CADENCE", Ops.multiply((Object)Ops.subtract(offsets.slice(icadence / 2), offsets.slice(0)), 2));
        }
        int iout = 0;
        for (int j = 0; j < ds.length(); ++j) {
            int i = 0;
            QDataSet ttag = dep0.slice(j);
            QDataSet ds1 = ds.slice(j);
            while (i + icadence < offsets.length()) {
                QDataSet ext = Ops.extent(ds1.trim(i, i + icadence));
                QDataSet avg = Ops.reduceMean(ds1.trim(i, i + icadence), 0);
                xbuilder.putValue(iout, Ops.add(ttag, offsets.slice(i + icadence / 2)).value());
                yminbuilder.putValue(iout, ext.value(0));
                ymaxbuilder.putValue(iout, ext.value(1));
                ybuilder.putValue(iout, avg.value());
                ++iout;
                i += icadence;
            }
        }
        DDataSet result = ybuilder.getDataSet();
        DataSetUtil.copyDimensionProperties(ds, result);
        yminbuilder.putProperty("UNITS", ds.property("UNITS"));
        ymaxbuilder.putProperty("UNITS", ds.property("UNITS"));
        result.putProperty("DELTA_MINUS", Ops.subtract(result, yminbuilder.getDataSet()));
        result.putProperty("DELTA_PLUS", Ops.subtract(ymaxbuilder.getDataSet(), result));
        result.putProperty("DEPEND_0", xbuilder.getDataSet());
        if (result.property("CACHE_TAG") != null) {
            result.putProperty("CACHE_TAG", null);
        }
        return result;
    }

    public static QDataSet reducex(QDataSet ds, QDataSet xLimit) {
        double dxLimit;
        long t0 = System.currentTimeMillis();
        if (ds == null) {
            return ds;
        }
        if (!DataSetUtil.isQube(ds)) {
            throw new IllegalArgumentException("rank 2 dataset must be a qube");
        }
        if (ds.rank() == 0) {
            return ds;
        }
        DataSetBuilder xbuilder = new DataSetBuilder(1, 1000);
        if (ds.rank() == 1) {
            return Reduction.reduce2D(ds, xLimit, null);
        }
        if (ds.rank() == 2) {
            if (SemanticOps.isRank2Waveform(ds)) {
                return Reduction.reducexWaveform(ds, xLimit);
            }
        } else {
            if (ds.rank() == 3 && SemanticOps.isJoin(ds)) {
                JoinDataSet result = new JoinDataSet(3);
                for (int i = 0; i < ds.length(); ++i) {
                    QDataSet ds1 = ds.slice(i);
                    result.join(Reduction.reducex(ds1, xLimit));
                }
                return result;
            }
            throw new IllegalArgumentException("only rank 1, rank 2, and rank 3 join datasets");
        }
        DataSetBuilder ybuilder = new DataSetBuilder(2, 1000, ds.length(0));
        DataSetBuilder yminbuilder = new DataSetBuilder(2, 1000, ds.length(0));
        DataSetBuilder ymaxbuilder = new DataSetBuilder(2, 1000, ds.length(0));
        DataSetBuilder wbuilder = new DataSetBuilder(2, 1000, ds.length(0));
        QDataSet x = (QDataSet)ds.property("DEPEND_0");
        if (x == null) {
            x = ds.rank() == 2 && SemanticOps.isBundle(ds) ? DataSetOps.unbundle(ds, 0) : new IndexGenDataSet(ds.length());
        }
        int ny = ds.rank() == 1 ? 1 : ds.length(0);
        double x0 = 3.4028234663852886E38;
        double sx0 = 0.0;
        double nx = 0.0;
        double[] sy0 = new double[ny];
        double[] nn0 = new double[ny];
        double[] miny0 = new double[ny];
        for (int j = 0; j < ny; ++j) {
            miny0[j] = Double.POSITIVE_INFINITY;
        }
        double[] maxy0 = new double[ny];
        for (int j = 0; j < ny; ++j) {
            maxy0[j] = Double.NEGATIVE_INFINITY;
        }
        double[] ay0 = new double[ny];
        if (xLimit != null) {
            UnitsConverter uc = Reduction.getDifferencesConverter(xLimit, x, null);
            dxLimit = uc.convert(xLimit.value());
        } else {
            dxLimit = Double.MAX_VALUE;
        }
        int points = 0;
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        double fill = Double.NaN;
        for (int i = 0; i < x.length(); ++i) {
            double pyy;
            int j;
            double xx = x.value(i);
            QDataSet yy = ds.slice(i);
            QDataSet ww = wds.slice(i);
            double pxx = xx;
            double wx = 1.0;
            sx0 += pxx * wx;
            nx += 1.0;
            if (x0 == 3.4028234663852886E38) {
                x0 = Math.floor(xx / dxLimit) * dxLimit;
            }
            double dx = pxx - x0;
            for (j = 0; j < ny; ++j) {
                if (ww.value(j) == 0.0 || !(dx >= 0.0) || !(dx < dxLimit)) continue;
                pyy = yy.value(j);
                int n = j;
                sy0[n] = sy0[n] + pyy * ww.value(j);
                int n2 = j;
                nn0[n2] = nn0[n2] + ww.value(j);
                if (!(ww.value(j) > 0.0)) continue;
                miny0[j] = Math.min(miny0[j], pyy);
                maxy0[j] = Math.max(maxy0[j], pyy);
            }
            if (!(dx < 0.0) && !(dx >= dxLimit)) continue;
            x0 = Math.floor(pxx / dxLimit) * dxLimit;
            for (j = 0; j < ny; ++j) {
                if (nx > 0.0) {
                    boolean nv = nn0[j] == 0.0;
                    double ax0 = x0 + dxLimit / 2.0;
                    double d = ay0[j] = nv ? fill : sy0[j] / nn0[j];
                    if (j == 0) {
                        xbuilder.putValue(points, ax0);
                    }
                    ybuilder.putValue(points, j, ay0[j]);
                    yminbuilder.putValue(points, j, nv ? fill : miny0[j]);
                    ymaxbuilder.putValue(points, j, nv ? fill : maxy0[j]);
                    wbuilder.putValue(points, j, nn0[j]);
                }
                pyy = yy.value(j);
                double wwj = ww.value(j);
                if (j == 0) {
                    sx0 = pxx * wx;
                }
                sy0[j] = pyy * wwj;
                nn0[j] = wwj;
                nx = 1.0;
                if (wwj > 0.0) {
                    miny0[j] = pyy;
                    maxy0[j] = pyy;
                    continue;
                }
                miny0[j] = Double.POSITIVE_INFINITY;
                maxy0[j] = Double.NEGATIVE_INFINITY;
            }
            if (!(nx > 0.0)) continue;
            ++points;
        }
        if (nx > 0.0) {
            for (int j = 0; j < ny; ++j) {
                boolean nv = nn0[j] == 0.0;
                double ax0 = x0 + dxLimit / 2.0;
                double d = ay0[j] = nv ? fill : sy0[j] / nn0[j];
                if (j == 0) {
                    xbuilder.putValue(points, ax0);
                }
                ybuilder.putValue(points, j, ay0[j]);
                yminbuilder.putValue(points, j, nv ? fill : miny0[j]);
                ymaxbuilder.putValue(points, j, nv ? fill : maxy0[j]);
                wbuilder.putValue(points, j, nn0[j]);
            }
            ++points;
        }
        DDataSet result = ybuilder.getDataSet();
        DDataSet xds = xbuilder.getDataSet();
        Map<String, Object> xprops = DataSetUtil.getDimensionProperties(x, null);
        if (xprops.containsKey("CADENCE")) {
            xprops.put("CADENCE", xLimit);
        }
        if (xprops.containsKey("CACHE_TAG")) {
            xprops.put("CACHE_TAG", null);
        }
        DataSetUtil.putProperties(xprops, xds);
        Map<String, Object> yprops = DataSetUtil.getProperties(ds);
        yprops.put("DEPEND_0", xds);
        for (int j = 1; j < ds.rank(); ++j) {
            String DEP = "DEPEND_" + j;
            QDataSet dep1 = (QDataSet)yprops.get(DEP);
            if (dep1 == null || dep1.rank() != 2) continue;
            if (DataSetUtil.isConstant(dep1)) {
                yprops.put(DEP, dep1.slice(0));
                continue;
            }
            logger.log(Level.INFO, "dropping {0} which is time-varying", DEP);
            yprops.put(DEP, null);
        }
        DataSetUtil.putProperties(yprops, result);
        yminbuilder.putProperty("UNITS", SemanticOps.getUnits(result));
        ymaxbuilder.putProperty("UNITS", SemanticOps.getUnits(result));
        result.putProperty("DEPEND_0", xds);
        result.putProperty("WEIGHTS", wbuilder.getDataSet());
        DDataSet yminDs = yminbuilder.getDataSet();
        DDataSet ymaxDs = ymaxbuilder.getDataSet();
        result.putProperty("DELTA_MINUS", Ops.subtract(result, yminDs));
        result.putProperty("DELTA_PLUS", Ops.subtract(ymaxDs, result));
        result.putProperty("BIN_MIN", yminDs);
        result.putProperty("BIN_MAX", ymaxDs);
        logger.log(Level.FINE, "time to reducex({0} records -> {1} records) (ms): {2}", new Object[]{ds.length(), result.length(), System.currentTimeMillis() - t0});
        return result;
    }

    public static QDataSet reduce2D(QDataSet ds, QDataSet xLimit, QDataSet yLimit) {
        double ay0;
        double ax0;
        double dyLimit;
        double dxLimit;
        UnitsConverter uc;
        boolean ylog;
        long t0 = System.currentTimeMillis();
        DataSetBuilder xbuilder = new DataSetBuilder(1, 1000);
        DataSetBuilder ybuilder = new DataSetBuilder(1, 1000);
        DataSetBuilder yminbuilder = new DataSetBuilder(1, 1000);
        DataSetBuilder ymaxbuilder = new DataSetBuilder(1, 1000);
        DataSetBuilder wbuilder = new DataSetBuilder(1, 1000);
        QDataSet x = (QDataSet)ds.property("DEPEND_0");
        if (x == null) {
            x = new IndexGenDataSet(ds.length());
        }
        QDataSet y = ds;
        double x0 = 3.4028234663852886E38;
        double y0 = 3.4028234663852886E38;
        double sx0 = 0.0;
        double sy0 = 0.0;
        double nn0 = 0.0;
        double miny0 = Double.POSITIVE_INFINITY;
        double maxy0 = Double.NEGATIVE_INFINITY;
        boolean xlog = xLimit != null && "log".equals(xLimit.property("SCALE_TYPE"));
        boolean bl = ylog = yLimit != null && "log".equals(yLimit.property("SCALE_TYPE"));
        if (xLimit != null) {
            uc = Reduction.getDifferencesConverter(xLimit, x, xlog ? Units.logERatio : null);
            dxLimit = uc.convert(xLimit.value());
        } else {
            dxLimit = Double.MAX_VALUE;
        }
        if (yLimit != null) {
            uc = Reduction.getDifferencesConverter(yLimit, y, ylog ? Units.logERatio : null);
            dyLimit = uc.convert(yLimit.value());
        } else {
            dyLimit = Double.MAX_VALUE;
        }
        int points = 0;
        QDataSet wds = DataSetUtil.weightsDataSet(y);
        int i = 0;
        while (i < x.length()) {
            double xx = x.value(i);
            double yy = y.value(i);
            double ww = wds.value(i);
            if (ww == 0.0) {
                ++i;
                continue;
            }
            double pxx = xlog ? Math.log(xx) : xx;
            double pyy = ylog ? Math.log(yy) : yy;
            double dx = pxx - x0;
            double dy = pyy - y0;
            if (Math.abs(dx) < dxLimit && Math.abs(dy) < dyLimit) {
                sx0 += pxx * ww;
                sy0 += pyy * ww;
                nn0 += ww;
                if (ww > 0.0) {
                    miny0 = Math.min(miny0, yy);
                    maxy0 = Math.max(maxy0, yy);
                }
                ++i;
                continue;
            }
            if (nn0 > 0.0) {
                ax0 = sx0 / nn0;
                ay0 = sy0 / nn0;
                xbuilder.putValue(points, xlog ? Math.exp(ax0) : ax0);
                ybuilder.putValue(points, ylog ? Math.exp(ay0) : ay0);
                yminbuilder.putValue(points, miny0);
                ymaxbuilder.putValue(points, maxy0);
                wbuilder.putValue(points, nn0);
                ++points;
            }
            ++i;
            x0 = dxLimit * (0.5 + (double)((int)Math.floor(pxx / dxLimit)));
            y0 = dyLimit * (0.5 + (double)((int)Math.floor(pyy / dyLimit)));
            sx0 = pxx * ww;
            sy0 = pyy * ww;
            nn0 = ww;
            if (ww > 0.0) {
                miny0 = yy;
                maxy0 = yy;
                continue;
            }
            miny0 = Double.POSITIVE_INFINITY;
            maxy0 = Double.NEGATIVE_INFINITY;
        }
        if (nn0 > 0.0) {
            ax0 = sx0 / nn0;
            ay0 = sy0 / nn0;
            xbuilder.putValue(points, xlog ? Math.exp(ax0) : ax0);
            ybuilder.putValue(points, ylog ? Math.exp(ay0) : ay0);
            yminbuilder.putValue(points, miny0);
            ymaxbuilder.putValue(points, maxy0);
            wbuilder.putValue(points, nn0);
            ++points;
        }
        DDataSet yds = ybuilder.getDataSet();
        DDataSet xds = xbuilder.getDataSet();
        Map<String, Object> xprops = DataSetUtil.getProperties(x);
        if (xprops.containsKey("CADENCE")) {
            xprops.put("CADENCE", xLimit);
        }
        if (xprops.containsKey("CACHE_TAG")) {
            xprops.put("CACHE_TAG", null);
        }
        DataSetUtil.putProperties(xprops, xds);
        Map<String, Object> yprops = DataSetUtil.getProperties(y);
        yprops.put("DEPEND_0", xds);
        DataSetUtil.putProperties(yprops, yds);
        yminbuilder.putProperty("UNITS", SemanticOps.getUnits(y));
        ymaxbuilder.putProperty("UNITS", SemanticOps.getUnits(y));
        yds.putProperty("DEPEND_0", xds);
        yds.putProperty("WEIGHTS", wbuilder.getDataSet());
        yds.putProperty("DELTA_MINUS", Ops.subtract(yds, yminbuilder.getDataSet()));
        yds.putProperty("DELTA_PLUS", Ops.subtract(ymaxbuilder.getDataSet(), yds));
        logger.log(Level.FINE, "time to reduce2D({0} records -> {1} records) (ms): {2}", new Object[]{ds.length(), yds.length(), System.currentTimeMillis() - t0});
        return yds;
    }

    public static QDataSet histogram2D(QDataSet ds, QDataSet xxx, QDataSet yyy) {
        if (ds.rank() != 1) {
            throw new IllegalArgumentException("ds.rank() must be 1");
        }
        if (xxx.length() < 2) {
            throw new IllegalArgumentException("xxx.length() must be at least 2");
        }
        if (yyy.length() < 2) {
            throw new IllegalArgumentException("yyy.length() must be at least 2");
        }
        boolean xlog = "log".equals(xxx.property("SCALE_TYPE"));
        boolean ylog = "log".equals(yyy.property("SCALE_TYPE"));
        double xspace = xlog ? Math.log10(xxx.value(1)) - Math.log10(xxx.value(0)) : xxx.value(1) - xxx.value(0);
        double yspace = ylog ? Math.log10(yyy.value(1)) - Math.log10(yyy.value(0)) : yyy.value(1) - yyy.value(0);
        double xmin = xlog ? Math.log10(xxx.value(0)) - xspace / 2.0 : xxx.value(0) - xspace / 2.0;
        double ymin = ylog ? Math.log10(yyy.value(0)) - yspace / 2.0 : yyy.value(0) - yspace / 2.0;
        int nx = xxx.length();
        int ny = yyy.length();
        IDataSet result = IDataSet.createRank2(nx, ny);
        QDataSet xx = SemanticOps.xtagsDataSet(ds);
        QDataSet yy = SemanticOps.ytagsDataSet(ds);
        QDataSet ww = SemanticOps.weightsDataSet(ds);
        UnitsConverter ucx = SemanticOps.getUnitsConverter(xx, xxx);
        UnitsConverter ucy = SemanticOps.getUnitsConverter(yy, yyy);
        for (int i = 0; i < ds.length(); ++i) {
            if (!(ww.value(i) > 0.0)) continue;
            double x = ucx.convert(xx.value(i));
            double y = ucy.convert(yy.value(i));
            int ix = (int)(xlog ? (Math.log10(x) - xmin) / xspace : (x - xmin) / xspace);
            int iy = (int)(ylog ? (Math.log10(y) - ymin) / yspace : (y - ymin) / yspace);
            if (ix < 0 || ix >= nx || iy < 0 || iy >= ny) continue;
            result.addValue(ix, iy, 1.0);
        }
        result.putProperty("DEPEND_0", xxx);
        result.putProperty("DEPEND_1", yyy);
        return result;
    }
}

